﻿;================================================================= タスクトレイに収納したアプリを表示するトレイメニューをiniファイルから構築する
Loop {
	;--------------- iniファイルを読み込む
	IniRead,ttm_id,%IniFileName%,HIDDEN_APP,Id%A_Index%,-1
	IniRead,ttm_tl,%IniFileName%,HIDDEN_APP,Title%A_Index%,-1
	If (ttm_id == -1) {
		Break
	}
	;--------------- iniファイルに保存されていたIDを持つウィンドウが存在するか確認する
	DetectHiddenWindows, On
	IfWinExist, ahk_id %ttm_id%
	{
		;--------------- 存在する場合はiniファイルの情報を配列に格納する
		task_hidden_ct += 1
		task_active_id[task_hidden_ct] := ttm_id
		task_active_tl[task_hidden_ct] := ttm_tl
	}
}
DetectHiddenWindows, Off
;--------------- 配列からトレイメニューとiniファイルを構築する
Gosub BuildMinToTaskTrayMenu
;================================================================= オートIMEオン除外アプリ設定
;-------------------------------------- オートIMEオン除外アプリ情報を取得しグループに追加する
loop {
	IniRead,NotAutoIMEonAppExe_ini,%IniFileName%,NOT_AUTO_IMEON_APP,NotAutoIMEonAppExe%A_Index%,-1
	If (NotAutoIMEonAppExe_ini == -1) {
		Break
	}
	IniRead,NotAutoIMEonAppName_ini,%IniFileName%,NOT_AUTO_IMEON_APP,NotAutoIMEonAppName%A_Index%,-1
	If (NotAutoIMEonAppName_ini == -1) {
		NotAutoIMEonAppName_ini := ""
	}
	GroupAdd NotAutoIMEonApp,ahk_exe %NotAutoIMEonAppExe_ini%,%NotAutoIMEonAppName_ini%
}
;-------------------------------------- オートIMEオフアプリ情報を取得しグループに追加する
loop {
	IniRead,AutoIMEoffAppExe_ini,%IniFileName%,AUTO_IMEOFF_APP,AutoIMEoffAppExe%A_Index%,-1
	If (AutoIMEoffAppExe_ini == -1) {
		Break
	}
	IniRead,NotAutoIMEonAppName_ini,%IniFileName%,AUTO_IMEOFF_APP,AutoIMEoffAppName%A_Index%,-1
	If (AutoIMEoffAppName_ini == -1) {
		AutoIMEoffAppName_ini := ""
	}
	GroupAdd AutoIMEoffApp,ahk_exe %AutoIMEoffAppExe_ini%,%AutoIMEoffAppName_ini%
}
;================================================================= モード切替通知設定
IniRead,OnChangeModeBeep,%IniFileName%,CHANGE_MODE_NOTIFY,OnChangeModeBeep,1
IniRead,OnChangeModeToolTip,%IniFileName%,CHANGE_MODE_NOTIFY,OnChangeModeToolTip,1
IniRead,OnChangeModeToolTipDspTime,%IniFileName%,CHANGE_MODE_NOTIFY,OnChangeModeToolTipDspTime,800
;================================================================= ファイル保存ダイアログは常にIMEオン
IniRead,AlwaysIMEOnAtDialog,%IniFileName%,ALWAYS_IME_ON_AT_DIALOG,AlwaysIMEOnAtDialog,1
;================================================================= タスク切替設定
IniRead,SplitTaskSwitcher,%IniFileName%,TASK_SWITCH,SplitTaskSwitcher,0
;================================================================= キー配列＆設定
ini_file_name = %IniFileName%
ReadIniKeyhairetsu(ini_file_name,0,0)
;================================================================= マウスボタン拡張設定
IniRead,LbuttonRbutton,%IniFileName%,MOUSEBUTTON,Lbutton_Rbutton,""
IniRead,LbuttonMbutton,%IniFileName%,MOUSEBUTTON,Lbutton_Mbutton,""
IniRead,LbuttonWheelUp,%IniFileName%,MOUSEBUTTON,Lbutton_WheelUp,""
IniRead,LbuttonWheelDn,%IniFileName%,MOUSEBUTTON,Lbutton_WheelDn,""
IniRead,LbuttonXbutton1,%IniFileName%,MOUSEBUTTON,Lbutton_Xbutton1,""
IniRead,LbuttonXbutton2,%IniFileName%,MOUSEBUTTON,Lbutton_Xbutton2,""
IniRead,MbuttonLbutton,%IniFileName%,MOUSEBUTTON,Mbutton_Lbutton,""
IniRead,MbuttonRbutton,%IniFileName%,MOUSEBUTTON,Mbutton_Rbutton,""
IniRead,MbuttonWheelUp,%IniFileName%,MOUSEBUTTON,Mbutton_WheelUp,""
IniRead,MbuttonWheelDn,%IniFileName%,MOUSEBUTTON,Mbutton_WheelDn,""
IniRead,MbuttonXbutton1,%IniFileName%,MOUSEBUTTON,Mbutton_Xbutton1,""
IniRead,MbuttonXbutton2,%IniFileName%,MOUSEBUTTON,Mbutton_Xbutton2,""
IniRead,RbuttonLbutton,%IniFileName%,MOUSEBUTTON,Rbutton_Lbutton,""
IniRead,RbuttonMbutton,%IniFileName%,MOUSEBUTTON,Rbutton_Mbutton,""
IniRead,RbuttonWheelUp,%IniFileName%,MOUSEBUTTON,Rbutton_WheelUp,""
IniRead,RbuttonWheelDn,%IniFileName%,MOUSEBUTTON,Rbutton_WheelDn,""
IniRead,RbuttonXbutton1,%IniFileName%,MOUSEBUTTON,Rbutton_Xbutton1,""
IniRead,RbuttonXbutton2,%IniFileName%,MOUSEBUTTON,Rbutton_Xbutton2,""
IniRead,Xbutton1Lbutton,%IniFileName%,MOUSEBUTTON,Xbutton1_Lbutton,""
IniRead,Xbutton1Mbutton,%IniFileName%,MOUSEBUTTON,Xbutton1_Mbutton,""
IniRead,Xbutton1Rbutton,%IniFileName%,MOUSEBUTTON,Xbutton1_Rbutton,""
IniRead,Xbutton1WheelUp,%IniFileName%,MOUSEBUTTON,Xbutton1_WheelUp,""
IniRead,Xbutton1WheelDn,%IniFileName%,MOUSEBUTTON,Xbutton1_WheelDn,""
IniRead,Xbutton2Lbutton,%IniFileName%,MOUSEBUTTON,Xbutton2_Lbutton,""
IniRead,Xbutton2Mbutton,%IniFileName%,MOUSEBUTTON,Xbutton2_Mbutton,""
IniRead,Xbutton2Rbutton,%IniFileName%,MOUSEBUTTON,Xbutton2_Rbutton,""
IniRead,Xbutton2WheelUp,%IniFileName%,MOUSEBUTTON,Xbutton2_WheelUp,""
IniRead,Xbutton2WheelDn,%IniFileName%,MOUSEBUTTON,Xbutton2_WheelDn,""
IniRead,LMbuttonRbutton,%IniFileName%,MOUSEBUTTON,LMbutton_Rbutton,""
IniRead,MRbuttonLbutton,%IniFileName%,MOUSEBUTTON,MRbutton_Lbutton,""
IniRead,LRbuttonMbutton,%IniFileName%,MOUSEBUTTON,LRbutton_Mbutton,""
IniRead,LRbuttonWheelUp,%IniFileName%,MOUSEBUTTON,LRbutton_WheelUp,""
IniRead,LRbuttonWheelDn,%IniFileName%,MOUSEBUTTON,LRbutton_WheelDn,""
IniRead,Xbutton1,%IniFileName%,MOUSEBUTTON,Xbutton1,""
IniRead,Xbutton2,%IniFileName%,MOUSEBUTTON,Xbutton2,""
;================================================================= マウスホイール拡張設定
IniRead,WhSpAcc,%IniFileName%,MOUSEWHEEL,WhSpeedAcc,0
IniRead,WhSpAccMax,%IniFileName%,MOUSEWHEEL,WhSpeedAccMax,1
IniRead,WhSpAccMin,%IniFileName%,MOUSEWHEEL,WhSpeedAccMin,1
IniRead,WhSpAccSen,%IniFileName%,MOUSEWHEEL,WhSpeedAccSen,20
IniRead,ChangeVolumeOnTray,%IniFileName%,MOUSEWHEEL,ChangeVolumeOnTray,0
IniRead,EnableHorScroll,%IniFileName%,MOUSEWHEEL,EnableHorScroll,0
;================================================================= くるくるスクロール設定
IniRead,KuruHigh,%IniFileName%,KURUKURU,KurukuruHigh,3
IniRead,KuruLow,%IniFileName%,KURUKURU,KurukuruLow,1
IniRead,KuruSen,%IniFileName%,KURUKURU,KurukuruSen,2
IniRead,KuruTimeout,%IniFileName%,KURUKURU,KurukuruTimeout,50
;================================================================= トラックボールでスクロール
IniRead,EnableTrackBallScroll,%IniFileName%,TrackBallScroll,EnableTrackBallScroll,1
IniRead,TrackBallScrollAcc,%IniFileName%,TrackBallScroll,TrackBallScrollAcc,-1
IniRead,TrackBallScrollSen,%IniFileName%,TrackBallScroll,TrackBallScrollSen,5
;================================================================= マウスでウィンドウ操作設定を保存する
IniRead,EnableMinTTrayByMButton,%IniFileName%,OPEWINBYMOUSE,EnableMinTTrayByMButton,1
IniRead,EnableResizeByWheel,%IniFileName%,OPEWINBYMOUSE,EnableResizeByWheel,1
IniRead,ActvOnWheel,%IniFileName%,OPEWINBYMOUSE,ActivateOnWheel,1
IniRead,EnableMinAllByWheelOnStBtn,%IniFileName%,OPEWINBYMOUSE,EnableMinAllByWheelOnStBtn,1
IniRead,MinimizeByWheelOnTaskIcon,%IniFileName%,OPEWINBYMOUSE,MinimizeByWheelOnTaskIcon,1
;================================================================= マウスボタンの左右反転
IniRead,SwapMouseButtons,%IniFileName%,MOUSEBUTTON,SwapMouseButtons,0
buttonState := DllCall("user32.dll\SwapMouseButton", "UInt", SwapMouseButtons)
;RegRead, SwapMouseButtons, HKEY_CURRENT_USER\Control Panel\Mouse, SwapMouseButtons
;================================================================= マウスホイールのスクロール反転
IniRead,MouseWheelReverse,%IniFileName%,MOUSEWHEEL,MouseWheelReverse,0
;================================================================= ウィンドウ下端でホイールを回転させたときだけタスクバーを表示する
IniRead,ShowTaskbarWhenMouseWheel,%IniFileName%,MOUSEWHEEL,ShowTaskbarWhenMouseWheel,0
ShowTaskBarForce := 0
;================================================================= マウスジェスチャー設定
CoordMode,Mouse,Screen
MG_GridWinName := "MouseGesture"
MG_GridImgName = %A_ScriptDir%\img\mg_grid.png
MG_GridCelImgName = %A_ScriptDir%\img\mg_grid_cel.png
MG_GridImgSize := 316
MG_CelSize := 63
MG_CelHafgSize := (MG_CelSize - 1) / 2
MG_CelOffset := 157
MG_CelCount := 25
MG_String := Object()
MG_Command := Object()
MG_AppName := Object()
MG_AppNeedTitle := Object()
MG_ModeTbl := Object()
MG_EnableTbl := Object()
MG_TraceWinName := "MouseGestureTrace"
MG_TrCmdWinName := "MouseGestureTraceCmd"
MG_TraceImageName = %A_ScriptDir%\img\mg_tr
MG_TraceImgSize := 63
MG_TraceCmdWidth := 200
MG_ActCnt := 0
;--------------- マウスジェスチャー・グリッドを表示するGUI画面を定義する（+E0x00020020はクリックスル―:半透明にすると有効になる）
;Gui, MG_Grid: New, +AlwaysOnTop +ToolWindow -Caption -Border +E0x00020020
Gui, MG_Grid: New, +AlwaysOnTop +ToolWindow -Caption -Border
Gui, MG_Grid: Font, s10 ;Bold
Gui, MG_Grid: Add, Picture, X0 Y0, %MG_GridImgName%
Gui, MG_Grid: Add, Picture, X%MG_GridImgSize% Y%MG_GridImgSize% vMG_SelectedCel, %MG_GridCelImgName%
;--------------- マウスジェスチャー・軌道画像を表示するGUI画面を定義する
Gui, MG_Trace: New, +AlwaysOnTop +ToolWindow -Caption -Border ;+E0x00020020
Gui, MG_Trace: Add, Picture, X0 Y0 vMG_TraceImage
Gui, MG_Trace: Color, 000000
;Gui, MG_Trace: Show, W%MG_TraceImgSize% H%MG_TraceImgSize% X999999 Y999999 Minimize, %MG_TraceWinName%
;Gui, MG_Trace: Show, W%MG_TraceImgSize% H%MG_TraceImgSize% X999999 Y999999 Restore, %MG_TraceWinName%
Gui, MG_Trace: Show, W%MG_TraceImgSize% H%MG_TraceImgSize% X999999 Y999999, %MG_TraceWinName%
WinSet, TransColor, 000000, %MG_TraceWinName%
;--------------- マウスジェスチャー・機能名を表示するGUI画面を定義する
Gui, MG_TrCmd: New, +AlwaysOnTop +ToolWindow -Caption -Border
Gui, MG_TrCmd: Color, FFFFFF
Gui, MG_TrCmd: Font, s12 Bold
Gui, MG_TrCmd: Add, Text, X0 Y8 vMG_TrCmd w%MG_TraceCmdWidth% Center BackgroundTrans,
Gui, MG_TrCmd: Show, X999999 Y999999, %MG_TrCmdWinName%
;WinSet, TransColor, FFFFFF, %MG_TrCmdWinName%
;WinSet, Transparent, 220, %MG_TrCmdWinName%
;--------------- iniファイルからマウスジェスチャー情報を取得し配列に格納する
Loop {
	;--------------- 登録されているマウスジェスチャー名を取得する
	IniRead,mg_name,%IniFileName%,MOUSEGESTURE_NAME,MgName%A_Index%,-1
	If (mg_name == -1) {
		Break
	}
	;--------------- ジェスチャーモードを取得する
	IniRead,mg_gmode,%IniFileName%,MOUSEGESTURE_MODE,MgMode%A_Index%,1
	MG_ModeTbl[mg_name] := mg_gmode
	;--------------- ジェスチャー使用可否設定を取得する
	IniRead,mg_enable,%IniFileName%,MOUSEGESTURE_ENABLE,MgEnable%A_Index%,1
	MG_EnableTbl[mg_name] := mg_enable
	;--------------- マウスジェスチャーの機能名とコマンド内容を取得する
	Loop {
		IniRead,mg_str,%IniFileName%,MOUSEGESTURE_%mg_name%,MgStr%A_Index%,-1
		IniRead,mg_cmd,%IniFileName%,MOUSEGESTURE_%mg_name%,MgCmd%A_Index%,-1
		If (mg_str == -1) {
			Break
		}
		MG_String[mg_name,A_Index] := mg_str
		MG_Command[mg_name,A_Index] := mg_cmd
	}
}
;--------------- iniファイルからマウスジェスチャーの使用方法の設定情報を取得する
IniRead,mg_use_default,%IniFileName%,MOUSEGESTURE_USE_DEFAULT,MgUseDefault,1
;--------------- iniファイルからマウスジェスチャーを割当てたアプリ情報を取得し配列に格納する
Loop {
	IniRead,mg_app_name,%IniFileName%,MOUSEGESTURE_APP,MgAppName%A_Index%,-1
	If (mg_app_name == -1) {
		Break
	}
	IniRead,mg_app_title,%IniFileName%,MOUSEGESTURE_APP,MgAppTitle%A_Index%,-1
	;--------------- アプリタイトルも指定されているか確認する
	If (StrLen(mg_app_title) > 0) {
		MG_AppNeedTitle[mg_app_name] := 1
	}Else{
		MG_AppNeedTitle[mg_app_name] := 0
	}
	IniRead,mg_assign,%IniFileName%,MOUSEGESTURE_APP_%mg_app_name%%mg_app_title%,MgAssign,-1
	ix = %mg_app_name%%mg_app_title%
	MG_AppName[ix] := mg_assign
}
Loop %MG_CelCount% {
	;--------------- マウスジェスチャーのコマンド名称表示するテキストエリアをグリッド上に配置する
	MG_xCelNo := Mod(A_Index - 1,5)
	MG_yCelNo := (A_Index - 1) // 5
	MG_GridX := MG_xCelNo * MG_CelSize + 5
	MG_GridY := MG_yCelNo * MG_CelSize + 5
	MG_GridW := MG_CelSize - 10
	Gui, MG_Grid: Add, Text, vMG_CellName%A_Index% X%MG_GridX% Y%MG_GridY% W%MG_GridW% H%MG_GridW% Center BackgroundTrans, dummy
}
;--------------- マウスジェスチャー・グリッドを表示する
;Gui, MG_Grid: Show, W%MG_GridImgSize% H%MG_GridImgSize% X9999 Y9999 Minimize, %MG_GridWinName%
;--------------- マウスジェスチャー・グリッドを表示するGUI画面のIDを取得する
;WinGet MG_TraceID, ID, %MG_GridWinName%
;--------------- マウスジェスチャー・グリッドを表示するGUI画面を透過型にする
;WinSet Transparent, 254, ahk_id %MG_TraceID%
;Gui, MG_Grid: Show, W%MG_GridImgSize% H%MG_GridImgSize% X9999 Y9999 Restore, %MG_GridWinName%
;-------------------------------------- 右クリックで対象ウィンドウを変更するアプリ情報を取得しグループに追加する
loop {
	IniRead,MgRClickAppName_ini,%IniFileName%,MOUSEGESTURE_RCLICK_APP,MgRClickAppName%A_Index%,-1
	If (MgRClickAppName_ini == -1) {
		Break
	}
	IniRead,MgRClickAppTitle_ini,%IniFileName%,MOUSEGESTURE_RCLICK_APP,MgRClickAppTitle%A_Index%,-1
	If (MgRClickAppTitle_ini == -1) {
		MgRClickAppTitle_ini := ""
	}
	GroupAdd MG_RClickApp,ahk_exe %MgRClickAppName_ini%, %MgRClickAppTitle_ini%
}
;================================================================= 準備完了通知
;------------------------------ 通知音をならす
If (OnChangeModeBeep == 1) {
	SoundBeep,800,100
}
;------------------------------ 通知メッセージを表示する
;If (OnChangeModeToolTip == 1) {
	ShowSplashImage(ThisAppName . "が使用可能になりました")
	SetTimer RemoveSplashImage,2000
;}
;================================================================= 関数・サブルーチンをインクルード
;-------------------------------------- マウス操作（一番最初にインクルードすること）
#Include %A_ScriptDir%\SubMouse.ahk
;-------------------------------------- タスク制御
#Include %A_ScriptDir%\SubTask.ahk
#Include %A_ScriptDir%\SubTaskSwitcher.ahk
;-------------------------------------- About & Help
#Include %A_ScriptDir%\SubAboutAndHelp.ahk
;-------------------------------------- ツール
#Include %A_ScriptDir%\SubTool.ahk
;-------------------------------------- IME
#Include %A_ScriptDir%\SubIME.ahk
;-------------------------------------- クリップボード
;#Include %A_ScriptDir%\SubClipboard.ahk
;-------------------------------------- キー送信
#Include %A_ScriptDir%\SubSendKey.ahk
;-------------------------------------- 機能設定
#Include %A_ScriptDir%\SubConfigPanel.ahk
;-------------------------------------- キー配列設定
#Include %A_ScriptDir%\SubConfigKeyhairetsu.ahk
;-------------------------------------- キー配列プリセット設定
#Include %A_ScriptDir%\SubConfigKeyPreset.ahk
;-------------------------------------- マウス拡張設定
#Include %A_ScriptDir%\SubConfigMouse.ahk
#Include %A_ScriptDir%\SubConfigMouseGesture.ahk
;================================================================= スクリプトをリロードする
ReloadApplication:
	Reload
Return
;================================================================= スクリプトを一時停止する
SuspendApplication:
	Menu Tray,ToggleCheck, 一時停止
	If (A_IsSuspended == 1) {
		;-------------------------------------- タスクバーの表示・非表示を切り替える
		If (ShowTaskbarWhenMouseWheel == 1 && BufShowTaskBarForce == 0) {
			BufShowTaskBarForce := ShowTaskBarForce
			ShowTaskBarForce := 0
			HideTaskBar()
		}
		Suspend Off
	}Else{
		;-------------------------------------- タスクバーの表示・非表示を切り替える
		If (ShowTaskbarWhenMouseWheel == 1 && ShowTaskBarForce == 0) {
			BufShowTaskBarForce := ShowTaskBarForce
			ShowTaskBarForce := 1
			ShowTaskBar()
		}
		Suspend On
	}
Return
;================================================================= スクリプトを終了する
ExitApplication:
	Msgbox 4,　,アプリケーションを終了しますか？
	IfMsgBox, Yes
	{
		Gosub RestoreAllWinFromTaskTray
		ExitApp
	}
Return
