﻿;================================================================= LButton
;タスクマネージャーなどの管理ツールを開いていると、他のウィンドウの左クリックが無効になるため廃止。
;同じ理由で右クリックも無効になるが、マウスジェスチャー機能に影響が出るので右クリックはそのままにする。
;各種設定画面のタイトルバーの閉じるボタンが押せなくなるので、必ず閉じるボタンを追加すること
;LButton::
;	If (GetKeyState("RButton","p") || GetKeyState("MButton","p") || GetKeyState("XButton1","p") || GetKeyState("XButton2","p")) {
		;--------------- マウス拡張機能が実行されたときは何もしない
;		Return
;	}Else{
;		Send {LButton Down}
;	}
;Return
;================================================================= LButton up
~LButton up::
	;--------------- マウスジェスチャー起動後のクリック防止判定変数をセットする
	NoXbutton1 := 0
	NoXbutton2 := 0
	;--------------- 中と右ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("MButton","p") && GetKeyState("RButton","p")) {
		;--------------- マウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- マウスジェスチャーキャンセル変数をオンにする
		cancel_mouse_ges := 1
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := MRbuttonLbutton
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- マウスジェスチャーキャンセル変数がオンのときはなにもしない
	If (cancel_mouse_ges == 1) {
		;--------------- マウスジェスチャーキャンセル変数をオフにする
		cancel_mouse_ges := 0
		Return
	}
	;--------------- 右ボタンを押しながらのマウス拡張機能が実行されたとき
	If (GetKeyState("RButton","p")) {
		;--------------- マウスジェスチャー・グリッドが表示されていたら隠す
		If (MG_Disp == 1) {
			;--------------- マウスジェスチャー・グリッドを隠す（「最小化→元に戻す」にしないと外枠が表示されてしまう）
			Gui, MG_Grid: Show, W%MG_GridImgSize% H%MG_GridImgSize% X%ShowPosX% Y%ShowPosY% Minimize, %MG_GridWinName%
			Gui, MG_Grid: Show, W%MG_GridImgSize% H%MG_GridImgSize% X%ShowPosX% Y%ShowPosY% Restore, %MG_GridWinName%
			Gui, MG_Grid: Hide
			Return
		}
		;--------------- マウスジェスチャー軌道画像が表示されていたら隠す
		If (MG_Disp == 2) {
			Gui,MG_Trace: Hide
			Gui,MG_TrCmd: Hide
			;MG_ActCnt := 0
			Return
		}
		;--------------- マウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := RbuttonLbutton
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- 中ボタンを押しながらのマウス拡張機能が実行されたとき
	If (GetKeyState("MButton","p")) {
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := MbuttonLbutton
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- X1ボタンを押しながらのマウス拡張機能が実行されたとき
	If (GetKeyState("XButton1","p")) {
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := Xbutton1Lbutton
		Gosub SendKeyOrSearch
		;--------------- マウスジェスチャー起動後の中クリック防止判定変数をセットする
		NoXbutton1 := 1
		Return
	}
	;--------------- X1ボタンを押しながらのマウス拡張機能が実行されたとき
	If (GetKeyState("XButton2","p")) {
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := Xbutton2Lbutton
		Gosub SendKeyOrSearch
		;--------------- マウスジェスチャー起動後の中クリック防止判定変数をセットする
		NoXbutton2 := 1
		Return
	}
	;--------------- 左ボタンを押した時点で左ダウンさせているが、ここでの解除は不要
	;Send {LButton Up}
Return
;================================================================= Shift + LButton
~Shift & LButton::
	If (GetKeyState("alt","p")) {
		Send +!{LButton Down}
	}Else{
		Send +{LButton Down}
	}
Return
;================================================================= Shift + LButton
~Shift & LButton up::
	If (GetKeyState("alt","p")) {
		Send +!{LButton Up}
	}Else{
		Send +{LButton Up}
	}
Return
;================================================================= RButton
RButton::
	;--------------- タスクバー領域でボタンが押されたか判定する
	Res := IsTaskbarControlUnderMouse(win_id,WinCtrlClass)
	If (Res == 1) {
		;--------------- タスクバー領域でボタンが押されたときは何もせず判定変数をセットする
		RButtonDownlOnTaskbar := 1
		NeedRUp := 0
		enable_mouse_ges := 0
	}Else{
		;--------------- タスクバー領域以外でボタンが押されたときは判定変数をクリアする
		RButtonDownlOnTaskbar := 0
		;--------------- タスクスイッチャーで右クリックしたときは、マウスジェスチャーを無効にする
		If (RBtnDnAtTaskSwitcher == 1) {
			;Send {RButton Down}
			NeedRUp := 1
			enable_mouse_ges := 0
			RBtnDnAtTaskSwitcher := 0
			Return
		}
		;--------------- 他ボタンを起点とするマウスジェスチャー発動時の時は何もしない
		If (GetKeyState("LButton","p") || GetKeyState("MButton","p") || GetKeyState("XButton1","p") || GetKeyState("XButton2","p")) {
			NeedRUp := 0
			enable_mouse_ges := 0
			Return
		}
		;--------------- ジェスチャー使用方法を判定する
		Gosub GetMGappInfo
		If (MG_Name == "標準" && mg_use_default == "0" || GetKeyState("sc07B","p" ) || GetKeyState("sc079","p")) {
			;--------------- ジェスチャー未割当アプリではジェスチャーを使わない設定になっているか、無変換または変換キーを押しながら右ボタンを押したときは右ドラッグを有効にする
			If (SwapMouseButtons == 0) {
				Send {blind}{RButton Down}
			}Else{
				;--------------- マウスボタンを反転しているときは左ボタンを押す
				Send {blind}{LButton Down}
			}
			NeedRUp := 1
			enable_mouse_ges := 0
		}Else{
			;--------------- 右ボタンを単独で押したときはマウスジェスチャーを有効にする
			NeedRUp := 0
			Gosub EnableMouseGesture
			;--------------- マウスジェスチャーの実行モードを特定する
			mg_mode := MG_ModeTbl[MG_Name]
		}
	}
Return
;================================================================= RButton up
RButton up::
	;--------------- マウスジェスチャー起動後のクリック防止判定変数をセットする
	NoXbutton1 := 0
	NoXbutton2 := 0
	;--------------- 左と中ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("LButton","p") && GetKeyState("MButton","p")) {
		;--------------- マウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- マウスジェスチャーキャンセル変数をオンにする
		cancel_mouse_ges := 1
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LMbuttonRbutton
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- マウスジェスチャーキャンセル変数がオンのときはなにもしない
	If (cancel_mouse_ges == 1) {
		;--------------- マウスジェスチャーキャンセル変数をオフにする
		cancel_mouse_ges := 0
		Return
	}
	;--------------- 左ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("LButton","p")) {
		;--------------- マウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LbuttonRbutton
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- 中ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("MButton","p")) {
		;--------------- マウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := MbuttonRbutton
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- X1ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("XButton1","p")) {
		;--------------- マウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := Xbutton1Rbutton
		Gosub SendKeyOrSearch
		;--------------- マウスジェスチャー起動後のX1クリック防止判定変数をセットする
		NoXbutton1 := 1
		Return
	}
	;--------------- X2ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("XButton2","p")) {
		;--------------- マウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := Xbutton2Rbutton
		Gosub SendKeyOrSearch
		;--------------- マウスジェスチャー起動後のX2クリック防止判定変数をセットする
		NoXbutton2 := 1
		Return
	}
	;--------------- 直前のホットキーがマウス右ボタンのときはマウスジェスチャーを発動させる
	If (A_PriorHotkey == "RButton") {
		;--------------- マウスジェスチャー対象のときはマウスジェスチャーを発動させる
		If (enable_mouse_ges == 1) {
			MG_Done := 0
			Gosub ExecMouseGesture
			;--------------- マウス右ボタンをすぐ離したときは右クリックを送る
			If (MG_Done == 0) {
				If (SwapMouseButtons == 0) {
					Send {blind}{RButton}
				}Else{
					;--------------- マウスボタンを反転しているときは左クリックを送る
					Send {blind}{LButton}
				}
			}
		}Else{
			;--------------- マウスジェスチャー対象外のときは右クリックを送る
			If (NeedRUp == 1) {
				If (SwapMouseButtons == 0) {
					Send {blind}{RButton Up}
				}Else{
					
					Send {blind}{LButton Up}
				}
			}Else{
				If (SwapMouseButtons == 0) {
					Send {blind}{RButton}
				}Else{
					;--------------- マウスボタンを反転しているときは左クリックを送る
					Send {blind}{LButton}
				}
			}
		}
	}Else{
		;--------------- 直前のホットキーがマウス右ボタンでないときはマウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- 右クリックが必要な時は右クリックを送る
		If (NeedRUp == 1) {
			If (SwapMouseButtons == 0) {
				Send {blind}{RButton}
			}Else{
				;--------------- マウスボタンを反転しているときは左クリックを送る
				Send {blind}{LButton}
			}
			;--------------- 右クリックメニューを消去する
			;ジェスチャー未割当アプリではジェスチャーを使わない設定になっているか、無変換または変換キーを押しながら右ボタンを押したときはここに来る
			Send {Esc}
		}
	}
Return
;================================================================= Shift + RButton
~Shift & RButton::
	Send +{RButton Down}
Return
;================================================================= Shift + RButton
~Shift & RButton up::
	Send +{RButton Up}
Return
;================================================================= MButton
;中ボタンドラッグが無効になるため廃止
;MButton::Return
MButton up::
	;--------------- マウスジェスチャーキャンセル変数がオンのときはなにもしない
	If (cancel_mouse_ges == 1) {
		;--------------- マウスジェスチャーキャンセル変数をオフにする
		cancel_mouse_ges := 0
		Return
	}
	;--------------- 左と右ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("LButton","p") && GetKeyState("RButton","p")) {
		;--------------- マウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- マウスジェスチャーキャンセル変数をオンにする
		cancel_mouse_ges := 1
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LRbuttonMbutton
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- 左ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("LButton","p")) {
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LbuttonMbutton
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- 右ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("RButton","p")) {
		;--------------- マウスジェスチャー・グリッドが表示されていたら隠す
		If (MG_Disp == 1) {
			;--------------- マウスジェスチャー・グリッドを隠す（「最小化→元に戻す」にしないと外枠が表示されてしまう）
			Gui, MG_Grid: Show, W%MG_GridImgSize% H%MG_GridImgSize% X%ShowPosX% Y%ShowPosY% Minimize, %MG_GridWinName%
			Gui, MG_Grid: Show, W%MG_GridImgSize% H%MG_GridImgSize% X%ShowPosX% Y%ShowPosY% Restore, %MG_GridWinName%
			Gui, MG_Grid: Hide
			Return
		}
		;--------------- マウスジェスチャー実行可能状態をオフにする
		enable_mouse_ges := 0
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := RbuttonMbutton
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- X1ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("XButton1","p")) {
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := Xbutton1Mbutton
		Gosub SendKeyOrSearch
		;--------------- マウスジェスチャー起動後のX1クリック防止判定変数をセットする
		NoXbutton1 := 1
		Return
	}
	;--------------- X2ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("XButton2","p")) {
		;--------------- マウスカーソル下のウィンドウをアクティブにする
		ActivateUnderMouseWindow()
		;--------------- iniファイルで指定されたショートカットを実行する
		key := Xbutton2Mbutton
		Gosub SendKeyOrSearch
		;--------------- マウスジェスチャー起動後のX2クリック防止判定変数をセットする
		NoXbutton2 := 1
		Return
	}
	;--------------- タイトルバーを中ボタンクリックでタスクトレイに収納
	If (EnableMinTTrayByMButton == 1) {
		;--------------- マウスカーソル下がタイトルバーか確認
		Res := IsMouseOnActiveWinTitleBar()
		If (Res == True) {
			Gosub SubMinimizeToTaskTray
		}
	}
Return
;================================================================= XButton1
XButton1::Return
XButton1 up::
	;--------------- マウスカーソル下のウィンドウをアクティブにする
	ActivateUnderMouseWindow()
	;--------------- 左ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("LButton","p")) {
		;--------------- マウスジェスチャー起動後のX1クリック防止判定変数をセットする
		NoXbutton1 := 1
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LbuttonXbutton1
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- 中ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("MButton","p")) {
		;--------------- マウスジェスチャー起動後のX1クリック防止判定変数をセットする
		NoXbutton1 := 1
		;--------------- iniファイルで指定されたショートカットを実行する
		key := MbuttonXbutton1
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- 右ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("RButton","p")) {
		;--------------- マウスジェスチャー起動後のX1クリック防止判定変数をセットする
		NoXbutton1 := 1
		;--------------- iniファイルで指定されたショートカットを実行する
		key := RbuttonXbutton1
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- マウスジェスチャー起動後のX1クリック防止
	If (NoXbutton1 == 1) {
		;--------------- マウスジェスチャー起動後のX1クリック防止
		NoXbutton1 := 0
	}Else{
		;--------------- iniファイルで指定されたショートカットを実行する
		key := XButton1
		Gosub SendKeyOrSearch
	}
Return
;================================================================= XButton2
XButton2::Return
XButton2 up::
	;--------------- マウスカーソル下のウィンドウをアクティブにする
	ActivateUnderMouseWindow()
	;--------------- 左ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("LButton","p")) {
		;--------------- マウスジェスチャー起動後のX2クリック防止判定変数をセットする
		NoXbutton2 := 1
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LbuttonXbutton2
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- 中ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("MButton","p")) {
		;--------------- マウスジェスチャー起動後のX2クリック防止判定変数をセットする
		NoXbutton2 := 1
		;--------------- iniファイルで指定されたショートカットを実行する
		key := MbuttonXbutton2
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- 右ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("RButton","p")) {
		;--------------- マウスジェスチャー起動後のX2クリック防止判定変数をセットする
		NoXbutton2 := 1
		;--------------- iniファイルで指定されたショートカットを実行する
		key := RbuttonXbutton2
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- マウスジェスチャー起動後のX2クリック防止
	If (NoXbutton2 == 1) {
		;--------------- マウスジェスチャー起動後のX2クリック防止
		NoXbutton2 := 0
	}Else{
		;--------------- iniファイルで指定されたショートカットを実行する
		key := XButton2
		Gosub SendKeyOrSearch
	}
Return
;================================================================= Wheel
;-------------------------------------- マウスホイール拡張
WheelUp::
WheelDown::
	;------------------------------ ウィンドウ下端でホイールを回転させたときだけタスクバーを表示する設定がオンの時
	If (ShowTaskbarWhenMouseWheel == 1) {
		;------------------------------ マウスカーソルが存在するモニターの番号を取得する
		WhereIsCursorOnMonitor(MonNo, MousePosX, MousePosY, MonCount)
		;------------------------------ モニターサイズを取得する
		SysGet m,MonitorWorkArea,%MonNo%
		TargetPosY := mBottom - 1
		;------------------------------ マウスカーソルがウィンドウ下端にあるか？
		If (MousePosY >= TargetPosY) {
			;------------------------------ タスクバーを表示する
			ShowTaskBar()
		}
	}
	;--------------- ホイールタイプをセット
	IF (MouseWheelReverse == 1) {
		;--------------- スクロールを反転するとき
		If (A_ThisHotkey == "WheelDown") {
			wheeltype := "WheelUp"
		}Else{
			wheeltype := "WheelDown"
		}
	}Else{
		wheeltype := A_ThisHotkey
	}
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- マウスホイールの加速
	If (WhSpAcc == 1) {
		If (A_TimeSincePriorHotkey <= WhSpAccSen) {
			count = %WhSpAccMax%
		}Else{
			count = %WhSpAccMin%
		}
		MouseClick %wheeltype%,,,%count%
	}Else{
		MouseClick %wheeltype%,,,1
	}
Return
;--------------- 左ボタンを押しながらのマウス拡張機能が実行されたとき
~LButton & WheelUp::
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- 左と右ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("RButton","p")) {
		;--------------- マウスジェスチャーキャンセル変数をオンにする
		cancel_mouse_ges := 1
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LRbuttonWheelUp
		Gosub SendKeyOrSearch
	}Else{
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LbuttonWheelUp
		Gosub SendKeyOrSearch
	}
Return
;--------------- 左ボタンを押しながらのマウス拡張機能が実行されたとき
~LButton & WheelDown::
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- 左と右ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("RButton","p")) {
		;--------------- マウスジェスチャーキャンセル変数をオンにする
		cancel_mouse_ges := 1
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LRbuttonWheelDn
		Gosub SendKeyOrSearch
	}Else{
		;--------------- iniファイルで指定されたショートカットを実行する
		key := LbuttonWheelDn
		Gosub SendKeyOrSearch
	}
Return
;--------------- 右ボタンを押しながらのマウス拡張機能が実行されたとき
~RButton & WheelUp::
~RButton & WheelDown::
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- マウスジェスチャー実行可能状態をオフにする
	enable_mouse_ges := 0
	;--------------- ホイール回転方向に応じて処理を変更する
	IfInString, A_ThisHotkey, WheelUp
	{
		;--------------- ホイールタイプをセット
		wheeltype := "WheelUp"
		;--------------- 送信キーをセット
		key := RbuttonWheelUp
	}Else{
		;--------------- ホイールタイプをセット
		wheeltype := "WheelDown"
		;--------------- 送信キーをセット
		key := RbuttonWheelDn
	}
	;--------------- 左と右ボタンを押しながらマウス拡張機能が実行されたとき
	If (GetKeyState("LButton","p")) {
		;--------------- マウスジェスチャーキャンセル変数をオンにする
		cancel_mouse_ges := 1
		;--------------- iniファイルで指定されたショートカットを実行する
		If (wheeltype == "WheelUp") {
			key := LRbuttonWheelUp
		}Else{
			key := LRbuttonWheelDn
		}
		Gosub SendKeyOrSearch
		Return
	}
	;--------------- タスクバー領域で実行されたか判定する
	If (RButtonDownlOnTaskbar == 1) {
		;--------------- タスクバー領域で実行されたときはホイール回転時の拡張コマンドを実行する
		;--------------- タスクトレイ上のホイール回転で音量変更
		If (ChangeVolumeOnTray == 1) {
			ChangeVolumeOnTray(wheeltype,WinCtrlClass)
		}
		;--------------- スタートボタン上のホイール回転ですべてのウィンドウを最小化/元に戻す
		If (EnableMinAllByWheelOnStBtn == 1) {
			MinAllByWheelOnStBtn(wheeltype,WinCtrlClass)
		}
		;--------------- タスクバーアイコン上のホイール回転で起動/最小化/元に戻す
		If (MinimizeByWheelOnTaskIcon == 1) {
			MinimizeByWheelOnTaskIcon(wheeltype,win_id,WinCtrlClass,SwapMouseButtons)
		}
	}Else{
		;--------------- タイトルバー上のホイール回転で最大化/リサイズ/最小化
		If (EnableResizeByWheel == 1) {
			;--------------- マウスホイール回転でウィンドウをアクティブにする
			If (ActvOnWheel == 1) {
				ActivateUnderMouseWindow()
			}
			;--------------- マウスカーソルがアクティブウィンドウのタイトルバーの上にあるか判定する
			Res := IsMouseOnActiveWinTitleBar()
			If (Res == True) {
				If (wheeltype == "WheelUp") {
					Gosub SubMaximizeActvWin
				}Else{
					Gosub SubMinimizeActvWin
				}
				Return
			}
		}
		;--------------- タスクバー領域以外で実行されたときは通常の拡張コマンドを実行する
		;--------------- iniファイルで指定されたショートカットを実行する
		Gosub SendKeyOrSearch
	}
Return
;--------------- 中ボタンを押しながらのマウス拡張機能が実行されたとき
~MButton & WheelUp::
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- iniファイルで指定されたショートカットを実行する
	key := MbuttonWheelUp
	Gosub SendKeyOrSearch
Return
;--------------- 中ボタンを押しながらのマウス拡張機能が実行されたとき
~MButton & WheelDown::
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- iniファイルで指定されたショートカットを実行する
	key := MbuttonWheelDn
	Gosub SendKeyOrSearch
Return
;--------------- X1ボタンを押しながらのマウス拡張機能が実行されたとき
XButton1 & WheelUp::
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- iniファイルで指定されたショートカットを実行する
	key := Xbutton1WheelUp
	Gosub SendKeyOrSearch
	;--------------- マウスジェスチャー起動後のX1クリック防止判定変数をセットする
	NoXbutton1 := 1
Return
;--------------- X1ボタンを押しながらのマウス拡張機能が実行されたとき
XButton1 & WheelDown::
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- iniファイルで指定されたショートカットを実行する
	key := Xbutton1WheelDn
	Gosub SendKeyOrSearch
	;--------------- マウスジェスチャー起動後のX1クリック防止判定変数をセットする
	NoXbutton1 := 1
Return
;--------------- X2ボタンを押しながらのマウス拡張機能が実行されたとき
XButton2 & WheelUp::
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- iniファイルで指定されたショートカットを実行する
	key := Xbutton2WheelUp
	Gosub SendKeyOrSearch
	;--------------- マウスジェスチャー起動後のX2クリック防止判定変数をセットする
	NoXbutton2 := 1
Return
;--------------- X2ボタンを押しながらのマウス拡張機能が実行されたとき
XButton2 & WheelDown::
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- iniファイルで指定されたショートカットを実行する
	key := Xbutton2WheelDn
	Gosub SendKeyOrSearch
	;--------------- マウスジェスチャー起動後のX2クリック防止判定変数をセットする
	NoXbutton2 := 1
Return
;--------------- Shiftキーを押しながらホイールで水平スクロール
~Shift & WheelUp::
~Shift & WheelDown::
	If (EnableHorScroll == 1) {
		;--------------- ホイールタイプをセット
		wheeltype := A_ThisHotkey
		;--------------- マウスホイール回転でウィンドウをアクティブにする
		If (ActvOnWheel == 1) {
			ActivateUnderMouseWindow()
		}
		;--------------- ホイール回転方向に応じて処理を変更する
		IfInString, A_ThisHotkey, WheelUp
		{
			Gosub SubMouseWhLeft
		}Else{
			Gosub SubMouseWhRight
		}
	}
Return