﻿キー配列設定:
	;-------------------------------------- 既に設定画面を開いているときは何もしない
	If (ExistConfigKeyPreset == 1) {
		Return
	}Else{
		ExistConfigKeyPreset := 1
	}
	;-------------------------------------- 画面を新規作成する
	GuiTitle := "キー配列設定"
	Gui,1: New,, %GuiTitle%
	Gui,1: Font, s11
	Gui,1: Add, GroupBox, x22 y17 w870 h460 , プリセット配列
	;=========================================== iniファイルを読みプリセットの選択状態を再現する
	section = KEY_PRESET
	;-------------------------------------- 半角英数
	Gui,1: Add, GroupBox, x42 y47 w410 h60 , 半角英数
	IniRead,AlpQwerty,%IniFileName%,%section%,AlpQwerty,1
	IniRead,AlpDvorak,%IniFileName%,%section%,AlpDvorak,0
	Gui,1: Add, Radio, x62 y67 w120 h30 Checked%AlpQwerty% vRdoAlpQwerty, QWERTY配列
	Gui,1: Add, Radio, x252 y67 w150 h30 Checked%AlpDvorak% vRdoAlpDvorak, Dvorak配列
	;-------------------------------------- 日本語
	Gui,1: Add, GroupBox, x42 y122 w410 h150 , 日本語
	IniRead,KanRomaQwerty,%IniFileName%,%section%,KanRomaQwerty,1
	IniRead,KanKanaEisuShift,%IniFileName%,%section%,KanKanaEisuShift,0
	IniRead,KanRomaDvorak,%IniFileName%,%section%,KanRomaDvorak,0
	IniRead,KanKanaKanaShift,%IniFileName%,%section%,KanKanaKanaShift,0
	IniRead,KanOyayubiShift,%IniFileName%,%section%,KanKanOyayubiShift,0
	IniRead,KanOyayubi3Shift,%IniFileName%,%section%,KanKanOyayubi3Shift,0
	Gui,1: Add, Radio, x62 y147 w140 h30 Checked%KanRomaQwerty% vRdoKanRomaQwerty gOnClickRdoKanRomaQwerty, ローマ字入力(QWERTY配列)
	Gui,1: Add, Radio, x62 y197 w110 h30 Checked%KanRomaDvorak% vRdoKanRomaDvorak gOnClickRdoKanRomaDvorak, ローマ字入力(Dvorak配列)
	Gui,1: Add, Radio, x232 y147 w210 h20 Checked%KanKanaEisuShift% vRdoKanKanaEisuShift gOnClickRdoKanKanaEisuShift, JISかな入力（英数親指シフト）
	Gui,1: Add, Radio, x232 y177 w200 h20 Checked%KanKanaKanaShift% vRdoKanKanaKanaShift gOnClickRdoKanKanaKanaShift, JISかな入力（かな親指シフト）
	Gui,1: Add, Radio, x232 y207 w190 h20 Checked%KanOyayubiShift% vRdoKanOyayubiShift gOnClickRdoKanOyayubiShift, 親指シフト（NICOLA配列）
	Gui,1: Add, Radio, x232 y237 w190 h20 Checked%KanOyayubi3Shift% vRdoKanOyayubi3Shift gOnClickRdoKanOyayubi3Shift, 親指シフト（第3シフト使用）
	If (KanOyayubiShift == 1) {
		RdoMuhenkanDisabled := 1
		RdoHenkanDisabled := 1
	}Else{
		If (KanOyayubi3Shift == 1) {
			RdoMuhenkanDisabled := 0
			RdoHenkanDisabled := 1
		}Else{
			RdoMuhenkanDisabled := 0
			RdoHenkanDisabled := 0
		}
	}
	;-------------------------------------- コピー＆ペースト
	Gui,1: Add, GroupBox, x42 y287 w410 h100 , コピー＆ペースト
	IniRead,CpyMuhenkan,%IniFileName%,%section%,CpyMuhenkan,1
	IniRead,CpyHenkan,%IniFileName%,%section%,CpyHenkan,0
	IniRead,CpyAppskey,%IniFileName%,%section%,CpyAppskey,0
	IniRead,CpyNotAssign,%IniFileName%,%section%,CpyNotAssign,0
	Gui,1: Add, Radio, x62 y317 w140 h20 Disabled%RdoMuhenkanDisabled% Checked%CpyMuhenkan% vRdoCpyMuhenkan gOnClickRdoCpyMuhenkan, 無変換+文字キー
	Gui,1: Add, Radio, x232 y317 w190 h20 Disabled%RdoHenkanDisabled% Checked%CpyHenkan% vRdoCpyHenkan gOnClickRdoCpyHenkan, 変換+文字キー
	Gui,1: Add, Radio, x232 y347 w190 h20 Checked%CpyAppskey% vRdoCpyAppskey gOnClickRdoCpyAppsKey, アプリケーションキー+文字キー
	Gui,1: Add, Radio, x62 y347 w170 h20 Checked%CpyNotAssign% vRdoCpyNotAssign, 割当てない（変更しない）
	;-------------------------------------- 編集操作
	Gui,1: Add, GroupBox, x472 y47 w400 h160 , 編集操作（方向キー、Deleteキーなど）
	IniRead,EdtMuhenkanLhand,%IniFileName%,%section%,EdtMuhenkanLhand,0
	IniRead,EdtMuhenkanRhand,%IniFileName%,%section%,EdtMuhenkanRhand,1
	IniRead,EdtHenkanLhand,%IniFileName%,%section%,EdtHenkanLhand,0
	IniRead,EdtHenkanRhand,%IniFileName%,%section%,EdtHenkanRhand,0
	IniRead,EdtAppskeyLhand,%IniFileName%,%section%,EdtAppskeyLhand,0
	IniRead,EdtAppskeyRhand,%IniFileName%,%section%,EdtAppskeyRhand,0
	IniRead,EdtNotAssign,%IniFileName%,%section%,EdtNotAssign,0
	Gui,1: Add, Radio, x492 y77 w180 h20 Disabled%RdoMuhenkanDisabled% Checked%EdtMuhenkanLhand% vRdoEdtMuhenkanLhand gOnClickRdoEdtMuhenkanLhand, 無変換+左手
	Gui,1: Add, Radio, x682 y77 w180 h20 Disabled%RdoMuhenkanDisabled% Checked%EdtMuhenkanRhand% vRdoEdtMuhenkanRhand gOnClickRdoEdtMuhenkanRhand, 無変換+右手
	Gui,1: Add, Radio, x492 y107 w180 h20 Disabled%RdoHenkanDisabled% Checked%EdtHenkanLhand% vRdoEdtHenkanLhand gOnClickRdoEdtHenkanLhand, 変換+左手
	Gui,1: Add, Radio, x682 y107 w140 h20 Disabled%RdoHenkanDisabled% Checked%EdtHenkanRhand% vRdoEdtHenkanRhand gOnClickRdoEdtHenkanRhand, 変換+右手
	Gui,1: Add, Radio, x492 y137 w180 h20 Checked%EdtAppskeyLhand% vRdoEdtAppskeyLhand gOnClickRdoEdtAppskeyLhand, アプリケーションキー+左手
	Gui,1: Add, Radio, x682 y137 w180 h20 Checked%EdtAppskeyRhand% vRdoEdtAppskeyRhand gOnClickRdoEdtAppskeyRhand, アプリケーションキー+右手
	Gui,1: Add, Radio, x492 y167 w180 h20 Checked%EdtNotAssign% vRdoEdtNotAssign, 割当てない（変更しない）
	;-------------------------------------- マウス操作
	Gui,1: Add, GroupBox, x472 y227 w400 h160 , マウス操作（カーソル移動、クリックなど）
	IniRead,MouMuhenkanLhand,%IniFileName%,%section%,MouMuhenkanLhand,0
	IniRead,MouMuhenkanRhand,%IniFileName%,%section%,MouMuhenkanRhand,0
	IniRead,MouHenkanLhand,%IniFileName%,%section%,MouHenkanLhand,1
	IniRead,MouHenkanRhand,%IniFileName%,%section%,MouHenkanRhand,0
	IniRead,MouAppskeyLhand,%IniFileName%,%section%,MouAppskeyLhand,0
	IniRead,MouAppskeyRhand,%IniFileName%,%section%,MouAppskeyRhand,0
	IniRead,MouNotAssign,%IniFileName%,%section%,MouNotAssign,0
	Gui,1: Add, Radio, x492 y257 w180 h20 Disabled%RdoMuhenkanDisabled% Checked%MouMuhenkanLhand% vRdoMouMuhenkanLhand gOnClickRdoMouMuhenkanLhand, 無変換+左手
	Gui,1: Add, Radio, x682 y257 w180 h20 Disabled%RdoMuhenkanDisabled% Checked%MouMuhenkanRhand% vRdoMouMuhenkanRhand gOnClickRdoMouMuhenkanRhand, 無変換+右手
	Gui,1: Add, Radio, x492 y287 w180 h20 Disabled%RdoHenkanDisabled% Checked%MouHenkanLhand% vRdoMouHenkanLhand gOnClickRdoMouHenkanLhand, 変換+左手
	Gui,1: Add, Radio, x682 y287 w140 h20 Disabled%RdoHenkanDisabled% Checked%MouHenkanRhand% vRdoMouHenkanRhand gOnClickRdoMouHenkanRhand, 変換+右手
	Gui,1: Add, Radio, x492 y317 w180 h20 Checked%MouAppskeyLhand% vRdoMouAppskeyLhand gOnClickRdoMouAppskeyLhand, アプリケーションキー+左手
	Gui,1: Add, Radio, x682 y317 w180 h20 Checked%MouAppskeyRhand% vRdoMouAppskeyRhand gOnClickRdoMouAppskeyRhand, アプリケーションキー+右手
	Gui,1: Add, Radio, x492 y347 w180 h20 Checked%MouNotAssign% vRdoMouNotAssign, 割当てない（変更しない）
	;-------------------------------------- キー配列を変更
	Gui,1: Add, Button, x232 y407 w460 h50 gSaveKeyAssign, キー配列を変更
	;-------------------------------------- 詳細設定
	Gui,1: Add, GroupBox, x22 y499 w870 h110 , 詳細設定
	Gui,1: Add, Button, x121 y533 w210 h50 gShowKeyhairetsuConfig, キー配列詳細設定
	Gui,1: Add, Button, x351 y533 w210 h50 gSaveNewKeyhairetsu, 名前を付けてキー配列を保存
	Gui,1: Add, Button, x581 y533 w210 h50 gReadKeyhairetsu, 保存したキー配列を読み込む
	;-------------------------------------- 閉じるボタン
	Gui,1: Add, Button, x793 y629 w100 h30 g1GuiClose, 閉じる
	;-------------------------------------- GUI画面を表示
	Gui,1: Show, h683 w919
Return
;=========================================== ひらがな入力用のラジオボタンが選択された時の処理
;-------------------------------------- JISかな入力（英数親指シフト）と親指シフト以外が押されたとき
OnClickRdoKanRomaQwerty:
OnClickRdoKanRomaDvorak:
OnClickRdoKanKanaKanaShift:
	Gui, Submit, NoHide
	;-------------------------------------- コピー＆ペースト用のラジオボタンを制御する
	GuiControl, Enable1, RdoCpyMuhenkan
	GuiControl, Enable1, RdoCpyHenkan
	;-------------------------------------- 編集操作とマウス操作用のラジオボタンを制御する
	If (RdoCpyMuhenkan == 0) {
		GuiControl, Enable1, RdoEdtMuhenkanLhand
		GuiControl, Enable1, RdoEdtHenkanLhand
		GuiControl, Enable1, RdoMouMuhenkanLhand
		GuiControl, Enable1, RdoMouHenkanLhand
	}
	GuiControl, Enable1, RdoEdtMuhenkanRhand
	GuiControl, Enable1, RdoEdtHenkanRhand
	GuiControl, Enable1, RdoMouMuhenkanRhand
	GuiControl, Enable1, RdoMouHenkanRhand
Return
;-------------------------------------- JISかな入力（英数親指シフト）が押されたとき
OnClickRdoKanKanaEisuShift:
	Gui, Submit, NoHide
	;-------------------------------------- コピー＆ペースト用のラジオボタンを制御する
	GuiControl, Enable1, RdoCpyMuhenkan
	GuiControl, Enable1, RdoCpyHenkan
	;-------------------------------------- 編集操作とマウス操作用のラジオボタンを制御する
	If (RdoCpyMuhenkan == 0) {
		GuiControl, Enable1, RdoEdtMuhenkanLhand
		GuiControl, Enable1, RdoEdtHenkanLhand
		GuiControl, Enable1, RdoMouMuhenkanLhand
		GuiControl, Enable1, RdoMouHenkanLhand
	}
	GuiControl, Enable1, RdoEdtMuhenkanRhand
	GuiControl, Enable0, RdoEdtHenkanRhand
	GuiControl, Enable1, RdoMouMuhenkanRhand
	GuiControl, Enable0, RdoMouHenkanRhand
	GuiControl, , RdoEdtHenkanRhand, 0
	GuiControl, , RdoMouHenkanRhand, 0
Return
;-------------------------------------- 親指シフト（NICOLA配列）が押されたとき
OnClickRdoKanOyayubiShift:
	;-------------------------------------- コピー＆ペースト用のラジオボタンを制御する
	GuiControl, Enable0, RdoCpyMuhenkan
	GuiControl, Enable0, RdoCpyHenkan
	GuiControl, , RdoCpyMuhenkan, 0
	GuiControl, , RdoCpyHenkan, 0
	;-------------------------------------- 編集操作用のラジオボタンを制御する
	GuiControl, Enable0, RdoEdtMuhenkanLhand
	GuiControl, Enable0, RdoEdtMuhenkanRhand
	GuiControl, Enable0, RdoEdtHenkanLhand
	GuiControl, Enable0, RdoEdtHenkanRhand
	GuiControl, , RdoEdtMuhenkanLhand, 0
	GuiControl, , RdoEdtMuhenkanRhand, 0
	GuiControl, , RdoEdtHenkanLhand, 0
	GuiControl, , RdoEdtHenkanRhand, 0
	;-------------------------------------- マウス操作用のラジオボタンを制御する
	GuiControl, Enable0, RdoMouMuhenkanLhand
	GuiControl, Enable0, RdoMouMuhenkanRhand
	GuiControl, Enable0, RdoMouHenkanLhand
	GuiControl, Enable0, RdoMouHenkanRhand
	GuiControl, , RdoMouMuhenkanLhand, 0
	GuiControl, , RdoMouMuhenkanRhand, 0
	GuiControl, , RdoMouHenkanLhand, 0
	GuiControl, , RdoMouHenkanRhand, 0
Return
;-------------------------------------- 親指シフト（第3シフト使用）が押されたとき
OnClickRdoKanOyayubi3Shift:
	;-------------------------------------- コピー＆ペースト用のラジオボタンを制御する
	GuiControl, Enable1, RdoCpyMuhenkan
	GuiControl, Enable0, RdoCpyHenkan
	GuiControl, , RdoCpyHenkan, 0
	;-------------------------------------- 編集操作用のラジオボタンを制御する
	GuiControl, Enable1, RdoEdtMuhenkanLhand
	GuiControl, Enable1, RdoEdtMuhenkanRhand
	GuiControl, Enable0, RdoEdtHenkanLhand
	GuiControl, Enable0, RdoEdtHenkanRhand
	GuiControl, , RdoEdtHenkanLhand, 0
	GuiControl, , RdoEdtHnkanRhand, 0
	;-------------------------------------- マウス操作用のラジオボタンを制御する
	GuiControl, Enable1, RdoMouMuhenkanLhand
	GuiControl, Enable1, RdoMouMuhenkanRhand
	GuiControl, Enable0, RdoMouHenkanLhand
	GuiControl, Enable0, RdoMouHenkanRhand
	GuiControl, , RdoMouHenkanLhand, 0
	GuiControl, , RdoMouHenkanRhand, 0
Return
;=========================================== コピー＆ペーストの無変換+文字キーラジオボタンが選択された時の処理
OnClickRdoCpyMuhenkan:
	;-------------------------------------- 無変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoEdtMuhenkanLhand, 0
	GuiControl, , RdoMouMuhenkanLhand, 0
Return
;=========================================== コピー＆ペーストの変換+文字キーラジオボタンが選択された時の処理
OnClickRdoCpyHenkan:
	;-------------------------------------- 変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoEdtHenkanLhand, 0
	GuiControl, , RdoMouHenkanLhand, 0
Return
;=========================================== コピー＆ペーストのアプリケーションキー+文字キーラジオボタンが選択された時の処理
OnClickRdoCpyAppsKey:
	;-------------------------------------- アプリケーションキー+Ｘラジオボタンをクリアする
	GuiControl, , RdoEdtAppsKeyLhand, 0
	GuiControl, , RdoMouAppsKeyLhand, 0
Return
;=========================================== 編集操作の無変換+左手ラジオボタンが選択された時の処理
OnClickRdoEdtMuhenkanLhand:
	;-------------------------------------- 無変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoCpyMuhenkan, 0
	GuiControl, , RdoMouMuhenkanLhand, 0
Return
;=========================================== 編集操作の無変換+右手ラジオボタンが選択された時の処理
OnClickRdoEdtMuhenkanRhand:
	;-------------------------------------- 無変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoMouMuhenkanRhand, 0
Return
;=========================================== 編集操作の変換+左手ラジオボタンが選択された時の処理
OnClickRdoEdtHenkanLhand:
	;-------------------------------------- 変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoCpyHenkan, 0
	GuiControl, , RdoMouHenkanLhand, 0
Return
;=========================================== 編集操作の変換+右手ラジオボタンが選択された時の処理
OnClickRdoEdtHenkanRhand:
	;-------------------------------------- 変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoMouHenkanRhand, 0
Return
;=========================================== 編集操作のアプリケーションキー+左手ラジオボタンが選択された時の処理
OnClickRdoEdtAppskeyLhand:
	;-------------------------------------- アプリケーションキー+Ｘラジオボタンをクリアする
	GuiControl, , RdoCpyAppsKey, 0
	GuiControl, , RdoMouAppsKeyLhand, 0
Return
;=========================================== 編集操作のアプリケーションキー+右手ラジオボタンが選択された時の処理
OnClickRdoEdtAppskeyRhand:
	;-------------------------------------- アプリケーションキー+Ｘラジオボタンをクリアする
	GuiControl, , RdoMouAppsKeyRhand, 0
Return
;=========================================== マウス操作の無変換+左手ラジオボタンが選択された時の処理
OnClickRdoMouMuhenkanLhand:
	;-------------------------------------- 無変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoCpyMuhenkan, 0
	GuiControl, , RdoEdtMuhenkanLhand, 0
Return
;=========================================== マウス操作の無変換+右手ラジオボタンが選択された時の処理
OnClickRdoMouMuhenkanRhand:
	;-------------------------------------- 無変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoEdtMuhenkanRhand, 0
Return
;=========================================== マウス操作の変換+左手ラジオボタンが選択された時の処理
OnClickRdoMouHenkanLhand:
	;-------------------------------------- 変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoCpyHenkan, 0
	GuiControl, , RdoEdtHenkanLhand, 0
Return
;=========================================== マウス操作の変換+右手ラジオボタンが選択された時の処理
OnClickRdoMouHenkanRhand:
	;-------------------------------------- 変換+Ｘラジオボタンをクリアする
	GuiControl, , RdoEdtHenkanRhand, 0
Return
;=========================================== マウス操作のアプリケーションキー+左手ラジオボタンが選択された時の処理
OnClickRdoMouAppskeyLhand:
	;-------------------------------------- アプリケーションキー+Ｘラジオボタンをクリアする
	GuiControl, , RdoCpyAppsKey, 0
	GuiControl, , RdoEdtAppsKeyLhand, 0
Return
;=========================================== マウス操作のアプリケーションキー+右手ラジオボタンが選択された時の処理
OnClickRdoMouAppskeyRhand:
	;-------------------------------------- アプリケーションキー+Ｘラジオボタンをクリアする
	GuiControl, , RdoEdtAppsKeyRhand, 0
Return
;=========================================== ラジオボタンで選択されているキー配列プリセットを読み込む
SaveKeyAssign:
	Msgbox 4,　,キー配列を変更しますか？
	IfMsgBox Yes
	{
		;Gui, Submit, NoHide
		Gui, Submit, Hide
		;-------------------------------------- 半角英数
		If (RdoAlpQwerty == 1) {
			preset_file = %A_ScriptDir%\preset\半角英数配列_QWERTY配列.ini
		}
		If (RdoAlpDvorak == 1) {
			preset_file = %A_ScriptDir%\preset\半角英数配列_Dvorak配列.ini
		}
		ReadIniKeyhairetsu(preset_file,1,1)
		;-------------------------------------- ひらがな
		If (RdoKanRomaQwerty == 1) {
			preset_file = %A_ScriptDir%\preset\かな配列_ローマ字入力(QWERTY配列).ini
		}
		If (RdoKanRomaDvorak == 1) {
			preset_file = %A_ScriptDir%\preset\かな配列_ローマ字入力(Dvorak).ini
		}
		If (RdoKanKanaEisuShift == 1) {
			preset_file = %A_ScriptDir%\preset\かな配列_JISかな配列英数親指シフト.ini
		}
		If (RdoKanKanaKanaShift == 1) {
			preset_file = %A_ScriptDir%\preset\かな配列_JISかな配列かな親指シフト.ini
		}
		If (RdoKanOyayubiShift == 1) {
			preset_file = %A_ScriptDir%\preset\かな配列_NICOLA配列(親指シフト).ini
		}
		If (RdoKanOyayubi3Shift == 1) {
			preset_file = %A_ScriptDir%\preset\かな配列_NICOLA配列(第3シフト使用).ini
		}
		ReadIniKeyhairetsu(preset_file,1,1)
		;-------------------------------------- コピー＆ペースト
		If (RdoCpyMuhenkan == 1) {
			preset_file = %A_ScriptDir%\preset\コピー&ペースト_無変換+文字キー.ini
		}
		If (RdoCpyHenkan == 1) {
			preset_file = %A_ScriptDir%\preset\コピー&ペースト_変換+文字キー.ini
		}
		If (RdoCpyAppskey == 1) {
			preset_file = %A_ScriptDir%\preset\コピー&ペースト_アプリケーションキー+文字キー.ini
		}
		ReadIniKeyhairetsu(preset_file,1,1)
		;-------------------------------------- 編集操作
		If (RdoEdtMuhenkanLhand == 1) {
			preset_file = %A_ScriptDir%\preset\編集キー配列_無変換+左手.ini
		}
		If (RdoEdtMuhenkanRhand == 1) {
			preset_file = %A_ScriptDir%\preset\編集キー配列_無変換+右手.ini
		}
		If (RdoEdtHenkanLhand == 1) {
			preset_file = %A_ScriptDir%\preset\編集キー配列_変換+左手.ini
		}
		If (RdoEdtHenkanRhand == 1) {
			preset_file = %A_ScriptDir%\preset\編集キー配列_変換+右手.ini
		}
		If (RdoEdtAppskeyLhand == 1) {
			preset_file = %A_ScriptDir%\preset\編集キー配列_アプリケーションキー+左手.ini
		}
		If (RdoEdtAppskeyRhand == 1) {
			preset_file = %A_ScriptDir%\preset\編集キー配列_アプリケーションキー+右手.ini
		}
		ReadIniKeyhairetsu(preset_file,1,1)
		;-------------------------------------- マウス操作
		If (RdoMouMuhenkanLhand == 1) {
			preset_file = %A_ScriptDir%\preset\マウス操作_無変換+左手.ini
		}
		If (RdoMouMuhenkanRhand == 1) {
			preset_file = %A_ScriptDir%\preset\マウス操作_無変換+右手.ini
		}
		If (RdoMouHenkanLhand == 1) {
			preset_file = %A_ScriptDir%\preset\マウス操作_変換+左手.ini
		}
		If (RdoMouHenkanRhand == 1) {
			preset_file = %A_ScriptDir%\preset\マウス操作_変換+右手.ini
		}
		If (RdoMouAppskeyLhand == 1) {
			preset_file = %A_ScriptDir%\preset\マウス操作_アプリケーションキー+左手.ini
		}
		If (RdoMouAppskeyRhand == 1) {
			preset_file = %A_ScriptDir%\preset\マウス操作_アプリケーションキー+右手.ini
		}
		ReadIniKeyhairetsu(preset_file,1,1)
		;-------------------------------------- キー配列を保存
		WriteIniKeyhairetsu(IniFileName,"キー配列を変更しています")
		;-------------------------------------- プリセットの選択状態をiniファイルに保存する
		section = KEY_PRESET
		;-------------------------------------- 半角英数
		IniWrite,%RdoAlpQwerty%,%IniFileName%,%section%,AlpQwerty
		IniWrite,%RdoAlpDvorak%,%IniFileName%,%section%,AlpDvorak
		;-------------------------------------- ひらがな
		IniWrite,%RdoKanRomaQwerty%,%IniFileName%,%section%,KanRomaQwerty
		IniWrite,%RdoKanKanaEisuShift%,%IniFileName%,%section%,KanKanaEisuShift
		IniWrite,%RdoKanRomaDvorak%,%IniFileName%,%section%,KanRomaDvorak
		IniWrite,%RdoKanKanaKanaShift%,%IniFileName%,%section%,KanKanaKanaShift
		IniWrite,%RdoKanOyayubiShift%,%IniFileName%,%section%,KanKanOyayubiShift
		IniWrite,%RdoKanOyayubi3Shift%,%IniFileName%,%section%,KanKanOyayubi3Shift
		;-------------------------------------- コピー＆ペースト
		IniWrite,%RdoCpyMuhenkan%,%IniFileName%,%section%,CpyMuhenkan
		IniWrite,%RdoCpyHenkan%,%IniFileName%,%section%,CpyHenkan
		IniWrite,%RdoCpyAppskey%,%IniFileName%,%section%,CpyAppskey
		IniWrite,%RdoCpyNotAssign%,%IniFileName%,%section%,CpyNotAssign
		;-------------------------------------- 編集操作
		IniWrite,%RdoEdtMuhenkanLhand%,%IniFileName%,%section%,EdtMuhenkanLhand
		IniWrite,%RdoEdtMuhenkanRhand%,%IniFileName%,%section%,EdtMuhenkanRhand
		IniWrite,%RdoEdtHenkanLhand%,%IniFileName%,%section%,EdtHenkanLhand
		IniWrite,%RdoEdtHenkanRhand%,%IniFileName%,%section%,EdtHenkanRhand
		IniWrite,%RdoEdtAppskeyLhand%,%IniFileName%,%section%,EdtAppskeyLhand
		IniWrite,%RdoEdtAppskeyRhand%,%IniFileName%,%section%,EdtAppskeyRhand
		IniWrite,%RdoEdtNotAssign%,%IniFileName%,%section%,EdtNotAssign
		;-------------------------------------- マウス操作
		IniWrite,%RdoMouMuhenkanLhand%,%IniFileName%,%section%,MouMuhenkanLhand
		IniWrite,%RdoMouMuhenkanRhand%,%IniFileName%,%section%,MouMuhenkanRhand
		IniWrite,%RdoMouHenkanLhand%,%IniFileName%,%section%,MouHenkanLhand
		IniWrite,%RdoMouHenkanRhand%,%IniFileName%,%section%,MouHenkanRhand
		IniWrite,%RdoMouAppskeyLhand%,%IniFileName%,%section%,MouAppskeyLhand
		IniWrite,%RdoMouAppskeyRhand%,%IniFileName%,%section%,MouAppskeyRhand
		IniWrite,%RdoMouNotAssign%,%IniFileName%,%section%,MouNotAssign
		;-------------------------------------- キー配列を再読み込み
		WriteIniKeyhairetsu(IniFileName,"キー配列を変更しています")
		ReadIniKeyhairetsu(ini_file_name,1,0)
		;-------------------------------------- 完了メッセージを表示
		MsgBox ,,　,キー配列を変更しました
		Gui,Show
	}
Return
;=========================================== キー配列詳細設定画面を表示する
ShowKeyhairetsuConfig:
	Gui,1: Destroy
	Gosub キー配列詳細設定
Return
;=========================================== 名前を付けてキー配列を保存
SaveNewKeyhairetsu:
	FileSelectFile, strWrk, 16, %A_ScriptDir%\dokuji\独自配列.ini, 名前を付けてキー配列を保存, *.ini
	If (Strlen(strWrk) > 0) {
		If (InStr(strWrk, ".ini") == 0) {
			strWrk = %strWrk%.ini
		}
		WriteIniKeyhairetsu(strWrk,"キー配列を保存しています")
		MsgBox ,,　,キー配列を保存しました
	}
Return
;=========================================== 保存したキー配列を読み込む
ReadKeyhairetsu:
	FileSelectFile, strWrk, , %A_ScriptDir%\dokuji, 保存したキー配列を読み込む, *.ini
	If (Strlen(strWrk) > 0) {
		ReadIniKeyhairetsu(strWrk,1,0)
		WriteIniKeyhairetsu(IniFileName,"キー配列を変更しています")
		MsgBox ,,　,キー配列を変更しました
	}
Return
;=========================================== GUI画面を閉じたときの処理
1GuiClose:
	ExistConfigKeyPreset := 0
	Gui,1: Destroy
Return
