﻿キー配列詳細設定:
	;-------------------------------------- 既に設定画面を開いているときは何もしない
	If (ExistConfigKeyhairetsu == 1) {
		Return
	}Else{
		ExistConfigKeyhairetsu := 1
	}
	;-------------------------------------- 画面を新規作成する
	ConfigKeyhairetsuGuiTitle := "キー配列詳細設定"
	Gui,2: New,, %ConfigKeyhairetsuGuiTitle%
	Gui,2: Font, s11
	;-------------------------------------- キーリスト
	Gui,2: Add, ListView, x22 y19 w180 h590 NoSortHdr Grid -Multi AltSubmit vKeylistLV gLVOnClick, キーリスト
	;-------------------------------------- キー配列からキー名称を取得しリストビューに格納する
	For, key_index, key_name in key_asign {
		;-------------------------------------- 特殊なキー表記を一般的な内容に変換する
		ReplaceKey(key_name,1)
		;-------------------------------------- リストビューに格納する
		LV_Add("", key_name)
	}
	;-------------------------------------- iniファイルからキー配列情報とタスク制御情報を取得
	;key_count := 0
	;loop {
	;	section = KEYHAIRETSU%A_Index%
	;	IniRead,key_index,%IniFileName%,%section%,KeyAssign,-1
	;	If (key_index == -1) {
	;		Break
	;	}
	;	key_count += 1
	;	;-------------------------------------- 特殊なキー表記を一般的な内容に変換する
	;	ReplaceKey(key_index,1)
	;	LV_Add("", key_index)
	;}
	;-------------------------------------- 単独打鍵
	Gui,2: Add, GroupBox, x222 y19 w260 h70 , 単独打鍵
	Gui,2: Add, Text, x242 y39 w100 h20 , 半角モード
	Gui,2: Add, Edit, x312 y39 w160 h20 vKeySingleAlp, 
	Gui,2: Add, Text, x242 y59 w100 h20 , 全角モード
	Gui,2: Add, Edit, x312 y59 w160 h20 vKeySingleJpn, 
	;-------------------------------------- 左シフト+
	Gui,2: Add, GroupBox, x222 y99 w260 h70 , 左シフト+
	Gui,2: Add, Text, x242 y119 w100 h20 , 半角モード
	Gui,2: Add, Edit, x312 y119 w160 h20 vKeyLShiftAlp, 
	Gui,2: Add, Text, x242 y139 w100 h20 , 全角モード
	Gui,2: Add, Edit, x312 y139 w160 h20 vKeyLShiftJpn, 
	;-------------------------------------- 右シフト+
	Gui,2: Add, GroupBox, x222 y179 w260 h70 , 右シフト+
	Gui,2: Add, Text, x242 y199 w100 h20 , 半角モード
	Gui,2: Add, Edit, x312 y199 w160 h20 vKeyRShiftAlp, 
	Gui,2: Add, Text, x242 y219 w100 h20 , 全角モード
	Gui,2: Add, Edit, x312 y219 w160 h20 vKeyRShiftJpn, 
	;-------------------------------------- 第3シフト(F24)+
	Gui,2: Add, GroupBox, x222 y259 w260 h70 , 第3シフト(F24)+
	Gui,2: Add, Text, x242 y279 w100 h20 , 半角モード
	Gui,2: Add, Edit, x312 y279 w160 h20 vKeySpecialAlp, 
	Gui,2: Add, Text, x242 y299 w100 h20 , 全角モード
	Gui,2: Add, Edit, x312 y299 w160 h20 vKeySpecialJpn, 
	;-------------------------------------- コメント
	Gui,2: Add, Text, x242 y359 w200 h20 , （※）文字入力の時は先頭に
	Gui,2: Add, Text, x272 y379 w200 h20 , IMEオン・オフのキー入力が必要
	Gui,2: Add, Text, x272 y409 w100 h20 , IMEオン→^{F13}
	Gui,2: Add, Text, x272 y429 w100 h20 , IMEオフ→+{F13}
	;-------------------------------------- 無変換+
	Gui,2: Add, GroupBox, x492 y19 w390 h70 , 無変換+（※）
	Gui,2: Add, Text, x512 y39 w180 h20 , 半角モード
	Gui,2: Add, Edit, x682 y39 w190 h20 vKeyMuHenkanAlp, 
	Gui,2: Add, Text, x512 y59 w180 h20 , 全角モード
	Gui,2: Add, Edit, x682 y59 w190 h20 vKeyMuHenkanJpn, 
	;-------------------------------------- 変換+
	Gui,2: Add, GroupBox, x492 y99 w390 h70 , 変換+（※）
	Gui,2: Add, Text, x512 y119 w180 h20 , 半角モード
	Gui,2: Add, Edit, x682 y119 w190 h20 vKeyHenkanAlp, 
	Gui,2: Add, Text, x512 y139 w180 h20 , 全角モード
	Gui,2: Add, Edit, x682 y139 w190 h20 vKeyHenkanJpn, 
	;-------------------------------------- サブコマンド向け配列(無変換)
	Gui,2: Add, GroupBox, x492 y179 w390 h170 , サブコマンド向け配列（※）
	Gui,2: Add, Text, x512 y199 w140 h20 , 無変換+Shift(F24)+
	Gui,2: Add, Edit, x682 y199 w190 h20 vKeyMuHenkanShift gOnEditMuHenkanShift, 
	Gui,2: Add, Text, x512 y219 w100 h20 , 無変換+Alt+
	Gui,2: Add, Edit, x682 y219 w190 h20 vKeyMuHenkanAlt, 
	;-------------------------------------- サブコマンド向け配列(変換)
	Gui,2: Add, Text, x512 y239 w140 h20 , 変換+Shift(F24)+
	Gui,2: Add, Edit, x682 y239 w190 h20 vKeyHenkanShift, 
	Gui,2: Add, Text, x512 y259 w100 h20 , 変換+Alt+
	Gui,2: Add, Edit, x682 y259 w190 h20 vKeyHenkanAlt, 
	;-------------------------------------- サブコマンド向け配列(AppsKey)
	Gui,2: Add, Text, x512 y279 w160 h20 , AppsKey+
	Gui,2: Add, Edit, x682 y279 w190 h20 vKeyAppsKey, 
	Gui,2: Add, Text, x512 y299 w230 h20 , AppsKey+Shift(F24)+
	Gui,2: Add, Edit, x682 y299 w190 h20 vKeyAppsKeyShift, 
	Gui,2: Add, Text, x512 y319 w230 h20 , AppsKey+Alt+
	Gui,2: Add, Edit, x682 y319 w190 h20 vKeyAppsKeyAlt, 
	;-------------------------------------- タスク制御情報
	Gui,2: Add, GroupBox, x492 y359 w390 h250 , ウィンドウ切替（無変換+Shift(F24)+で実行）
	Gui,2: Add, Text, x512 y379 w130 h20 , ウィンドウ識別方法
	Gui,2: Add, Edit, x682 y379 w190 h20 vKeyTaskClass, 
	Gui,2: Add, Text, x512 y399 w130 h20 , ウィンドウクラス等
	Gui,2: Add, Edit, x682 y399 w190 h20 vKeyTaskName, 
	Gui,2: Add, Text, x512 y419 w130 h20 , ウィンドウタイトル
	Gui,2: Add, Edit, x682 y419 w190 h20 vKeyTaskTitle, 
	Gui,2: Add, Text, x512 y439 w180 h20 , 起動ショートカットキー
	Gui,2: Add, Edit, x682 y439 w190 h20 vKeyTaskShortcut, 
	Gui,2: Add, Text, x512 y459 w130 h20 , ランチャー表示名
	Gui,2: Add, Edit, x682 y459 w190 h20 vKeyLancherName, 
	Gui,2: Add, CheckBox, x512 y479 w360 h20 vKeyTaskStyle, 子ウィンドウを切替える（Ctrl+Tabで切替わる場合）
	Gui,2: Add, CheckBox, x512 y499 w360 h20 vKeyTaskAssignHenkan, 変換+にも割当てる(変換+は無効)
	Gui,2: Add, GroupBox, x512 y529 w360 h70 , 取得ボタンクリック後、対象ウィンドウをクリックしてください
	Gui,2: Add, Button, x532 y559 w150 h40 Disabled1 vGetWinClassBtn gGetWinClass, ウィンドウクラスを取得
	Gui,2: Add, Button, x702 y559 w150 h40 Disabled1 vGetWinExeBtn gGetWinExe, 実行ファイル名を取得
	;Gui,2: Add, Text, x512 y329 w130 h20 , 起動コマンド
	;Gui,2: Add, Edit, x682 y329 w190 h20 vKeyTaskCmd, 
	;Gui,2: Add, Button, x332 y509 w260 h60 , キー配列プリセット
	;-------------------------------------- 保存ボタン
	Gui,2: Add, Button, x332 y628 w260 h60 Disabled1 vSaveBtn gOnclickSaveKeyhairetsuButton, 現在表示されているキー配列を保存
	;-------------------------------------- 閉じるボタン
	Gui,2: Add, Button, x782 y644 w100 h30 g2GuiClose, 閉じる
	;-------------------------------------- GUI画面を表示
	Gui,2: Show, h716 w903
Return
;=========================================== リストビューの項目がクリックされた時の処理
LVOnClick:
	;-------------------------------------- リストビューがフォーカスを受け取ったときは、処理対象のリストビューを変更する
	If (A_GuiEvent == "F" || A_GuiEvent == "Normal") {
		Gui, 2: ListView, KeylistLV
	}
	;-------------------------------------- リストビューの選択状態が変化したときは、リストビューにフォーカスをあわせる（ここでフォーカスをあててないと次にリストビューの項目をクリックしたときに正しくイベントが受け取れないため）
	If (A_GuiEvent == "I") {		
		GuiControl, Focus, KeylistLV
		Return
	}
	;------------------------------ 選択されている行の行番号を取得する
	SelectedRow := LV_GetNext(0)
	;------------------------------ 項目が埋まっている行がクリックされたときだけ処理する
	If (SelectedRow > 0) {
		;-------------------------------------- 選択されたキーに対応するキー配列設定をエディットボックスに転送する
		LV_GetText(SelectedKey, SelectedRow)
		;-------------------------------------- 一般的なキー表記をAutohotkey独自の内容に変換する
		ReplaceKey(SelectedKey,2)
		;-------------------------------------- 添字を編集する
		key_index = %SelectedKey%
		key_index_alp = %SelectedKey%0
		key_index_jpn = %SelectedKey%1
		;-------------------------------------- 選択されたキーに応じてエディットボックスの有効・無効を変更する
		If (SelectedKey == "Space") {
			enableG1 := 0
		}Else{
			enableG1 := 1
		}
		;-------------------------------------- 単独打鍵（英数）
		value := key_single[key_index_alp]
		;-------- 特殊なキー表記を一般的な内容に変換して転送（以下同様）
		ReplaceKey(value,3)
		GuiControl, Text, KeySingleAlp, %value%
		GuiControl, Enable%enableG1%, KeySingleAlp
		;-------------------------------------- 単独打鍵（日本語）
		value := key_single[key_index_jpn]
		ReplaceKey(value,3)
		GuiControl, Text, KeySingleJpn, %value%
		GuiControl, Enable%enableG1%, KeySingleJpn
		;-------------------------------------- 選択されたキーに応じてエディットボックスの有効・無効を変更する
		If (SelectedKey == "Space up") {
			enableG2 := 0
		}Else{
			enableG2 := 1
		}
		;-------------------------------------- ＋左シフトキー（英数）
		value := key_lshift[key_index_alp]
		ReplaceKey(value,3)
		GuiControl, Text, KeyLShiftAlp, %value%
		GuiControl, Enable%enableG2%, KeyLShiftAlp
		;-------------------------------------- ＋左シフトキー（日本語）
		value := key_lshift[key_index_jpn]
		ReplaceKey(value,3)
		GuiControl, Text, KeyLShiftJpn, %value%
		GuiControl, Enable%enableG2%, KeyLShiftJpn
		;-------------------------------------- ＋右シフトキー（英数）
		value := key_rshift[key_index_alp]
		ReplaceKey(value,3)
		GuiControl, Text, KeyRShiftAlp, %value%
		GuiControl, Enable%enableG2%, KeyRShiftAlp
		;-------------------------------------- ＋右シフトキー（日本語）
		value := key_rshift[key_index_jpn]
		ReplaceKey(value,3)
		GuiControl, Text, KeyRShiftJpn, %value%
		GuiControl, Enable%enableG2%, KeyRShiftJpn
		;-------------------------------------- ＋Specialキー
		key_wrk := SelectedKey
		ReplaceKey(key_wrk,3)
		If (key_wrk == "F24" || InStr(key_wrk,"半角/全角") > 0 || InStr(key_wrk,"win") > 0) {
			GuiControl, Text, KeySpecialAlp,
			GuiControl, Text, KeySpecialJpn,
			GuiControl, Enable0, KeySpecialAlp
			GuiControl, Enable0, KeySpecialJpn
		}Else{
			;-------------------------------------- ＋Specialキー（英数）
			value := key_Special[key_index_alp]
			ReplaceKey(value,3)
			GuiControl, Text, KeySpecialAlp, %value%
			GuiControl, Enable%enableG2%, KeySpecialAlp
			;-------------------------------------- ＋Specialキー（日本語）
			value := key_Special[key_index_jpn]
			ReplaceKey(value,3)
			GuiControl, Text, KeySpecialJpn, %value%
			GuiControl, Enable%enableG2%, KeySpecialJpn
		}
		;-------------------------------------- ＋無変換キー
		;key_wrk := SelectedKey
		;ReplaceKey(key_wrk,3)
		If (key_wrk == "無変換" || key_wrk == "F24" || InStr(key_wrk,"win") > 0) {
			GuiControl, Text, KeyMuHenkanAlp,
			GuiControl, Text, KeyMuHenkanJpn,
			;GuiControl, Text, KeyMuHenkanShift,
			GuiControl, Text, KeyMuHenkanAlt,
			GuiControl, Enable0, KeyMuHenkanAlp
			GuiControl, Enable0, KeyMuHenkanJpn
			GuiControl, Enable0, KeyMuHenkanShift
			GuiControl, Enable0, KeyMuHenkanAlt
		}Else{
			;-------------------------------------- ＋無変換キー（英数）
			value := key_muhenkan[key_index_alp]
			ReplaceKey(value,3)
			GuiControl, Text, KeyMuHenkanAlp, %value%
			GuiControl, Enable%enableG2%, KeyMuHenkanAlp
			;-------------------------------------- ＋無変換キー（日本語）
			value := key_muhenkan[key_index_jpn]
			ReplaceKey(value,3)
			GuiControl, Text, KeyMuHenkanJpn, %value%
			GuiControl, Enable%enableG2%, KeyMuHenkanJpn
			If (InStr(key_wrk,"半角/全角") > 0 || InStr(key_wrk,"カタカナ") > 0) {
				GuiControl, Text, KeyMuHenkanShift,
				GuiControl, Text, KeyMuHenkanAlt,
				GuiControl, Enable0, KeyMuHenkanShift
				GuiControl, Enable0, KeyMuHenkanAlt
			}Else{
				;-------------------------------------- ＋無変換キー+シフトキー
				value := key_muhenkan_shift[key_index]
				ReplaceKey(value,3)
				GuiControl, Text, KeyMuHenkanShift, %value%
				GuiControl, Enable%enableG2%, KeyMuHenkanShift
				;-------------------------------------- ＋無変換キー+Altキー
				value := key_muhenkan_alt[key_index]
				ReplaceKey(value,3)
				GuiControl, Text, KeyMuHenkanAlt, %value%
				GuiControl, Enable%enableG2%, KeyMuHenkanAlt
			}
		}
		;-------------------------------------- ＋変換キー
		;key_wrk := SelectedKey
		;ReplaceKey(key_wrk,3)
		If (key_wrk == "変換" || key_wrk == "F24" || InStr(key_wrk,"半角/全角") > 0 || InStr(key_wrk,"win") > 0) {
			GuiControl, Text, KeyHenkanAlp,
			GuiControl, Text, KeyHenkanJpn,
			GuiControl, Text, KeyHenkanShift
			GuiControl, Text, KeyHenkanAlt
			GuiControl, Enable0, KeyHenkanAlp
			GuiControl, Enable0, KeyHenkanJpn
			GuiControl, Enable0, KeyHenkanShift
			GuiControl, Enable0, KeyHenkanAlt
		}Else{
			;-------------------------------------- ＋変換キー（英数）
			value := key_henkan[key_index_alp]
			ReplaceKey(value,3)
			GuiControl, Text, KeyHenkanAlp, %value%
			GuiControl, Enable%enableG2%, KeyHenkanAlp
			;-------------------------------------- ＋変換キー（日本語）
			value := key_henkan[key_index_jpn]
			ReplaceKey(value,3)
			GuiControl, Text, KeyHenkanJpn, %value%
			GuiControl, Enable%enableG2%, KeyHenkanJpn
			;-------------------------------------- ＋変換キー+シフトキー
			If (InStr(key_wrk,"カタカナ") > 0) {
				GuiControl, Text, KeyHenkanShift
				GuiControl, Text, KeyHenkanAlt
				GuiControl, Enable0, KeyHenkanShift
				GuiControl, Enable0, KeyHenkanAlt
			}Else{
				;-------------------------------------- ＋変換キー+シフトキー
				value := key_henkan_shift[key_index]
				ReplaceKey(value,3)
				GuiControl, Text, KeyHenkanShift, %value%
				GuiControl, Enable%enableG2%, KeyHenkanShift
				;-------------------------------------- ＋変換キー+Altキー
				value := key_henkan_alt[key_index]
				ReplaceKey(value,3)
				GuiControl, Text, KeyHenkanAlt, %value%
				GuiControl, Enable%enableG2%, KeyHenkanAlt
			}
		}
		;-------------------------------------- ＋アプリケーションキー
		;key_wrk := SelectedKey
		;ReplaceKey(key_wrk,3)
		If (key_wrk == "AppsKey" || key_wrk == "F24" || key_wrk == "F23" || InStr(key_wrk,"半角/全角") > 0 || InStr(key_wrk,"カタカナ") > 0 || InStr(key_wrk,"win") > 0) {
			GuiControl, Text, KeyAppsKey,
			GuiControl, Text, KeyAppsKeyShift,
			GuiControl, Text, KeyAppsKeyAlt,
			GuiControl, Enable0, KeyAppsKey
			GuiControl, Enable0, KeyAppsKeyShift
			GuiControl, Enable0, KeyAppsKeyAlt
		}Else{
			;-------------------------------------- ＋アプリケーションキー
			value := key_appskey[key_index]
			ReplaceKey(value,3)
			GuiControl, Text, KeyAppsKey, %value%
			GuiControl, Enable%enableG2%, KeyAppsKey
			;-------------------------------------- ＋アプリケーションキー+シフトキー
			value := key_appskey_shift[key_index]
			ReplaceKey(value,3)
			GuiControl, Text, KeyAppsKeyShift, %value%
			GuiControl, Enable%enableG2%, KeyAppsKeyShift
			;-------------------------------------- ＋アプリケーションキー+Alt
			value := key_appskey_alt[key_index]
			ReplaceKey(value,3)
			GuiControl, Text, KeyAppsKeyAlt, %value%
			GuiControl, Enable%enableG2%, KeyAppsKeyAlt
		}
		;-------------------------------------- タスク関連
		;key_wrk := SelectedKey
		;ReplaceKey(key_wrk,3)
		If (key_wrk == "無変換" || key_wrk == "F24" || key_wrk == "F23" || InStr(key_wrk,"半角/全角") > 0 || InStr(key_wrk,"カタカナ") > 0 || InStr(key_wrk,"win") > 0) {
			GuiControl, Text, KeyTaskClass,
			GuiControl, Text, KeyTaskName,
			GuiControl, Text, KeyTaskTitle,
			GuiControl, Text, KeyTaskShortcut,
			;;GuiControl, Text, KeyTaskCmd,
			GuiControl, Text, KeyLancherName,
			GuiControl, Enable0, KeyTaskClass
			GuiControl, Enable0, KeyTaskName
			GuiControl, Enable0, KeyTaskTitle
			GuiControl, Enable0, KeyTaskShortcut
			;GuiControl, Enable0, KeyTaskCmd
			GuiControl, Enable0, KeyLancherName
			GuiControl, Enable0, KeyTaskStyle
			GuiControl, Enable0, KeyTaskAssignHenkan
		}Else{
			;-------------------------------------- タスククラス
			value := task_class[key_index]
			GuiControl, Text, KeyTaskClass, %value%
			GuiControl, Enable%enableG3%, KeyTaskClass
			;-------------------------------------- タスク名
			value := task_name[key_index]
			GuiControl, Text, KeyTaskName, %value%
			GuiControl, Enable%enableG3%, KeyTaskName
			;-------------------------------------- タスクタイトル
			value := task_title[key_index]
			GuiControl, Text, KeyTaskTitle, %value%
			GuiControl, Enable%enableG3%, KeyTaskTitle
			;-------------------------------------- タスクショートカットキー
			value := task_shortcut[key_index]
			GuiControl, Text, KeyTaskShortcut, %value%
			GuiControl, Enable%enableG3%, KeyTaskShortcut
			;-------------------------------------- タスクコマンド
			;value := task_cmd[key_index]
			;GuiControl, Text, KeyTaskCmd, %value%
			;GuiControl, Enable%enableG3%, KeyTaskCmd
			;-------------------------------------- ランチャー表示名
			value := task_lancher_name[key_index]
			GuiControl, Text, KeyLancherName, %value%
			GuiControl, Enable%enableG3%, KeyLancherName
			;-------------------------------------- タスクスタイル
			If (task_style[key_index] == 1) {
				chkd := 1
			}Else{
				chkd := 0
			}
			GuiControl, , KeyTaskStyle, %chkd%
			GuiControl, Enable%enableG3%, KeyTaskStyle
			;-------------------------------------- タスクフルパス
			KeyFullPath := task_full_path[key_index]
			;-------------------------------------- 変換キーへの割当て
			If (task_assign_henkan[key_index] == 1) {
				chkd := 1
			}Else{
				chkd := 0
			}
			GuiControl, , KeyTaskAssignHenkan, %chkd%
			GuiControl, Enable%enableG3%, KeyTaskAssignHenkan
		}
		;-------------------------------------- ボタンを押せるようにする
		GuiControl, Enable1, SaveBtn
		GuiControl, Enable1, GetWinClassBtn
		GuiControl, Enable1, GetWinExeBtn
	}Else{
		;------------------------------ 項目がない行をクリックしたときはボタンを押せないようにする
		GuiControl, Enable0, SaveBtn
		GuiControl, Enable0, GetWinClassBtn
		GuiControl, Enable0, GetWinExeBtn
	}
Return
;=========================================== +無変換+Shiftのエディットボックスが編集されたときの処理
OnEditMuHenkanShift:
	;-------------------------------------- エディットボックスの入力内容を取得する
	Gui,2: Submit, NoHide
	;--------- 入力内容に応じてエディットボックスの有効・無効を変更する
	key_wrk := SelectedKey
	ReplaceKey(key_wrk,3)
	If (key_wrk == "Space(押し上げ時)" || key_wrk == "無変換" || key_wrk == "F24" || InStr(key_wrk,"半角/全角") > 0 || InStr(key_wrk,"カタカナ") > 0) {
		enableG3 := 0
	}Else{
		GuiControl, Enable%enableG2%, KeyMuHenkanShift
		If (Strlen(KeyMuHenkanShift) == 0) {
			enableG3 := 1
		}Else{
			enableG3 := 0
		}
	}
	GuiControl, Enable%enableG3%, KeyTaskClass
	GuiControl, Enable%enableG3%, KeyTaskName
	GuiControl, Enable%enableG3%, KeyTaskTitle
	GuiControl, Enable%enableG3%, KeyTaskShortcut
	;GuiControl, Enable%enableG3%, KeyTaskCmd
	GuiControl, Enable%enableG3%, KeyLancherName
	GuiControl, Enable%enableG3%, KeyTaskStyle
	GuiControl, Enable%enableG3%, KeyTaskAssignHenkan
	GuiControl, Enable%enableG3%, GetWinClassBtn
	GuiControl, Enable%enableG3%, GetWinExeBtn
Return
;=========================================== ウィンドウクラスを取得ボタンがクリックされた時の処理
GetWinClass:
	;-------------------------------------- 設定画面をスクリーンの外に移動する（見かけ上非表示にする）
	HideConfigWindow(ConfigKeyhairetsuGuiTitle, WinPosX, WinPosY)
	;-------------------------------------- AutoHotkey以外のウィンドウがアクティブになるまで待つ
	LimitSec := 60
	msg = %LimitSec%秒以内に対象ウインドウをクリックしてください。
	ShowSplashImage(msg)
	Res := WaitExptAutohotkeyWin(LimitSec)
	;-------------------------------------- 何らかのウィンドウがアクティブになったら実行ファイル名を取得してリストビューに追加する
	HideSplashImage()
	If (Res == 0) {
		Gosub GetWinClassAndSet
	}Else{
		ShowSplashImage("対象ウインドウ情報が取得できませんでした")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	}
	;-------------------------------------- 設定画面を元の位置に戻す
	ShowConfigWindow(ConfigKeyhairetsuGuiTitle, WinPosX, WinPosY)
Return
;=========================================== 実行ファイル名を取得ボタンがクリックされた時の処理
GetWinExe:
	;-------------------------------------- 設定画面をスクリーンの外に移動する（見かけ上非表示にする）
	HideConfigWindow(ConfigKeyhairetsuGuiTitle, WinPosX, WinPosY)
	;-------------------------------------- AutoHotkey以外のウィンドウがアクティブになるまで待つ
	LimitSec := 60
	msg = %LimitSec%秒以内に対象ウインドウをクリックしてください。
	ShowSplashImage(msg)
	Res := WaitExptAutohotkeyWin(LimitSec)
	;-------------------------------------- 何らかのウィンドウがアクティブになったら実行ファイル名を取得してリストビューに追加する
	HideSplashImage()
	If (Res == 0) {
		Gosub GetWinExeAndSet
	}Else{
		ShowSplashImage("対象ウインドウ情報が取得できませんでした")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	}
	;-------------------------------------- 設定画面を元の位置に戻す
	ShowConfigWindow(ConfigKeyhairetsuGuiTitle, WinPosX, WinPosY)
Return
;=========================================== ウィンドウクラスを取得してキー配列設定にセットする
GetWinClassAndSet:
	;-------------------------------------- アクティブウィンドウのタイトルを取得する
	WinGetActiveTitle, WinTitle
	;-------------------------------------- アクティブウィンドウのクラスを取得する
	WinGetClass, WinClass , %WinTitle%
	;-------------------------------------- アクティブウィンドウのアイコンハンドルを取得する
	KeyFullPath := GetWinFullPath(WinTitle)
	;-------------------------------------- 指定されたウィンドウタイトルのアプリがストアアプリか確認し、ストアアプリならアプリ名を返す（関数は機能設定モジュールで定義）
	KeyTaskTitle := GetStoreAppTitle(WinTitle)
	;-------------------------------------- キー配列設定にセットする
	KeyTaskName := WinClass
	GuiControl, Text, KeyTaskClass, ahk_class
	GuiControl, Text, KeyTaskName, %KeyTaskName%
	GuiControl, Text, KeyTaskTitle, %KeyTaskTitle%
	WinActivate AHK_EXE AutoHotkey.exe
	;-------------------------------------- 処理完了メッセージを表示する
	ShowSplashImage("「" . KeyTaskName . "」を登録しました")
	SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
Return
;=========================================== 実行ファイル名を取得してキー配列設定にセットする
GetWinExeAndSet:
	;-------------------------------------- アクティブウィンドウのタイトルを取得する
	WinGetActiveTitle, WinTitle
	;-------------------------------------- アクティブウィンドウの実行ファイル名を取得する
	WinGet, WinExe , ProcessName, %WinTitle%
	;-------------------------------------- アクティブウィンドウのアイコンハンドルを取得する
	KeyFullPath := GetWinFullPath(WinTitle)
	;-------------------------------------- 指定されたウィンドウタイトルのアプリがストアアプリか確認し、ストアアプリならアプリ名を返す（関数は機能設定モジュールで定義）
	KeyTaskTitle := GetStoreAppTitle(WinTitle)
	;-------------------------------------- キー配列設定にセットする
	KeyTaskName := WinExe
	GuiControl, Text, KeyTaskClass, ahk_exe
	GuiControl, Text, KeyTaskName, %KeyTaskName%
	GuiControl, Text, KeyTaskTitle, %KeyTaskTitle%
	WinActivate AHK_EXE AutoHotkey.exe
	;-------------------------------------- 処理完了メッセージを表示する
	ShowSplashImage("「" . KeyTaskName . "」を登録しました")
	SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
Return
;=========================================== 指定されたウィンドウタイトルの実行ファイルのフルパス名を取得する
GetWinFullPath(WinTitle) {
	WinGet, WinID ,ID , %WinTitle%
	WinGet, KeyFullPath, ProcessPath, ahk_id %WinID%
	Return, KeyFullPath
}
;=========================================== キー配列プリセットボタンを押したときの処理
Buttonキー配列プリセット:
	Gosub キー配列設定
Return
;=========================================== 保存ボタンを押したときの処理
OnclickSaveKeyhairetsuButton:
	SplashImage,,B1 FM12 CWFFFFA2,,キー配列を保存しています
	;-------------------------------------- エディットボックスの入力内容を取得する
	;Gui,2: Submit, NoHide
	Gui,2: Submit
	Sleep 300
	;-------------------------------------- エディットボックスの内容を保存する
	SelectedRow := LV_GetNext(0)
	LV_GetText(SelectedKey, SelectedRow)
	section = KEYHAIRETSU%SelectedRow%
	Gosub SaveKeyHairetsu
	SplashImage,off
	Gui,2: Show
	;MsgBox ,,　,キー配列を保存しました
	;-------------------------------------- リストビューにフォーカスをあわせる（ここでフォーカスをあててないと次にリストビューの項目をクリックしたときに正しくイベントが受け取れないため）
	GuiControl, Focus, KeylistLV
Return
;=========================================== GUI画面を閉じたときの処理
2GuiClose:
	ExistConfigKeyhairetsu := 0
	Gui,2: Destroy
	;-------------------------------------- キー配列設定画面を操作可能に戻す
	;Gui,1: Show
	ExistConfigKeyPreset := 0
	Gosub キー配列設定
Return
;=========================================== 特殊なキー表記を一般的な内容に変換する
ReplaceKey(ByRef key,mode) {
	key_nmem := Object()
	key_trans := Object()
	;-------------------------------------- キー表記を配列に格納する
	key_nmem[1] := "sc027"
	key_nmem[2] := "sc028"
	key_nmem[3] := "sc033"
	key_nmem[4] := "sc034"
	key_nmem[5] := "sc073"
	key_nmem[6] := "sc07B"
	key_nmem[7] := "sc079"
	key_nmem[8] := "sc070"
	key_nmem[9] := "sc029"
	key_nmem[10] := "Space up"
	key_nmem[11] := "--"
	key_nmem[12] := "LWin up"
	key_nmem[13] := "RWin up"
	key_trans[1] := ";"
	key_trans[2] := ":"
	key_trans[3] := ","
	key_trans[4] := "."
	key_trans[5] := "バックスラッシュ"
	key_trans[6] := "無変換"
	key_trans[7] := "変換"
	key_trans[8] := "カタカナ"
	key_trans[9] := "半角/全角"
	key_trans[10] := "Space(押し上げ時)"
	key_trans[11] := "-"
	key_trans[12] := "LWin"
	key_trans[13] := "RWin"
	;-------------------------------------- 特殊なキー表記を一般的な内容に変換する
	If (mode == 1 || mode == 2) {
		i = 14
	}Else{
		i = 11
	}
	loop %i% {
		If (mode == 1 || mode == 3) {
			key_a := key_nmem[A_Index]
			key_b := key_trans[A_Index]
		}
		If (mode == 2) {
			key_a := key_trans[A_Index]
			key_b := key_nmem[A_Index]
		}
		If (mode == 4) {
			key_a := "{"key_trans[A_Index]"}"
			key_b := "{"key_nmem[A_Index]"}"
		}
		StringReplace key,key,%key_a%,%key_b%,All
	}
}
;=========================================== キー配列設定を保存する
SaveKeyHairetsu:
	;-------------------------------------- キーアサイン
	IniWrite,%key_index%,%ini_file_name%,%section%,KeyAssign
	;-------------------------------------- 単独打鍵（英数）
	;-------- 一般的なキー表記をAutohotkey独自の内容に変換して保存（以下同様）
	ReplaceKey(KeySingleAlp,4)
	IniWrite,%KeySingleAlp%,%IniFileName%,%section%,KeySingleAlp
	key_single[key_index_alp] := KeySingleAlp
	;-------------------------------------- 単独打鍵（日本語）
	ReplaceKey(KeySingleJpn,4)
	IniWrite,%KeySingleJpn%,%IniFileName%,%section%,KeySingleJpn
	key_single[key_index_jpn] := KeySingleJpn
	;-------------------------------------- ＋左シフトキー（英数）
	ReplaceKey(KeyLShiftAlp,4)
	;--------------------------------- ユーザーがクリアした時は特殊文字(USN)を埋め込む
	If (StrLen(KeyLShiftAlp) == 0) {
		strWrk := "USN"
	}Else{
		strWrk := KeyLShiftAlp
	}
	IniWrite,%strWrk%,%IniFileName%,%section%,KeyLShiftAlp
	key_lshift[key_index_alp] := KeyLShiftAlp
	;-------------------------------------- ＋右シフトキー（英数）
	ReplaceKey(KeyRShiftAlp,4)
	;--------------------------------- ユーザーがクリアした時は特殊文字(USN)を埋め込む
	If (StrLen(KeyRShiftAlp) == 0) {
		strWrk := "USN"
	}Else{
		strWrk := KeyRShiftAlp
	}
	IniWrite,%strWrk%,%IniFileName%,%section%,KeyRShiftAlp
	key_rshift[key_index_alp] := KeyRShiftAlp
	;-------------------------------------- ＋左シフトキー（日本語）
	ReplaceKey(KeyLShiftJpn,4)
	;--------------------------------- ユーザーがクリアした時は特殊文字(USN)を埋め込む
	If (StrLen(KeyLShiftJpn) == 0) {
		strWrk := "USN"
	}Else{
		strWrk := KeyLShiftJpn
	}
	IniWrite,%strWrk%,%IniFileName%,%section%,KeyLShiftJpn
	key_lshift[key_index_jpn] := KeyLShiftJpn
	;-------------------------------------- ＋右シフトキー（日本語）
	ReplaceKey(KeyRShiftJpn,4)
	;--------------------------------- ユーザーがクリアした時は特殊文字(USN)を埋め込む
	If (StrLen(KeyRShiftJpn) == 0) {
		strWrk := "USN"
	}Else{
		strWrk := KeyRShiftJpn
	}
	IniWrite,%strWrk%,%IniFileName%,%section%,KeyRShiftJpn
	key_rshift[key_index_jpn] := KeyRShiftJpn
	;-------------------------------------- ＋Specialキー（英数）
	ReplaceKey(KeySpecialAlp,4)
	;--------------------------------- ユーザーがクリアした時は特殊文字(USN)を埋め込む
	If (StrLen(KeySpecialAlp) == 0) {
		strWrk := "USN"
	}Else{
		strWrk := KeySpecialAlp
	}
	IniWrite,%strWrk%,%IniFileName%,%section%,KeySpecialAlp
	key_Special[key_index_alp] := KeySpecialAlp
	;-------------------------------------- ＋Specialキー（日本語）
	ReplaceKey(KeySpecialJpn,4)
	;--------------------------------- ユーザーがクリアした時は特殊文字(USN)を埋め込む
	If (StrLen(KeySpecialJpn) == 0) {
		strWrk := "USN"
	}Else{
		strWrk := KeySpecialJpn
	}
	IniWrite,%strWrk%,%IniFileName%,%section%,KeySpecialJpn
	key_Special[key_index_jpn] := KeySpecialJpn
	;-------------------------------------- ＋変換キー（英数）
	ReplaceKey(KeyHenkanAlp,4)
	IniWrite,%KeyHenkanAlp%,%IniFileName%,%section%,KeyHenkanAlp
	key_henkan[key_index_alp] := KeyHenkanAlp
	;-------------------------------------- ＋変換キー（日本語）
	ReplaceKey(KeyHenkanJpn,4)
	IniWrite,%KeyHenkanJpn%,%IniFileName%,%section%,KeyHenkanJpn
	key_henkan[key_index_jpn] := KeyHenkanJpn
	;-------------------------------------- ＋変換キー（共通）
	ReplaceKey(KeyHenkanShift,4)
	IniWrite,%KeyHenkanShift%,%IniFileName%,%section%,KeyHenkanShift
	key_henkan_shift[key_index] := KeyHenkanShift
	ReplaceKey(KeyHenkanAlt,4)
	IniWrite,%KeyHenkanAlt%,%IniFileName%,%section%,KeyHenkanAlt
	key_henkan_alt[key_index] := KeyHenkanAlt
	;-------------------------------------- ＋無変換キー（英数）
	ReplaceKey(KeyMuHenkanAlp,4)
	IniWrite,%KeyMuHenkanAlp%,%IniFileName%,%section%,KeyMuhenkanAlp
	key_muhenkan[key_index_alp] := KeyMuHenkanAlp
	;-------------------------------------- ＋無変換キー（日本語）
	ReplaceKey(KeyMuHenkanJpn,4)
	IniWrite,%KeyMuHenkanJpn%,%IniFileName%,%section%,KeyMuhenkanJpn
	key_muhenkan[key_index_jpn] := KeyMuHenkanJpn
	;-------------------------------------- ＋無変換キー（共通）
	ReplaceKey(KeyMuHenkanShift,4)
	IniWrite,%KeyMuHenkanShift%,%IniFileName%,%section%,KeyMuhenkanShift
	key_muhenkan_shift[key_index] := KeyMuHenkanShift
	ReplaceKey(KeyMuHenkanAlt,4)
	IniWrite,%KeyMuHenkanAlt%,%IniFileName%,%section%,KeyMuhenkanAlt
	key_muhenkan_alt[key_index] := KeyMuHenkanAlt
	;-------------------------------------- ＋アプリケーションキー（共通）
	ReplaceKey(KeyAppsKey,4)
	IniWrite,%KeyAppsKey%,%IniFileName%,%section%,KeyAppsKey
	key_appskey[key_index] := KeyAppsKey
	ReplaceKey(KeyAppsKeyShift,4)
	IniWrite,%KeyAppsKeyShift%,%IniFileName%,%section%,KeyAppsKeyShift
	key_appskey_shift[key_index] := KeyAppsKeyShift
	ReplaceKey(KeyAppsKeyAlt,4)
	IniWrite,%KeyAppsKeyAlt%,%IniFileName%,%section%,KeyAppsKeyAlt
	key_appskey_alt[key_index] := KeyAppsKeyAlt
	;-------------------------------------- タスク制御情報
	IniWrite,%KeyTaskClass%,%IniFileName%,%section%,TaskClass
	task_class[key_index] := KeyTaskClass
	IniWrite,%KeyTaskName%,%IniFileName%,%section%,TaskName
	task_name[key_index] := KeyTaskName
	IniWrite,%KeyTaskTitle%,%IniFileName%,%section%,TaskTitle
	task_Title[key_index] := KeyTaskTitle
	IniWrite,%KeyTaskShortcut%,%IniFileName%,%section%,TaskShortcut
	task_shortcut[key_index] := KeyTaskShortcut
	;IniWrite,%KeyTaskCmd%,%IniFileName%,%section%,TaskCmd
	;task_cmd[key_index] := KeyTaskCmd
	IniWrite,%KeyLancherName%,%IniFileName%,%section%,TaskLancherName
	task_lancher_name[key_index] := KeyLancherName
	If (Strlen(KeyTaskClass) == 0) {
		KeyTaskStyle := 
	}
	IniWrite,%KeyTaskStyle%,%IniFileName%,%section%,TaskStyle
	task_style[key_index] := KeyTaskStyle
	
	IniWrite,%KeyFullPath%,%IniFileName%,%section%,TaskFullPath
	task_full_path[key_index] := KeyFullPath
	
	IniWrite,%KeyTaskAssignHenkan%,%IniFileName%,%section%,KeyTaskAssignHenkan
	task_assign_henkan[key_index] := KeyTaskAssignHenkan
Return
