﻿マウスジェスチャー設定:
	;-------------------------------------- 既に設定画面を開いているときは何もしない
	If (ExistConfigMouseGesture == 1) {
		Return
	}Else{
		ExistConfigMouseGesture := 1
	}
	;-------------------------------------- 画面を新規作成する
	ConfigMouseGestureGuiTitle := "マウスジェスチャー設定"
	Gui, MGConfig: New,, %ConfigMouseGestureGuiTitle%
	Gui, MGConfig: Font, S11
	;-------------------------------------- 標準のジェスチャー名称を取得する
	IniRead,default_mg_name,%IniFileName%,MOUSEGESTURE_NAME,MgName1,-1
	;-------------------------------------- マウスジェスチャー・グループボックス
	Gui, MGConfig: Add, GroupBox, x22 y14 w1090 h420 , マウスジェスチャー
	;-------------------------------------- マウスジェスチャー・リストビュー
	lsvMgColName := "マウスジェスチャー名"	
	Loop %MG_CelCount% {
		lsvMgColName := lsvMgColName . "|機能名" . A_Index . "|コマンド" . A_Index
	}
	lsvMgColName := lsvMgColName .  "|ジェスチャーモード|使用可否" 
	Gui, MGConfig: Add, ListView, x47 y49 w230 h320  NoSortHdr Grid -Multi AltSubmit vlsvMG_ListView gOnClickMG_ListView, %lsvMgColName%
	;--------------- マウスジェスチャー登録内容をリストビューに転送する
	lsvRowCtr := 0
	Loop {
		;--------------- 登録されているマウスジェスチャー名を取得する
		IniRead,mg_name,%IniFileName%,MOUSEGESTURE_NAME,MgName%A_Index%,-1
		If (mg_name == -1) {
			Break
		}
		;--------------- マウスジェスチャー名をリストビューに追加する
		LV_Add("", mg_name)
		lsvRowCtr += 1
		lsvColCtr := 1
		Loop %MG_CelCount% {
			;--------------- 機能名をリストビューに追加する
			lsvColCtr += 1
			targetCol = Col%lsvColCtr%
			LV_Modify(lsvRowCtr, targetCol, MG_String[mg_name,A_Index])
			;--------------- コマンドをリストビューに追加する
			lsvColCtr += 1
			targetCol = Col%lsvColCtr%
			LV_Modify(lsvRowCtr, targetCol, MG_Command[mg_name,A_Index])
		}
		;--------------- ジェチャーモードをリストビューに追加する
		lsvColCtr += 1
		targetCol = Col%lsvColCtr%
		LV_Modify(lsvRowCtr, targetCol, MG_ModeTbl[mg_name])
		;--------------- ジェスチャー使用可否をリストビューに追加する
		lsvColCtr += 1
		targetCol = Col%lsvColCtr%
		LV_Modify(lsvRowCtr, targetCol, MG_EnableTbl[mg_name])
	}	
	;-------------------------------------- マウスジェスチャー名
	Gui, MGConfig: Add, Text, x297 y49 w120 h20 , マウスジェスチャー名
	Gui, MGConfig: Add, Edit, x417 y49 w220 h20 vedtMG_Name gOnEditMG_Name,
	;-------------------------------------- マウスジェスチャー登録内容
	txtLbl := "機能名"
	txtCmd :=  "コマンド"
	txtLblPosY := 89
	txtCmdPosY := 109
	txtPosStep := 60
	edtPosStep := 150
	pctPosY :=	90
	edtNo := 1
	Loop 5 {
		;----------- テキストラベル
		Gui, MGConfig: Add, Text, x297 y%txtLblPosY% w100 h20, %txtLbl%
		Gui, MGConfig: Add, Text, x297 y%txtCmdPosY% w100 h20, %txtCmd%
		;----------- エディットボックス
		;edtPosX := 347
		edtPosX := 377
		pctPosX :=	342
		Loop 5 {
			;Gui, MGConfig: Add, Edit, w140 h20 x%edtPosX% y%txtLblPosY% vedtMG_Str%edtNo% gOnEditMG_Str,
			;Gui, MGConfig: Add, Edit, w140 h20 x%edtPosX% y%txtCmdPosY% vedtMG_Cmd%edtNo% gOnEditMG_Cmd,
			Gui, MGConfig: Add, Picture, w34 h34 x%pctPosX% y%pctPosY%, %MG_TraceImageName%%edtNo%.png
			Gui, MGConfig: Add, Edit, w110 h20 x%edtPosX% y%txtLblPosY% vedtMG_Str%edtNo% gOnEditMG_Str,
			Gui, MGConfig: Add, Edit, w110 h20 x%edtPosX% y%txtCmdPosY% vedtMG_Cmd%edtNo% gOnEditMG_Cmd,
			edtPosX += edtPosStep
			pctPosX += edtPosStep
			edtNo += 1
		}
		txtLblPosY += txtPosStep
		txtCmdPosY += txtPosStep
		pctPosY += txtPosStep
	}
	;-------------------------------------- ボタン
	;Gui, MGConfig: Add, Button, x167 y384 w90 h30 , 保存
	Gui, MGConfig: Add, Button, x120 y384 w90 h30 Disabled1 vbtnMG_Delete gOnClickMG_Delete, 削除
	Gui, MGConfig: Add, Button, x897 y384 w90 h30 Disabled1 vbtnMG_Add gOnClickMG_Add, 追加
	Gui, MGConfig: Add, Button, x997 y384 w90 h30 Disabled1 vbtnMG_Modify gOnClickMG_Modify, 変更
	;-------------------------------------- ジェスチャーモードラジオボタン
	Gui, MGConfig: Add, Radio, x297 y375 w200 h30 Checked1 Disabled1 vrdoMG_menu_mode, ジェスチャーメニューを表示する
	Gui, MGConfig: Add, Radio, x297 y400 w200 h30 Disabled1 vrdoMG_trace_mode, ジェスチャーアイコンを表示する
	;-------------------------------------- ジェスチャー使用可否チェックボックス
	Gui, MGConfig: Add, Checkbox, x500 y375 w200 h30 Checked1 Disabled1 vchkMG_enable, このジェスチャーを使用する
	;-------------------------------------- 対象アプリ・グループボックス
	Gui, MGConfig: Add, GroupBox, x22 y449 w620 h330 , 対象アプリ
	;-------------------------------------- 対象アプリ・リストビュー
	Gui, MGConfig: Add, ListView, x42 y479 w580 h200 NoSortHdr Grid -Multi AltSubmit vlsvAPP_ListView gOnClickAPP_ListView, 実行ファイル名|アプリ名|割当てジェスチャー名
	Loop {
		IniRead,mg_app_name,%IniFileName%,MOUSEGESTURE_APP,MgAppName%A_Index%,-1
		If (mg_app_name == -1) {
			Break
		}
		IniRead,mg_app_title,%IniFileName%,MOUSEGESTURE_APP,MgAppTitle%A_Index%,-1
		If (mg_app_title == -1) {
			mg_app_title := ""
		}
		IniRead,mg_assign,%IniFileName%,MOUSEGESTURE_APP_%mg_app_name%%mg_app_title%,MgAssign,-1
		If (mg_assign == -1) {
			mg_assign := ""
		}
		LV_Add("", mg_app_name,mg_app_title,mg_assign)
	}
	;----------- 列幅を調整する
	;LV_ModifyCol(1)
	;-------------------------------------- ボタン
	Gui, MGConfig: Add, Button, x333 y693 w90 h30 gOnClickAPP_Add, 追加
	Gui, MGConfig: Add, Button, x433 y693 w90 h30 Disabled1 vbtnApp_Modify gOnClickAPP_Modify, アプリ名変更
	Gui, MGConfig: Add, Button, x533 y693 w90 h30 Disabled1 vbtnApp_Delete gOnClickAPP_Delete, 削除
	;-------------------------------------- 割当てるマウスジェスチャー・ドロップダウンリスト
	mg_count := 0
	Loop {
		;--------------- 登録されているマウスジェスチャー名を取得する（標準ジェスチャーは無視する）
		If (A_Index > 1) {
			IniRead,mg_name,%IniFileName%,MOUSEGESTURE_NAME,MgName%A_Index%,-1
			If (mg_name == -1) {
				Break
			}
			If (A_Index == 2) {
				ddlAssignGesture = %mg_name%
			}Else{
				ddlAssignGesture = %ddlAssignGesture%|%mg_name%
			}
			mg_count += 1
		}
	}
	If (mg_count == 0) {
		height := 0
	}Else{
		height := 999
	}
	Gui, MGConfig: Add, Text, x154 y738 w160 h20 , 割当てるマウスジェスチャー
	;Gui, MGConfig: Add, DropDownList, x210 y737 w310 h%height% Disabled1 vddlAssignGesture gOnClickAssignGesture, %ddlAssignGesture%
	Gui, MGConfig: Add, DropDownList, x312 y737 w310 h%height% Disabled1 vddlAssignGesture gOnClickAssignGesture, %ddlAssignGesture%
	;Gui, MGConfig: Add, Button, x532 y734 w90 h30 Disabled1 vbtnApp_Assign gOnClickApp_Assign, 割当て
	;-------------------------------------- 右クリックで対象ウィンドウを変更するアプリ
	Gui, MGConfig: Add, GroupBox, x662 y449 w450 h330 , 右クリックで対象ウィンドウを変更するアプリ
	Gui, MGConfig: Add, ListView, x682 y479 w410 h200 NoSortHdr Grid -Multi AltSubmit vlsvRClickAPP_ListView gOnClickRClickAPP_ListView, 実行ファイル名|アプリ名
	Loop {
		IniRead,mg_rclick_app_name,%IniFileName%,MOUSEGESTURE_RCLICK_APP,MgRClickAppName%A_Index%,-1
		If (mg_rclick_app_name == -1) {
			Break
		}
		IniRead,mg_rclick_app_title,%IniFileName%,MOUSEGESTURE_RCLICK_APP,MgRClickAppTitle%A_Index%,-1
		If (mg_rclick_app_title == -1) {
			mg_rclick_app_title := ""
		}
		LV_Add("", mg_rclick_app_name, mg_rclick_app_title)
	}
	;-------------------------------------- ボタン
	Gui, MGConfig: Add, Button, x802 y714 w90 h30 gOnClickRClickAPP_Add, 追加
	Gui, MGConfig: Add, Button, x902 y714 w90 h30 Disabled1 vbtnRClick_APP_Modify gOnClickRClickAPP_Modify, アプリ名変更
	Gui, MGConfig: Add, Button, x1002 y714 w90 h30 Disabled1 vbtnRClick_APP_Delete gOnClickRClickAPP_Delete, 削除
	;-------------------------------------- 使用方法ラジオボタン
	not_use_chk := ABS(mg_use_default - 1)
	Gui, MGConfig: Add, Radio, x297 y785 w400 h30 Checked%mg_use_default% vrdoMG_use_default, ジェスチャー未割り当てのアプリは標準ジェスチャーを使用する
	Gui, MGConfig: Add, Radio, x297 y810 w400 h30 Checked%not_use_chk% vrdoMG_not_use, ジェスチャー未割り当てのアプリはジェスチャー機能を無効にする
	;-------------------------------------- OK・キャンセルボタン
	;Gui, MGConfig: Add, Button, x327 y699 w90 h30 , 保存
	Gui, MGConfig: Add, Button, x902 y799 w90 h30 vbtnOK gOnClickOK, OK
	Gui, MGConfig: Add, Button, x1002 y799 w90 h30 gMGConfigGuiClose, キャンセル
	;-------------------------------------- 画面を表示する
	Gui, MGConfig: Show, h852 w1144
	;-------------------------------------- 変更有無判定変数を初期化
	IsChangeConfig := 0
	Return
;=========================================== マウスジェスチャー・リストビューをクリックしたときの処理
OnClickMG_ListView:
	;-------------------------------------- リストビューがフォーカスを受け取ったときは、処理対象のリストビューを変更する
	If (A_GuiEvent == "F" || A_GuiEvent == "Normal") {
		Gui, MGConfig: ListView, lsvMG_ListView
	}
	;-------------------------------------- リストビューの選択状態が変化したときは、リストビューにフォーカスをあわせる（ここでフォーカスをあててないと次にリストビューの項目をクリックしたときに正しくイベントが受け取れないため）
	If (A_GuiEvent == "I") {		
		GuiControl, Focus, lsvMG_ListView
		Return
	}
	;------------------------------ 選択されている行の行番号を取得する
	SelectedRow := LV_GetNext(0)
	;------------------------------ 項目が埋まっている行がクリックされたときだけ処理する
	If (SelectedRow > 0) {
		;--------------- マウスジェスチャー名をエディットボックスに追加する
		LV_GetText(mg_name, SelectedRow, 1)
		GuiControl, Text, edtMG_Name, %mg_name%
		;--------------- 機能名とコマンドをエディットボックスに追加する
		lsvColCtr := 1
		Loop %MG_CelCount% {
			;--------------- 機能名をエディットボックスに追加する
			lsvColCtr += 1
			LV_GetText(mg_str, SelectedRow, lsvColCtr)
			GuiControl, Text, edtMG_Str%A_Index%, %mg_str%
			;--------------- コマンドをエディットボックスに追加する
			lsvColCtr += 1
			LV_GetText(mg_cmd, SelectedRow, lsvColCtr)
			GuiControl, Text, edtMG_Cmd%A_Index%, %mg_cmd%
		}
		;--------------- ジェスチャーモードをラジオボタンに反映させる
		lsvColCtr += 1
		LV_GetText(mg_mode, SelectedRow, lsvColCtr)
		If (mg_mode == 1) {
			GuiControl,,rdoMG_menu_mode, 1
			GuiControl,,rdoMG_trace_mode, 0
		}Else{
			GuiControl,,rdoMG_menu_mode, 0
			GuiControl,,rdoMG_trace_mode, 1
		}
		;--------------- ジェスチャー使用可否をチェックボックスに反映させる
		lsvColCtr += 1
		LV_GetText(mg_enable, SelectedRow, lsvColCtr)
		If (mg_enable == 1) {
			GuiControl,,chkMG_enable, 1
		}Else{
			GuiControl,,chkMG_enable, 0
		}
		;--------------- 削除ボタンをコントロールする
		If (mg_name == default_mg_name) {
			;-------------------------------------- 選択したマウスジェスチャーが標準ジェスチャーの場合は、削除ボタンと使用可否チェックボックスを押せないようにする
			btnMG_DeleteEnable := 0
			chkMG_enableEnable := 0
		}Else{
			;-------------------------------------- 削除ボタンと使用可否チェックボックスを押せるようにする
			btnMG_DeleteEnable := 1
			chkMG_enableEnable := 1
		}
		;-------------------------------------- 削除ボタンを制御する
		GuiControl, Enable%btnMG_DeleteEnable%, btnMG_Delete
		;-------------------------------------- 使用可否チェックボックスを制御する
		GuiControl, Enable%chkMG_enableEnable%, chkMG_enable
		;-------------------------------------- ジェスチャーモードラジオボタンを押せるようにする
		GuiControl, Enable1, rdoMG_menu_mode
		GuiControl, Enable1, rdoMG_trace_mode		
	}Else{
		;------------------------------ 項目がない行をクリックしたときはボタンを押せないようにする
		GuiControl, Enable0, btnMG_Modify
		GuiControl, Enable0, btnMG_Delete
		GuiControl, Enable0, rdoMG_menu_mode
		GuiControl, Enable0, rdoMG_trace_mode
		GuiControl, Enable0, chkMG_enable
	}
Return
;=========================================== マウスジェスチャー名が編集されたときの処理
OnEditMG_Name:
	;-------------------------------------- エディットボックスの入力内容を取得する
	Gui, MGConfig: Submit, NoHide
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvMG_ListView
	;-------------------------------------- リストビューの行数を取得する
	lsvMG_RowCount := LV_GetCount() 
	;-------------------------------------- マウスジェスチャー名がすでにリストビューに登録されている場合は追加ボタンを押せないようにする
	btnMG_AddEnable := 1
	Loop %lsvMG_RowCount% {
		LV_GetText(mg_name, A_Index, 1)
		If (edtMG_Name == mg_name) {
			btnMG_AddEnable := 0
			Break
		}
	}
	;-------------------------------------- 選択されているマウスジェスチャー名を取得する
	SelectedRow := LV_GetNext(0)
	LV_GetText(mg_name, SelectedRow, 1)
	If (mg_name == default_mg_name) {
		;-------------------------------------- 選択されているマウスジェスチャーが標準ジェスチャーの場合は変更ボタンを押せないようにする
		btnMG_ModifyEnable := 0
	}Else{
		;-------------------------------------- マウスジェスチャーの変更ボタンが押せるか判定する
		btnMG_ModifyEnable := IsEnablebtnMG_Modify(lsvMG_RowCount,edtMG_Name)
	}
	;-------------------------------------- ボタンを制御する
	GuiControl, Enable%btnMG_AddEnable%, btnMG_Add
	GuiControl, Enable%btnMG_ModifyEnable%, btnMG_Modify
	GuiControl, Enable1, rdoMG_menu_mode
	GuiControl, Enable1, rdoMG_trace_mode
	GuiControl, Enable1, chkMG_enable
Return
;=========================================== 機能名、コマンドが編集されたときの処理
OnEditMG_Str:
OnEditMG_Cmd:
	;-------------------------------------- エディットボックスの入力内容を取得する
	Gui, MGConfig: Submit, NoHide
	If (edtMG_Name == default_mg_name) {
		;-------------------------------------- 入力されているマウスジェスチャーが標準ジェスチャーの場合は変更ボタンを押せるようにする
		btnMG_ModifyEnable := 1
	}Else{
		;-------------------------------------- マウスジェスチャーの変更ボタンが押せるか判定する
		btnMG_ModifyEnable := IsEnablebtnMG_Modify(lsvMG_RowCount,edtMG_Name)
	}
	GuiControl, Enable%btnMG_ModifyEnable%, btnMG_Modify
Return
;=========================================== マウスジェスチャーの変更ボタンが押せるか判定する
IsEnablebtnMG_Modify(lsvMG_RowCount,edtMG_Name) {
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvMG_ListView
	;-------------------------------------- マウスジェスチャー名がリストビューに登録されている場合は変更ボタンが押せる
	btnMG_ModifyEnable := 0
	Loop %lsvMG_RowCount% {
		LV_GetText(mg_name, A_Index, 1)
		If (edtMG_Name == mg_name) {
			Return 1
			Break
		}
	}
	Return 0
}
;=========================================== マウスジェスチャーの削除ボタンがクリックされたときの処理
OnClickMG_Delete:
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvMG_ListView
	;-------------------------------------- 選択されているマウスジェスチャー名を取得する
	SelectedRow := LV_GetNext(0)
	LV_GetText(mg_name, SelectedRow, 1)
	MsgBox ,4,　,「%mg_name%」を削除しますか？
	IfMsgBox YES
	{
		LV_Delete(SelectedRow)
		;-------------------------------------- 割当てるジェスチャー・ドロップダウンリストの項目を更新する
		Gosub Modify_dllAssignGesture
		GuiControl, Enable0, btnMG_Delete
		;-------------------------------------- 削除したマウスジェスチャーが割当てられたアプリを検索し標準ジェスチャーに変更する
		;-------------------------------------- 処理対象のリストビューを変更する
		Gui, MGConfig: ListView,lsvAPP_ListView
		;-------------------------------------- リストビューの行数を取得する
		lsvAPP_RowCount := LV_GetCount() 
		Loop %lsvAPP_RowCount% {
			LV_GetText(assign_ges, A_Index, 2)
			If (assign_ges == mg_name) {
				;-------------------------------------- 割当てジェスチャーを標準に変更する
				LV_Modify(A_Index, "col2", default_mg_name)
			}
		}
		;-------------------------------------- ボタンを制御する
		GuiControl, Enable1, btnMG_Add
		;-------------------------------------- 処理完了メッセージを表示する
		ShowSplashImage("「" . mg_name . "」を削除しました")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%	
		IsChangeConfig := 1
	}		
Return
;=========================================== マウスジェスチャーの追加ボタンがクリックされたときの処理
OnClickMG_Add:
	;-------------------------------------- エディットボックスの入力内容を取得する
	Gui, MGConfig: Submit, NoHide
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvMG_ListView
	;-------------------------------------- 対象行番号をセットする
	TargetRow := LV_GetCount() + 1
	;-------------------------------------- マウスジェスチャー名をリストビューに反映させる
	LV_Add("", edtMG_Name)
	;-------------------------------------- 割当てるジェスチャー・ドロップダウンリストの項目を更新する
	Gosub Modify_dllAssignGesture
	;-------------------------------------- 機能名とコマンドをリストビューに反映させる
	Gosub UpdateStrCmdForMG_ListView
	;-------------------------------------- 処理完了メッセージを表示する
	ShowSplashImage("「" . edtMG_Name . "」を追加しました")
	SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	IsChangeConfig := 1
Return
;=========================================== マウスジェスチャーの変更ボタンがクリックされたときの処理
OnClickMG_Modify:
	;-------------------------------------- エディットボックスの入力内容を取得する
	Gui, MGConfig: Submit, NoHide
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvMG_ListView
	;-------------------------------------- 対象行番号をセットする
	TargetRow := LV_GetNext(0)
	;-------------------------------------- 機能名とコマンドをリストビューに反映させる
	Gosub UpdateStrCmdForMG_ListView
	;-------------------------------------- 処理完了メッセージを表示する
	ShowSplashImage("「" . edtMG_Name . "」を変更しました")
	SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	IsChangeConfig := 1
Return
;=========================================== 割当てるジェスチャー・ドロップダウンリストの項目を更新する
Modify_dllAssignGesture:
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvMG_ListView
	;-------------------------------------- リストビューの行数を取得する
	lsvMG_RowCount := LV_GetCount() 
	;-------------------------------------- リストビューを全検索してマウスジェスチャー名を取得する
	ddlAssignGesture := ""
	Loop %lsvMG_RowCount% {
		;--------------- 登録されているマウスジェスチャー名を取得する（標準ジェスチャーは無視する）
		If (A_Index > 1) {
			LV_GetText(recorded_mg_name, A_Index, 1)
			If (A_Index == 2) {
				ddlAssignGesture = %recorded_mg_name%
			}Else{
				ddlAssignGesture = %ddlAssignGesture%|%recorded_mg_name%
			}
		}
	}
	;-------------------------------------- ドロップダウンリストの項目を更新する
	GuiControl, , ddlAssignGesture, |%ddlAssignGesture%
	If (lsvMG_RowCount == 1) {
		height := 0
	}Else{
		height := 999
	}
	GuiControl, Move, ddlAssignGesture, h%height%
Return
;=========================================== マウスジェスチャー・リストビューの機能名とコマンドを更新する
UpdateStrCmdForMG_ListView:
;------------------------------------- TargetRowに更新対象行番号をセットしてコールする
	;-------------------------------------- 機能名とコマンドをエディットボックスに反映させる
	lsvColCtr := 1
	Loop %MG_CelCount% {
		;-------------------------------------- 機能名をリストビューに反映させる
		lsvColCtr += 1
		targetCol = Col%lsvColCtr%
		LV_Modify(TargetRow, targetCol, edtMG_Str%A_Index%)
		;-------------------------------------- コマンドをリストビューに反映させる
		lsvColCtr += 1
		targetCol = Col%lsvColCtr%
		LV_Modify(TargetRow, targetCol, edtMG_Cmd%A_Index%)
	}
	;-------------------------------------- ジェスチャーモードをリストビューに反映させる
	lsvColCtr += 1
	targetCol = Col%lsvColCtr%
	If (rdoMG_menu_mode == 1) {
		LV_Modify(TargetRow, targetCol, "1")
	}Else{
		LV_Modify(TargetRow, targetCol, "2")
	}
	;-------------------------------------- ジェスチャー使用可否をリストビューに反映させる
	lsvColCtr += 1
	targetCol = Col%lsvColCtr%
	LV_Modify(TargetRow, targetCol, chkMG_enable)
Return
;=========================================== 対象アプリ・リストビューがクリックされたときの処理
OnClickAPP_ListView:
	;-------------------------------------- リストビューがフォーカスを受け取ったときは、処理対象のリストビューを変更する
	If (A_GuiEvent == "F" || A_GuiEvent == "Normal") {
		Gui, MGConfig: ListView, lsvAPP_ListView
	}
	;-------------------------------------- リストビューの選択状態が変化したときは、リストビューにフォーカスをあわせる（ここでフォーカスをあててないと次にリストビューの項目をクリックしたときに正しくイベントが受け取れないため）
	If (A_GuiEvent == "I") {		
		GuiControl, Focus, lsvAPP_ListView
		Return
	}
	;------------------------------ 選択されている行の行番号を取得する
	SelectedRow := LV_GetNext(0)
	;------------------------------ 項目が埋まっている行がクリックされたときだけ処理する
	If (SelectedRow > 0) {
		;-------------------------------------- ボタンを押せるようにする
		GuiControl, Enable1, btnApp_Modify
		GuiControl, Enable1, btnApp_Delete
		GuiControl, Enable1, ddlAssignGesture
	}Else{
		;-------------------------------------- ボタンを押せないようにする
		GuiControl, Enable0, btnApp_Modify
		GuiControl, Enable0, btnApp_Delete
		GuiControl, Enable0, ddlAssignGesture	
	}
Return
;=========================================== 対象アプリ・追加ボタンがクリックされたときの処理
OnClickAPP_Add:
	;-------------------------------------- 設定画面をスクリーンの外に移動する（見かけ上非表示にする）
	HideConfigWindow(ConfigMouseGestureGuiTitle, WinPosX, WinPosY)
	;-------------------------------------- AutoHotkey以外のウィンドウがアクティブになるまで待つ
	LimitSec := 60
	msg = %LimitSec%秒以内に対象ウインドウをクリックしてください。
	ShowSplashImage(msg)
	Res := WaitExptAutohotkeyWin(LimitSec)
	;-------------------------------------- 何らかのウィンドウがアクティブになったら実行ファイル名を取得してリストビューに追加する
	HideSplashImage()
	If (Res == 0) {
		;-------------------------------------- アクティブウィンドウのタイトルを取得する
		WinGetActiveTitle, WinTitle
		;-------------------------------------- アクティブウィンドウの実行ファイル名を取得する
		WinGet, AssignWinExe, ProcessName, %WinTitle%
		;-------------------------------------- 指定されたウィンドウタイトルのアプリがストアアプリか確認し、ストアアプリならアプリ名を返す（関数は機能設定モジュールで定義）
		AssignWinName := GetStoreAppTitle(WinTitle)
		;-------------------------------------- 処理対象のリストビューを変更する
		Gui, MGConfig: ListView,lsvAPP_ListView
		;-------------------------------------- リストビューの行数を取得する
		lsvAPP_RowCount := LV_GetCount() 
		IsExistApp := 0
		Loop %lsvAPP_RowCount% {
			LV_GetText(assign_app, A_Index, 1)
			LV_GetText(assign_app_title, A_Index, 2)
			If (AssignWinExe . AssignWinName == assign_app . assign_app_title) {
				;-------------------------------------- 既に登録されている場合は追加しない
				IsExistApp := 1
			}
		}
		;-------------------------------------- アクティブウィンドウの実行ファイル名をリストビューに追加する
		WinActivate AHK_EXE AutoHotkey.exe
		If (IsExistApp == 0) {
			LV_Add("Select", AssignWinExe, AssignWinName)
			;-------------------------------------- ボタンを制御する
			GuiControl, Enable1, ddlAssignGesture
			GuiControl, Enable0, btnApp_Assign
			;-------------------------------------- 処理完了メッセージを表示する
			ShowSplashImage("「" . AssignWinExe . "」を追加しました")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
			IsChangeConfig := 1
		}Else{
			;-------------------------------------- ボタンを制御する
			GuiControl, Enable0, ddlAssignGesture
			GuiControl, Enable0, btnApp_Assign
			;-------------------------------------- 処理完了メッセージを表示する
			ShowSplashImage("「" . AssignWinExe . "」は既に登録されています")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
		}
	}Else{
		ShowSplashImage("対象ウインドウ情報が取得できませんでした")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	}
	;-------------------------------------- 設定画面を元の位置に戻す
	ShowConfigWindow(ConfigMouseGestureGuiTitle, WinPosX, WinPosY)
Return
;=========================================== 対象アプリ・変更ボタンがクリックされたときの処理
OnClickAPP_Modify:
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvAPP_ListView
	;-------------------------------------- 選択されているアプリ名を取得する
	SelectedRow := LV_GetNext(0)
	LV_GetText(app_name, SelectedRow, 2)
	;-------------------------------------- 入力された内容でアプリ名を変更する
	InputBox, app_name, アプリ名の変更, アプリ名を入力してください。,,,150,,,,, %app_name%
	LV_Modify(SelectedRow, "Col2", app_name)
Return
;=========================================== 対象アプリ・削除ボタンがクリックされたときの処理
OnClickAPP_Delete:
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvAPP_ListView
	;-------------------------------------- 選択されているアプリ名を取得する
	SelectedRow := LV_GetNext(0)
	LV_GetText(app_name, SelectedRow, 1)
	MsgBox ,4,　,「%app_name%」を削除しますか？
	IfMsgBox YES
	{
		LV_Delete(SelectedRow)
		;-------------------------------------- ボタンを制御する
		GuiControl, Enable0, btnAPP_Modify
		GuiControl, Enable0, btnAPP_Delete
		GuiControl, Enable0, ddlAssignGesture
		GuiControl, Enable0, btnApp_Assign
		;-------------------------------------- 処理完了メッセージを表示する
		ShowSplashImage("「" . app_name . "」を削除しました")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%	
		IsChangeConfig := 1
	}		
Return
;=========================================== ジェスチャー割当てドロップダウンリストがクリックされたときの処理
OnClickAssignGesture:
	;-------------------------------------- ドロップダウンリストの選択内容を取得する
	Gui, MGConfig: Submit, NoHide
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvAPP_ListView
	;-------------------------------------- 選択されている行番号を取得する
	SelectedRow := LV_GetNext(0)
	;-------------------------------------- 選択されている行の割当て内容を変更する
	LV_Modify(SelectedRow, "col3", ddlAssignGesture)
	;-------------------------------------- 処理完了メッセージを表示する
	ShowSplashImage("「" . ddlAssignGesture . "」を割当てました")
	SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%	
	IsChangeConfig := 1
Return
;=========================================== 右クリックで対象ウィンドウを変更するアプリ・リストビューがクリックされたときの処理
OnClickRClickAPP_ListView:
	;-------------------------------------- リストビューがフォーカスを受け取ったときは、処理対象のリストビューを変更する
	If (A_GuiEvent == "F" || A_GuiEvent == "Normal") {
		Gui, MGConfig: ListView, lsvRClickAPP_ListView
	}
	;-------------------------------------- リストビューの選択状態が変化したときは、リストビューにフォーカスをあわせる（ここでフォーカスをあててないと次にリストビューの項目をクリックしたときに正しくイベントが受け取れないため）
	If (A_GuiEvent == "I") {		
		GuiControl, Focus, lsvRClickAPP_ListView
		Return
	}
	;------------------------------ 選択されている行の行番号を取得する
	SelectedRow := LV_GetNext(0)
	;------------------------------ 項目が埋まっている行がクリックされたときだけ処理する
	If (SelectedRow > 0) {
		;------------------------------ ボタンを押せるようにする
		GuiControl, Enable1, btnRClick_APP_Modify
		GuiControl, Enable1, btnRClick_APP_Delete
	}Else{
		;------------------------------ ボタンを押せないようにする
		GuiControl, Enable0, btnRClick_APP_Modify
		GuiControl, Enable0, btnRClick_APP_Delete
	}
Return
;=========================================== 右クリックで対象ウィンドウを変更するアプリ・追加ボタンがクリックされたときの処理
OnClickRClickAPP_Add:
	;-------------------------------------- 設定画面をスクリーンの外に移動する（見かけ上非表示にする）
	HideConfigWindow(ConfigMouseGestureGuiTitle, WinPosX, WinPosY)
	;-------------------------------------- AutoHotkey以外のウィンドウがアクティブになるまで待つ
	LimitSec := 60
	msg = %LimitSec%秒以内に対象ウインドウをクリックしてください。
	ShowSplashImage(msg)
	Res := WaitExptAutohotkeyWin(LimitSec)
	;-------------------------------------- 何らかのウィンドウがアクティブになったら実行ファイル名を取得してリストビューに追加する
	HideSplashImage()
	If (Res == 0) {
		;-------------------------------------- アクティブウィンドウのタイトルを取得する
		WinGetActiveTitle, WinTitle
		;-------------------------------------- アクティブウィンドウの実行ファイル名を取得する
		WinGet, RClickWinExe, ProcessName, %WinTitle%
		;-------------------------------------- 指定されたウィンドウタイトルのアプリがストアアプリか確認し、ストアアプリならアプリ名を返す（関数は機能設定モジュールで定義）
		RClickWinName := GetStoreAppTitle(WinTitle)
		;-------------------------------------- 処理対象のリストビューを変更する
		Gui, MGConfig: ListView,lsvRClickAPP_ListView
		;-------------------------------------- リストビューの行数を取得する
		lsvRClickAPP_RowCount := LV_GetCount() 
		IsExistApp := 0
		Loop %lsvRClickAPP_RowCount% {
			LV_GetText(rclick_app, A_Index, 1)
			LV_GetText(rclick_app_title, A_Index, 2)
			If (RClickWinExe . RClickWinName == rclick_app . rclick_app_title) {
				;-------------------------------------- 既に登録されている場合は追加しない
				IsExistApp := 1
			}
		}
		;-------------------------------------- アクティブウィンドウの実行ファイル名をリストビューに追加する
		WinActivate AHK_EXE AutoHotkey.exe
		If (IsExistApp == 0) {
			LV_Add("Select", RClickWinExe, RClickWinName)
			;-------------------------------------- 処理完了メッセージを表示する
			ShowSplashImage("「" . RClickWinExe . "」を追加しました")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
			IsChangeConfig := 1
		}Else{
			;-------------------------------------- 処理完了メッセージを表示する
			ShowSplashImage("「" . RClickWinExe . "」は既に登録されています")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
		}
	}Else{
		ShowSplashImage("対象ウインドウ情報が取得できませんでした")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	}
	;-------------------------------------- 設定画面を元の位置に戻す
	ShowConfigWindow(ConfigMouseGestureGuiTitle, WinPosX, WinPosY)
Return
;=========================================== 右クリックで対象ウィンドウを変更するアプリ・変更ボタンがクリックされたときの処理
OnClickRClickAPP_Modify:
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvRClickAPP_ListView
	;-------------------------------------- 選択されているアプリ名を取得する
	SelectedRow := LV_GetNext(0)
	LV_GetText(rclick_app_name, SelectedRow, 2)
	;-------------------------------------- 入力された内容でアプリ名を変更する
	InputBox, rclick_app_name, アプリ名の変更, アプリ名を入力してください。,,,150,,,,, %rclick_app_name%
	LV_Modify(SelectedRow, "Col2", rclick_app_name)
Return
;=========================================== 右クリックで対象ウィンドウを変更するアプリ・削除ボタンがクリックされたときの処理
OnClickRClickAPP_Delete:
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvRClickAPP_ListView
	;-------------------------------------- 選択されているアプリ名を取得する
	SelectedRow := LV_GetNext(0)
	LV_GetText(rclick_app_name, SelectedRow, 1)
	MsgBox ,4,　,「%rclick_app_name%」を削除しますか？
	IfMsgBox YES
	{
		LV_Delete(SelectedRow)
		;-------------------------------------- ボタンを制御する
		GuiControl, Enable0, btnRClick_APP_Modify
		GuiControl, Enable0, btnRClick_APP_Delete
		;-------------------------------------- 処理完了メッセージを表示する
		ShowSplashImage("「" . rclick_app_name . "」を削除しました")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%	
		IsChangeConfig := 1
	}		
Return
;=========================================== OKボタンがクリックされたときの処理
OnClickOK:
	Gui, MGConfig: Hide
	;-------------------------------------- フォームの内容を取得する
	Gui, MGConfig: Submit, NoHide
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvMG_ListView
	;-------------------------------------- リストビューの行数を取得する
	lsvMG_RowCount := LV_GetCount() 
	;-------------------------------------- 削除されたマウスジェスチャーをiniファイルから削除する
	Loop {
		;--------------- 登録されているマウスジェスチャー名を取得する
		IniRead,ini_mg_name,%IniFileName%,MOUSEGESTURE_NAME,MgName%A_Index%,-1
		If (ini_mg_name == -1) {
			Break
		}
		;--------------- iniファイルに登録されているマウスジェスチャーがリストビューに存在するか確認する
		lsvRowCtr := 1
		MG_Deleted := 1
		Loop %lsvMG_RowCount% {
			;--------------- リストビューのマウスジェスチャー名を取得してiniファイルの内容と比較する
			LV_GetText(mg_name, A_Index, 1)
			If (ini_mg_name == mg_name) {
				MG_Deleted := 0
				Break
			}
			lsvRowCtr += 1
		}
		;--------------- リストビューから削除されていたらiniファイルも削除する
		If (MG_Deleted == 1) {
			IniDelete,%IniFileName%,MOUSEGESTURE_%ini_mg_name%
		}
	}
	;-------------------------------------- iniファイルをいったん削除する
	IniDelete,%IniFileName%,MOUSEGESTURE_NAME
	IniDelete,%IniFileName%,MOUSEGESTURE_MODE
	IniDelete,%IniFileName%,MOUSEGESTURE_ENABLE
	;-------------------------------------- リストビューの内容をiniファイルに保存する
	lsvRowCtr := 1
	Loop %lsvMG_RowCount% {
		;--------------- マウスジェスチャー名をiniファイルに保存する
		lsvColCtr := 1
		LV_GetText(mg_name, A_Index, lsvColCtr)
		IniWrite,%mg_name%,%IniFileName%,MOUSEGESTURE_NAME,MgName%lsvRowCtr%
		Loop %MG_CelCount% {
			;--------------- 機能名をiniファイルに保存する
			lsvColCtr += 1
			LV_GetText(mg_str, lsvRowCtr, lsvColCtr)
			IniWrite,%mg_str%,%IniFileName%,MOUSEGESTURE_%mg_name%,MgStr%A_Index%
			;--------------- コマンドをiniファイルに保存する
			lsvColCtr += 1
			LV_GetText(mg_cmd, lsvRowCtr, lsvColCtr)
			IniWrite,%mg_cmd%,%IniFileName%,MOUSEGESTURE_%mg_name%,MgCmd%A_Index%
		}
		;--------------- ジェスチャーモードをiniファイルに保存する
		lsvColCtr += 1
		LV_GetText(mg_mode, lsvRowCtr, lsvColCtr)
		IniWrite,%mg_mode%,%IniFileName%,MOUSEGESTURE_MODE,MgMode%lsvRowCtr%
		;--------------- ジェスチャー使用可否をiniファイルに保存する
		lsvColCtr += 1
		LV_GetText(mg_enable, lsvRowCtr, lsvColCtr)
		IniWrite,%mg_enable%,%IniFileName%,MOUSEGESTURE_ENABLE,MgEnable%lsvRowCtr%
		;--------------- 行カウンターをガウントする
		lsvRowCtr += 1
	}
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvAPP_ListView
	;-------------------------------------- リストビューの行数を取得する
	lsvAPP_RowCount := LV_GetCount() 
	;-------------------------------------- 削除された割当て対象アプリをiniファイルから削除する
	Loop {
		;--------------- 登録されている対象アプリ名を取得する
		IniRead,ini_mg_app_name,%IniFileName%,MOUSEGESTURE_APP,MgAppName%A_Index%,-1
		If (ini_mg_app_name == -1) {
			Break
		}
		IniRead,ini_mg_app_title,%IniFileName%,MOUSEGESTURE_APP,MgAppTitle%A_Index%,-1
		;--------------- iniファイルに登録されているマウスジェスチャーがリストビューに存在するか確認する
		lsvRowCtr := 1
		MG_Deleted := 1
		Loop %lsvAPP_RowCount% {
			;--------------- リストビューのマウスジェスチャー名を取得してiniファイルの内容と比較する
			LV_GetText(mg_app_name, A_Index, 1)
			LV_GetText(mg_app_title, A_Index, 2)
			If (ini_mg_app_name . ini_mg_app_title == mg_app_name . mg_app_title) {
				MG_Deleted := 0
				Break
			}
			lsvRowCtr += 1
		}
		;--------------- リストビューから削除されていたらiniファイルも削除する
		If (MG_Deleted == 1) {
			IniDelete,%IniFileName%,MOUSEGESTURE_APP_%ini_mg_app_name%%ini_mg_app_title%
		}
	}
	;-------------------------------------- iniファイルをいったん削除する
	IniDelete,%IniFileName%,MOUSEGESTURE_APP
	;-------------------------------------- リストビューの内容をiniファイルに保存する
	Loop %lsvAPP_RowCount% {
		;--------------- 割当て対象アプリ名をiniファイルに保存する
		LV_GetText(app_name, A_Index, 1)
		IniWrite,%app_name%,%IniFileName%,MOUSEGESTURE_APP,MgAppName%A_Index%
		;--------------- 割当て対象アプリタイトルをiniファイルに保存する
		LV_GetText(app_title, A_Index, 2)
		IniWrite,%app_title%,%IniFileName%,MOUSEGESTURE_APP,MgAppTitle%A_Index%
		;--------------- 対象アプリに割り当てたジェスチャー名をiniファイルに保存する
		LV_GetText(ges_name, A_Index, 3)
		IniWrite,%ges_name%,%IniFileName%,MOUSEGESTURE_APP_%app_name%%app_title%,MgAssign
	}
	;-------------------------------------- iniファイルをいったん削除する
	IniDelete,%IniFileName%,MOUSEGESTURE_RCLICK_APP
	;-------------------------------------- 処理対象のリストビューを変更する
	Gui, MGConfig: ListView,lsvRClickAPP_ListView
	;-------------------------------------- リストビューの行数を取得する
	lsvRClickAPP_RowCount := LV_GetCount() 
	;-------------------------------------- リストビューの内容をiniファイルに保存する
	Loop %lsvRClickAPP_RowCount% {
		;--------------- 右クリックで対象ウィンドウを変更するアプリ名をiniファイルに保存する
		LV_GetText(rclick_app_name, A_Index, 1)
		IniWrite,%rclick_app_name%,%IniFileName%,MOUSEGESTURE_RCLICK_APP,MgRClickAppName%A_Index%
		;--------------- 右クリックで対象ウィンドウを変更するアプリタイトルをiniファイルに保存する
		LV_GetText(rclick_app_title, A_Index, 2)
		IniWrite,%rclick_app_title%,%IniFileName%,MOUSEGESTURE_RCLICK_APP,MgRClickAppTitle%A_Index%
	}
	;--------------- マウスジェスチャーの使用方法の設定情報をiniファイルに保存する
	IniWrite,%rdoMG_use_default%,%IniFileName%,MOUSEGESTURE_USE_DEFAULT,MgUseDefault
	;-------------------------------------- スクリプトをリロードして設定を反映させる
	Reload
Return
;=========================================== GUI画面を閉じたときの処理
MGConfigGuiClose:
	If (IsChangeConfig == 1) {
		MsgBox ,4,　,設定が変更されています。設定を保存しますか？
		IfMsgBox YES
		{
			Gosub OnClickOK
		}Else{
			ExistConfigMouseGesture := 0
			Gui, MGConfig: Destroy
		}
	}Else{
		ExistConfigMouseGesture := 0
		Gui, MGConfig: Destroy
	}
Return
