﻿環境設定:
	;-------------------------------------- 既に設定画面を開いているときは何もしない
	If (ExistConfigPanel == 1) {
		Return
	}Else{
		ExistConfigPanel := 1
	}
	;-------------------------------------- 画面を新規作成する
	ConfigPanalGuiTitle := "環境設定"
	Gui, New,, %ConfigPanalGuiTitle%
	Gui, Font, s11
	;=========================================== オートIME除外アプリ
	Gui, Add, GroupBox, x22 y109 w270 h270 , オートIME除外アプリ
	Gui, Add, ListView, x42 y139 w230 h140 NoSortHdr Grid -Multi AltSubmit Checked vExptWinExeLV gOnActionExptWinExe, 実行ファイル名|アプリ名
	Gui, Add, Button, x42 y289 w230 h30 gExptWinExeAdd, 追加（対象アプリをクリック）
	;Gui, Add, Button, x42 y329 w110 h30 , 変更
	Gui, Add, Button, x42 y329 w110 h30 Disabled1 vExptWinExeModifyBtn gExptWinExeModify, アプリ名を変更
	Gui, Add, Button, x162 y329 w110 h30 Disabled1 vExptWinExeDeleteBtn gExptWinExeDelete, 削除
	;-------------------------------------- オートIMEオン除外アプリ情報を取得しリストビューに追加する
	section = NOT_AUTO_IMEON_APP
	loop {
		IniRead,NotAutoIMEonAppExe_ini,%IniFileName%,%section%,NotAutoIMEonAppExe%A_Index%,-1
		If (NotAutoIMEonAppExe_ini == -1) {
			Break
		}
		IniRead,NotAutoIMEonAppName_ini,%IniFileName%,%section%,NotAutoIMEonAppName%A_Index%,-1
		If (NotAutoIMEonAppName_ini == -1) {
			NotAutoIMEonAppName_ini := ""
		}
		LV_Add("", NotAutoIMEonAppExe_ini, NotAutoIMEonAppName_ini)
	}
	;-------------------------------------- オートIMEオフアプリ情報を取得しリストビューに追加する
	section = AUTO_IMEOFF_APP
	loop {
		IniRead,AutoIMEoffAppExe_ini,%IniFileName%,%section%,AutoIMEoffAppExe%A_Index%,-1
		If (AutoIMEoffAppExe_ini == -1) {
			Break
		}
		IniRead,AutoIMEoffAppName_ini,%IniFileName%,%section%,AutoIMEoffAppName%A_Index%,-1
		If (AutoIMEoffAppName_ini == -1) {
			AutoIMEoffAppName_ini := ""
		}
		LV_Add("Check1", AutoIMEoffAppExe_ini, AutoIMEoffAppName_ini)
	}
	;=========================================== モード切替通知
	If (OnChangeModeToolTip == 1) {
		dsbl := 0
	}Else{
		dsbl := 1
	}
	Gui, Add, GroupBox, x312 y19 w270 h140 , 通知
	Gui, Add, CheckBox, x332 y39 w210 h30 Checked%OnChangeModeBeep% vOnChangeModeBeep, モード切替時などに音を鳴らす
	Gui, Add, CheckBox, x332 y69 w210 h30 Checked%OnChangeModeToolTip% vOnChangeModeToolTip gOnChangeModeToolTip, モード切替時などにツールチップを表示する
	Gui, Add, Text, x348 y109 w200 h30 , ツールチップの表示時間（ミリ秒）
	Gui, Add, Edit, x492 y129 w60 h20 Number Disabled%dsbl% vOnChangeModeToolTipDspTime, 
	Gui, Add, UpDown, x528 y129 w18 h20 Range500-1000, %OnChangeModeToolTipDspTime%
	;=========================================== タスク切替
	Gui, Add, GroupBox, x312 y169 w270 h60 , タスク切替
	Gui, Add, CheckBox, x332 y189 w230 h30 Checked%SplitTaskSwitcher% vSplitTaskSwitcher, ランチャーとスイッチャーを分割する
	;=========================================== 自動起動
	IniRead,StartUpChk,%IniFileName%,STARTUP,StartUp,0
	Gui, Add, CheckBox, x332 y242 w250 h30 Checked%StartUpChk% vStartUpChk, 自動起動（スタートアップに登録）する
	;IniRead,OnLogonRdo,%IniFileName%,STARTUP,OnLogon,0
	;IniRead,NotStartUpRdo,%IniFileName%,STARTUP,NotStartUp,0
	;Gui, Add, GroupBox, x312 y179 w270 h110 , 自動起動
	;Gui, Add, Radio, x332 y199 w220 h30 Checked%StartUpRdo% vStartUpRdo, 自動起動する
	;Gui, Add, Radio, x332 y239 w220 h30 Checked%OnLogonRdo% vOnLogonRdo, 管理者として自動起動する`n（管理者権限が必要）
	;Gui, Add, Radio, x332 y279 w220 h30 Checked%NotStartUpRdo% vNotStartUpRdo, 自動起動しない
	;=========================================== 機能選択
	IniRead,SelectFunc,%IniFileName%,FUNCTION,SelectFunc,1
	If (SelectFunc == 1) {
		ChkSelectFuncKM := 1
		ChkSelectFuncK := 0
		ChkSelectFuncM := 0
	}
	If (SelectFunc == 2) {
		ChkSelectFuncKM := 0
		ChkSelectFuncK := 1
		ChkSelectFuncM := 0
	}
	If (SelectFunc == 3) {
		ChkSelectFuncKM := 0
		ChkSelectFuncK := 0
		ChkSelectFuncM := 1
	}
	Gui, Add, GroupBox, x312 y289 w270 h90 , カスタマイズ機能選択
	Gui, Add, Radio, x332 y303 w170 h30 Checked%ChkSelectFuncKM% vSelectFuncKM, キーボードとマウス
	Gui, Add, Radio, x332 y325 w170 h30 Checked%ChkSelectFuncK% vSelectFuncK, キーボードのみ
	Gui, Add, Radio, x332 y347 w170 h30 Checked%ChkSelectFuncM% vSelectFuncM, マウスのみ
	Gui, Add, CheckBox, x42 y389 w300 h30 Checked%AlwaysIMEOnAtDialog% vAlwaysIMEOnAtDialog, ファイル保存ダイアログは常にIMEオン
	;=========================================== 確定ボタン
	Gui, Add, Button, x352 y389 w100 h30 gConfigOK, OK
	Gui, Add, Button, x462 y389 w100 h30 gConfigCancel, キャンセル
	;=========================================== 起動時オートIME（ラジオボタンがリストビューより上にあるとリストビューの項目洗濯時のアクションが正しく動作しないのでこの位置に定義する）
	If (DirTypJpnChrMode == 0) {
		DTJpnOn := 0
		DTJpnOff := 1
	}Else{
		DTJpnOn := 1
		DTJpnOff := 0
	}
	Gui, Add, GroupBox, x22 y19 w270 h80 , オートIME
	Gui, Add, Radio, x42 y39 w170 h30 Checked%DTJpnOn% vDTJpnOn, 起動時オートIMEオン
	Gui, Add, Radio, x42 y69 w170 h30 Checked%DTJpnOff% vDTJpnOff, 起動時オートIMEオフ
	;=========================================== 画面表示
	Gui, Show, h430 w608
Return
;=========================================== オートIME除外アプリの項目が選択されたときの処理
OnActionExptWinExe:
	;-------------------------------------- リストビューがフォーカスを受け取ったときは、処理対象のリストビューを変更する
	If (A_GuiEvent == "F" || A_GuiEvent == "Normal") {
		Gui, ListView, ExptWinExeLV
	}
	;-------------------------------------- リストビューの選択状態が変化したときは、リストビューにフォーカスをあわせる（ここでフォーカスをあててないと次にリストビューの項目をクリックしたときに正しくイベントが受け取れないため）
	If (A_GuiEvent == "I") {		
		GuiControl, Focus, ExptWinExeLV
		Return
	}
	;------------------------------ 選択されている行の行番号を取得する
	SelectedRow := LV_GetNext(0)
	;------------------------------ 項目が埋まっている行がクリックされたときだけ処理する
	If (A_GuiEvent == "Normal") {
		If (SelectedRow > 0) {
			;-------------------------------------- ボタンを押せるようにする
			GuiControl, Enable1, ExptWinExeModifyBtn
			GuiControl, Enable1, ExptWinExeDeleteBtn
		}Else{
			;-------------------------------------- ボタンを押せないようにする
			GuiControl, Enable0, ExptWinExeModifyBtn
			GuiControl, Enable0, ExptWinExeDeleteBtn
		}
	}
Return
;=========================================== オートIME除外アプリ追加ボタンを押したときの処理
ExptWinExeAdd:
	;InputBox NewExeName,対象外アプリの追加,対象外アプリの実行ファイル名を入力してください。,,,150
	;LV_Add("", NewExeName)
	;-------------------------------------- 設定画面をスクリーンの外に移動する（見かけ上非表示にする）
	HideConfigWindow(ConfigPanalGuiTitle, WinPosX, WinPosY)
	;-------------------------------------- AutoHotkey以外のウィンドウがアクティブになるまで待つ
	LimitSec := 60
	msg = %LimitSec%秒以内に対象アプリをクリックしてください。
	ShowSplashImage(msg)
	Res := WaitExptAutohotkeyWin(LimitSec)
	;-------------------------------------- 何らかのウィンドウがアクティブになったら実行ファイル名を取得してリストビューに追加する
	HideSplashImage()
	If (Res == 0) {
		;-------------------------------------- アクティブウィンドウのタイトルを取得する
		WinGetActiveTitle, WinTitle
		;-------------------------------------- アクティブウィンドウの実行ファイル名を取得する
		WinGet, ExptWinExe, ProcessName, %WinTitle%
		;-------------------------------------- 指定されたウィンドウタイトルのアプリがストアアプリか確認し、ストアアプリならアプリ名を返す（関数は機能設定モジュールで定義）
		ExptWinName := GetStoreAppTitle(WinTitle)
		;-------------------------------------- 処理対象のリストビューを変更する
		Gui,ListView,ExptWinExeLV
		;-------------------------------------- リストビューの行数を取得する
		RowCount := LV_GetCount() 
		IsExistExe := 0
		Loop %RowCount% {
			LV_GetText(expt_exe, A_Index, 1)
			LV_GetText(expt_name, A_Index, 2)
			If (ExptWinExe . ExptWinNAme == expt_exe . expt_name) {
				;-------------------------------------- 既に登録されている場合は追加しない
				IsExistExe := 1
			}
		}
		;-------------------------------------- アクティブウィンドウの実行ファイル名をリストビューに追加する
		WinActivate AHK_EXE AutoHotkey.exe
		If (IsExistExe == 0) {
			LV_Add("", ExptWinExe, ExptWinName)
			WinActivate AHK_EXE AutoHotkey.exe
			;-------------------------------------- 処理完了メッセージを表示する
			ShowSplashImage("「" . ExptWinExe . ExptWinName . "」を追加しました")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
		}Else{
			;-------------------------------------- 処理完了メッセージを表示する
			ShowSplashImage("「" . ExptWinExe . ExptWinName . "」は既に登録されています")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
		}
	}Else{
		ShowSplashImage("対象ウインドウ情報が取得できませんでした")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	}
	;-------------------------------------- 設定画面を元の位置に戻す
	ShowConfigWindow(ConfigPanalGuiTitle, WinPosX, WinPosY)
Return
;=========================================== 指定されたウィンドウタイトルのアプリがストアアプリか確認し、ストアアプリならアプリ名を返す
GetStoreAppTitle(WinTitle) {
	WinGet, WinExe, ProcessName, %WinTitle%
	If (WinExe == "ApplicationFrameHost.exe") {
		;-------------------------------------- アプリタイトルを取得する
		SplitTitle := StrSplit(WinTitle, "-")
		ix := SplitTitle.MaxIndex()
		WinName := LTrim(SplitTitle[ix], " ")
		;-------------------------------------- ストアアプリのときはアプリ名を編集するよう促す
		;InputBox, WinName, アプリ名の入力, このアプリはアプリ名の登録が必要です。`nアプリ名を入力してください。,,,150,,,,, %WinName%
	}Else{
		WinName := ""
	}
	Return, WinName
}
;=========================================== オートIME除外アプリ変更ボタンを押したときの処理
ExptWinExeModify:
	SelectedRow := LV_GetNext(0)
	LV_GetText(ExptWinName, SelectedRow, 2)
	InputBox, ExptWinName, アプリ名の変更, アプリ名を入力してください。,,,150,,,,, %ExptWinName%
	LV_Modify(SelectedRow, "Col2", ExptWinName)
Return
;=========================================== オートIME除外アプリ削除ボタンを押したときの処理
ExptWinExeDelete:
	SelectedRow := LV_GetNext(0)
	LV_GetText(ExptWinExe, SelectedRow, 1)
	LV_GetText(ExptWinName, SelectedRow, 2)
	SelectedText := ExptWinExe . ExptWinName
	MsgBox ,4,　,「%SelectedText%」を削除しますか？
	IfMsgBox YES
	{
		LV_Delete(SelectedRow)
		GuiControl, Enable0, ExptWinExeDeleteBtn
		;-------------------------------------- 処理完了メッセージを表示する
		ShowSplashImage("「" . SelectedText . "」を削除しました")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%		
	}
Return
;=========================================== モード切替時にツールチップを表示するチェックボタンをクリックしたときの処理
OnChangeModeToolTip:
	Gui, Submit ,NoHide
	GuiControl, Enable%OnChangeModeToolTip%, OnChangeModeToolTipDspTime
Return
;=========================================== OKボタンを押したときの処理
ConfigOK:
	Gui, Submit
	;-------------------------------------- 起動時オートIMEの設定を保存する
	IniWrite,%DTJpnOn%,%IniFileName%,IME,DirectTypeJpnChrMode
	;-------------------------------------- オートIMEオン除外アプリ設定を保存する
	;-------------------------------------- 元の設定をいったん削除する
	section = NOT_AUTO_IMEON_APP
	IniDelete,%IniFileName%,%section%
	section = AUTO_IMEOFF_APP
	IniDelete,%IniFileName%,%section%
	;-------------------------------------- 新しい設定を保存する
	count := LV_GetCount()
	ixAoff := 0
	ixNotA := 0
	loop %count%{
		;-------------------------------------- リストビューのチェックボックスの状態を取得する
		ix := A_Index - 1
		If (LV_GetNext(ix, "C") == A_Index) {
			;-------------------------------------- オートIMEオフアプリ
			section = AUTO_IMEOFF_APP
			ixAoff += 1
			LV_GetText(TargetText, A_Index, 1)
			IniWrite,%TargetText%,%IniFileName%,%section%,AutoIMEoffAppExe%ixAoff%
			LV_GetText(TargetText, A_Index, 2)
			IniWrite,%TargetText%,%IniFileName%,%section%,AutoIMEoffAppName%ixAoff%
		}Else{
			;-------------------------------------- オートIME除外
			section = NOT_AUTO_IMEON_APP
			ixNotA += 1
			LV_GetText(TargetText, A_Index, 1)
			IniWrite,%TargetText%,%IniFileName%,%section%,NotAutoIMEonAppExe%ixNotA%
			LV_GetText(TargetText, A_Index, 2)
			IniWrite,%TargetText%,%IniFileName%,%section%,NotAutoIMEonAppName%ixNotA%
		}
	}
	;-------------------------------------- モード切替通知設定を保存する
	IniWrite,%OnChangeModeBeep%,%IniFileName%,CHANGE_MODE_NOTIFY,OnChangeModeBeep
	IniWrite,%OnChangeModeToolTip%,%IniFileName%,CHANGE_MODE_NOTIFY,OnChangeModeToolTip
	IniWrite,%OnChangeModeToolTipDspTime%,%IniFileName%,CHANGE_MODE_NOTIFY,OnChangeModeToolTipDspTime
	;-------------------------------------- タスク切替設定を保存する
	IniWrite,%SplitTaskSwitcher%,%IniFileName%,TASK_SWITCH,SplitTaskSwitcher
	IniWrite,%ReloadTaskSwitcher%,%IniFileName%,TASK_SWITCH,ReloadTaskSwitcher
	;-------------------------------------- ファイル保存ダイアログは常にIMEオンを保存する
	IniWrite,%AlwaysIMEOnAtDialog%,%IniFileName%,ALWAYS_IME_ON_AT_DIALOG,AlwaysIMEOnAtDialog
	;-------------------------------------- 自動起動設定を保存する
	IniWrite,%StartUpChk%,%IniFileName%,STARTUP,StartUp
	;-------------------------------------- スタートアップに登録する
	;----------------------------------- スクリプト名の決定
	IfInString, A_ScriptName, .exe
	{
		KMScriptName = %A_ScriptDir%\KMCustomizer.exe
	}Else{
		KMScriptName = %A_ScriptDir%\KMCustomizer.ahk
	}
	ShortCutFileName = %A_Startup%\AutoImeOn.lnk
	If (StartUpChk == 1) {
		FileCreateShortcut, %KMScriptName%, %ShortCutFileName%, %A_ScriptDir%
	}Else{
		FileDelete, %ShortCutFileName%
	}
	;-------------------------------------- タスクスケジューラーにログオン時に起動する設定を登録する
	;If (OnLogonRdo == 1) {
	;	Run cmd /c schtasks /Create /tn "AUTO IME ON" /tr "%ScriptFileName%" /sc ONLOGON /rl highest,,Hide
	;}Else{
	;	Run cmd /c schtasks /Delete /tn "AUTO IME ON" /f,,Hide
	;}
	;-------------------------------------- 機能選択を保存する
	If (SelectFuncKM == 1) {
		SelectFunc := 1
	}
	If (SelectFuncK == 1) {
		SelectFunc := 2
	}
	If (SelectFuncM == 1) {
		SelectFunc := 3
	}
	IniWrite,%SelectFunc%,%IniFileName%,FUNCTION,SelectFunc
	;-------------------------------------- スクリプトをリロードして設定を反映させる
	;Reload
	;----------------------------------- スクリプトの起動
	Run, %KMScriptName%
	;----------------------------------- スクリプトを終了
	ExitApp
Return
;=========================================== キャンセルボタンを押したときの処理
ConfigCancel:
	ExistConfigPanel := 0
	Gui, Destroy
Return
;=========================================== 設定画面をスクリーンの外に移動する（見かけ上非表示にする）
HideConfigWindow(ConfigPanalGuiTitle, ByRef WinPosX, ByRef WinPosY) {
	;--------------- 設定画面のIDを取得する
	;WinGet, ConfigWindowID, ID, A
	;--------------- 設定画面の表示位置を取得する
	WinGetPos WinPosX, WinPosY, , , %ConfigPanalGuiTitle%
	;--------------- 仮想スクリーンの幅を取得する
	SysGet VScreenWidth, 78
	;--------------- 設定画面をスクリーンの外に移動する（見かけ上非表示にする）
	WinMove, %ConfigPanalGuiTitle%, , %VScreenWidth%, %WinPosY%
}
;=========================================== 設定画面を元の位置に戻す
ShowConfigWindow(ConfigPanalGuiTitle, WinPosX, WinPosY) {
	WinMove, %ConfigPanalGuiTitle%, , %WinPosX%, %WinPosY%
	WinActivate, %ConfigPanalGuiTitle%
}