﻿;=========================================== IME側の設定（覚書）
;Ctrl + F13 IME-オン
;Shift + F13 IME-オフ
;Ctrl + F14 英数キー 英数キー
;Shift + F14 ひらがな
;=========================================== IMEオン・オフ
SetIME(mode) {
	If (mode == 1) {
		If (DirTypJpnChrMode == 1) {
			If WinActive("ahk_group AutoIMEoffApp") {
				;--------------- オートIMEオフアプリのとき
				WinGetClass, ActiveWinClass, A
				If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
					;--------------- ファイルの保存ダイアログのときはIMEをオンにして、ひらがなモードにする
					IME_SET(1)
					IME_SetConvMode(9)
				}Else{
					;--------------- IMEをオフにする
					;Send +{F13}
					IME_SET(0)
				}
			}Else{
				;--------------- ダイレクト日本語モードONのとき
				;--------------- IMEをオンにして、ひらがなモードにする
				;Send ^{F13}+{F14}
				IME_SET(1)
				IME_SetConvMode(9)
			}
		}Else{
			;--------------- ダイレクト日本語モードOFFのとき
			;--------------- IMEをオフにする
			;Send +{F13}
			IME_SET(0)
		}
		Return
	}
	If (mode == 2) {
		;--------------- IMEをオンにして、英数モードにする
		;Send ^{F13}^{F14}
		IME_SET(1)
		IME_SetConvMode(0)
		Return
	}
	If (mode == 3) {
		;--------------- IMEをオンにする
		;Send ^{F13}
		IME_SET(1)
		Return
	}
	If (mode == 4) {
		;--------------- IMEをオフにする
		;Send +{F13}
		IME_SET(0)
		Return
	}
}
Return
;=========================================== IMEオン
SubIMEOn:
	SetIME(3)
Return
;=========================================== IMEオフ
SubIMEOff:
	SetIME(4)
Return
;=========================================== ダイレクト日本語入力モードの変更
SubChangeDirTypJpnChrMode:
	If (DirTypJpnChrMode == 1) {
		DirTypJpnChrMode = 0
		IMEicon = off.ico
		If (OnChangeModeBeep == 1) {
			SoundBeep,700,100
		}
		If (OnChangeModeToolTip == 1) {
			ShowSplashImage("オートIMEオフ")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
		}
	}Else{
		DirTypJpnChrMode = 1
		IMEicon = on.ico
		If (OnChangeModeBeep == 1) {
			SoundBeep 800,70
		}
		If (OnChangeModeToolTip == 1) {
			ShowSplashImage("オートIMEオン")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
		}
	}
	;--------------- アイコンロード
	Menu TRAY,Icon,%A_ScriptDir%\icon\%IMEicon%
Return
;=========================================== IMEの状態を取得する
; もらかなです。に公開されたスクリプトを使用
; http://d.hatena.ne.jp/morakana/20080213/1202876561
;
IME_IsON(hWindow)
{
	; WM_IME_CONTROL    = 0x0283
	; IMC_GETOPENSTATUS = 0x0005
	bufCurrentDetectMode := A_DetectHiddenWindows
	DetectHiddenWindows, On
	buf := DllCall("user32.dll\SendMessageA", "UInt", DllCall("imm32.dll\ImmGetDefaultIMEWnd", "Uint",hWindow), "UInt", 0x0283, "Int", 0x0005, "Int", 0)
	DetectHiddenWindows, %bufCurrentDetectMode%
	Return buf
}
Return
;=========================================== IMEをオン・オフする
AutoIMEOnOff:
	If WinActive("ahk_group NotAutoIMEonApp") {
		;--------------- オートIMEオン対象外アプリ時はIMEをオン・オフしない
	}Else{
		;--------------- ダイレクト日本語入力モードに応じてIMEをオン・オフする
		SetIME(1)
	}
Return
;=========================================== IMEの状態をセット
; Autohotkey IME制御用 関数群 (コピペ/組込用)(IME.ahk)を使用
;-----------------------------------------------------------
; IMEの状態をセット
;   SetSts          1:ON / 0:OFF
;   WinTitle="A"    対象Window
;   戻り値          0:成功 / 0以外:失敗
;-----------------------------------------------------------
IME_SET(SetSts, WinTitle="A")    {
	ControlGet,hwnd,HWND,,,%WinTitle%
	if	(WinActive(WinTitle))	{
		ptrSize := !A_PtrSize ? 4 : A_PtrSize
	    VarSetCapacity(stGTI, cbSize:=4+4+(PtrSize*6)+16, 0)
	    NumPut(cbSize, stGTI,  0, "UInt")   ;	DWORD   cbSize;
		hwnd := DllCall("GetGUIThreadInfo", Uint,0, Uint,&stGTI)
	             ? NumGet(stGTI,8+PtrSize,"UInt") : hwnd
	}

    return DllCall("SendMessage"
          , UInt, DllCall("imm32\ImmGetDefaultIMEWnd", Uint,hwnd)
          , UInt, 0x0283  ;Message : WM_IME_CONTROL
          ,  Int, 0x006   ;wParam  : IMC_SETOPENSTATUS
          ,  Int, SetSts) ;lParam  : 0 or 1
}
;=========================================== IME 入力モードセット
; Autohotkey IME制御用 関数群 (コピペ/組込用)(IME.ahk)を使用
;-------------------------------------------------------
; IME 入力モードセット
;   ConvMode        入力モード
;   WinTitle="A"    対象Window
;   戻り値          0:成功 / 0以外:失敗
;--------------------------------------------------------
IME_SetConvMode(ConvMode,WinTitle="A")   {
	ControlGet,hwnd,HWND,,,%WinTitle%
	if	(WinActive(WinTitle))	{
		ptrSize := !A_PtrSize ? 4 : A_PtrSize
	    VarSetCapacity(stGTI, cbSize:=4+4+(PtrSize*6)+16, 0)
	    NumPut(cbSize, stGTI,  0, "UInt")   ;	DWORD   cbSize;
		hwnd := DllCall("GetGUIThreadInfo", Uint,0, Uint,&stGTI)
	             ? NumGet(stGTI,8+PtrSize,"UInt") : hwnd
	}
    return DllCall("SendMessage"
          , UInt, DllCall("imm32\ImmGetDefaultIMEWnd", Uint,hwnd)
          , UInt, 0x0283      ;Message : WM_IME_CONTROL
          ,  Int, 0x002       ;wParam  : IMC_SETCONVERSIONMODE
          ,  Int, ConvMode)   ;lParam  : CONVERSIONMODE
}