﻿;=========================================== マウスをくるくる回すとスクロール
; 2chのAutoHotkeyスレッド公開のスクリプトを使用
; 入手元
; http://lukewarm.s101.xrea.com/up/file/108.zip
;
#InstallMouseHook
;KuruHigh=3		;高速時のスクロールスピード(1-3)
;KuruLow=1		;低速時のスクロールスピード(1-3)
;KuruSen=2		;感度(1-3)
;Kurutimeout=50	;タイムアウトまでの時間

SetTimer Rotation,10
Rotation:
	If (A_TimeIdlePhysical > Kurutimeout) {
		str:=999999999
	}
	lx:=nx , ly:=ny
	CoordMode,Mouse,Screen
	MouseGetPos nx,ny,nwin_id
	If (nx > lx && ny > ly)
		pos=1
	If (nx > lx && ny < ly)
		pos=2
	If (nx < lx && ny < ly)
		pos=3
	If (nx < lx && ny > ly)
		pos=4
	If (pos <> lastpos) {
		str:=str pos , lastpos:=pos
		StringRight str,str,10-2*KuruSen
	}
	dis:=((lx - nx)**2 + (ly - ny)**2)**0.5
	buf+=dis
	If (Kurutimeout > 0) {
		If (buf > 100 / KuruLow) {
			freq:=dis * KuruHigh / 50 + 1 , buf=0
			If RegExMatch("1234123412341234",str) {
				;--------------- マウスホイール回転でウィンドウをアクティブにする
				If (ActvOnWheel == 1) {
					ActivateUnderMouseWindow()
				}
				MouseClick WheelUp,,,%freq%
			}
			If RegExMatch("4321432143214321",str) {
				;--------------- マウスホイール回転でウィンドウをアクティブにする
				If (ActvOnWheel == 1) {
					ActivateUnderMouseWindow()
				}
				MouseClick WheelDown,,,%freq%
			}
		}
	}
	;--------------- XButton1,XButton2,無変換キー,変換キーを押しながらマウスを上下に動かすとスクロールさせる
	If (EnableTrackBallScroll == 1) {
		If ((TrackBallScrollAcc == "X1ボタン" && GetKeyState("XButton1","p")) || (TrackBallScrollAcc == "X2ボタン" && GetKeyState("XButton2","p")) || (TrackBallScrollAcc == "無変換キー" && GetKeyState("sc07B","p")) || (TrackBallScrollAcc == "変換キー" && GetKeyState("sc079","p")) || (TrackBallScrollAcc == "左Windowsキー" && GetKeyState("LWin","p")) || (TrackBallScrollAcc == "右Windowsキー" && GetKeyState("RWin","p")) || (TrackBallScrollAcc == "アプリケーションキー" && GetKeyState("AppsKey","p"))) {
			;--------------- スクロール開始時点のマウスカーソル位置を保存する
			If (mscrOn == 0) {
				lly := ly
				llx := lx
			}
			mscrCtr += 1
			mscrLimit := TrackBallScrollSen + 2
			If (mscrCtr == mscrLimit) {
				If (ny > ly) {
					;--------------- マウスホイール回転でウィンドウをアクティブにする
					If (ActvOnWheel == 1) {
						ActivateUnderMouseWindow()
					}
					;--------------- スクロール
					count := ny - ly
					;--------------- スクロールを反転するとき
					IF (MouseWheelReverse == 1) {
						wheeltype := "WheelUp"
					}Else{
						wheeltype := "WheelDown"
					}
					MouseClick %wheeltype%,,,%count%
					;--------------- 起動キーの単独押下を無効にする
					If (TrackBallScrollAcc == "X1ボタン") {
						NoXbutton1 := 1
					}
					If (TrackBallScrollAcc == "X2ボタン") {
						NoXbutton2 := 1
					}
					If (TrackBallScrollAcc == "左Windowsキー") {
						NoLWin := 1
					}
					If (TrackBallScrollAcc == "右Windowsキー") {
						NoRWin := 1
					}
					If (TrackBallScrollAcc == "無変換キー" || TrackBallScrollAcc == "変換キー" || TrackBallScrollAcc == "アプリケーションキー") {
						NoKeyDown := 1
					}
					;--------------- マウスカーソルをスクロール開始時点の位置に戻す
					MouseMove llx,lly
					mscrOn := 1
				}
				If (ny < ly) {
					;--------------- マウスホイール回転でウィンドウをアクティブにする
					If (ActvOnWheel == 1) {
						ActivateUnderMouseWindow()
					}
					;--------------- スクロール
					count := ly - ny
					;--------------- スクロールを反転するとき
					IF (MouseWheelReverse == 1) {
						wheeltype := "WheelDown"
					}Else{
						wheeltype := "WheelUp"
					}
					MouseClick %wheeltype%,,,%count%
					;--------------- 起動キーの単独押下を無効にする
					If (TrackBallScrollAcc == "X1ボタン") {
						NoXbutton1 := 1
					}
					If (TrackBallScrollAcc == "X2ボタン") {
						NoXbutton2 := 1
					}
					If (TrackBallScrollAcc == "左Windowsキー") {
						NoLWin := 1
					}
					If (TrackBallScrollAcc == "右Windowsキー") {
						NoRWin := 1
					}
					If (TrackBallScrollAcc == "無変換キー" || TrackBallScrollAcc == "変換キー" || TrackBallScrollAcc == "アプリケーションキー") {
						NoKeyDown := 1
					}
					;--------------- マウスカーソルをスクロール開始時点の位置に戻す
					MouseMove llx,lly
					mscrOn := 1
				}
				mscrCtr := 0
			}
		}Else{
			mscrOn := 0
		}
	}
	If (MG_mode == 1) {
		;--------------- グリッドモードのときは、マウスジェスチャー・グリッドを表示する
		Gosub ShowMsGrid
	}Else{
		;--------------- ジェスチャーモードのときは、マウスジェスチャー・軌道画像を表示する
		Gosub ShowMsTrace
		;--------------- ジェスチャーを実行したら軌道画像を隠す
		If (MG_Done == 1) {
			Gui,MG_Trace: Hide
			Gui,MG_TrCmd: Hide
			MG_Done := 0
		}
	}
	;------------------------------ ウィンドウ下端でホイールを回転させたときだけタスクバーを表示する設定がオンの時
	If (ShowTaskbarWhenMouseWheel == 1 && ShowTaskBarForce == 0) {
		;--------------- マウスカーソルがタスクバー領域に位置しているか調べる
		Res := IsTaskbarControlUnderMouse(win_id,WinCtrlClass)
		If (Res == 0) {
			;--------------- マウスカーソルがタスクバー領域外に出たか、タスクバーを強制的に表示する操作がないときはタスクバーを隠す
			HideTaskBar()
		}
	}
Return
;=========================================== マウスジェスチャー・グリッドを表示する
ShowMsGrid:
	;If (end_mouse_ges == 1) {
	;	Gui,MG_Grid: Hide
	;	MG_No := 0
	;}
	MG_No_Bf := MG_No
	If (enable_mouse_ges == 1) {
		;------------------------------ マウスカーソルが存在するモニターの番号、マウスの座標位置、モニターの数を取得する
		WhereIsCursorOnMonitor(MonNo, MousePosX, MousePosY, MonCount)
		;------------------------------ モニターサイズ、境界座標を取得する
		GetMonitorSize(MonNo, MonWidth, MonHeight, MonLeft, MonRight, MonTop, MonBottom)
		;--------------- マウスジェスチャー・グリッドを表示するX座標とグリッドの中心X座標を求める
		MG_GridCenterX := mpX_dwn
		ShowPosX := mpX_dwn - MG_GridImgSize // 2
		If (ShowPosX < MonLeft) {
			;--------------- モニターの左端からはみ出るときは右側に寄せる
			NewShowPosX := MonLeft
			MG_GridCenterX := mpX_dwn + (NewShowPosX - ShowPosX)
			ShowPosX := MonLeft
		}
		If (MonRight < ShowPosX + MG_GridImgSize) {
			;--------------- モニターの右端からはみ出るときは左側に寄せる
			NewShowPosX := MonRight - MG_GridImgSize
			MG_GridCenterX := mpX_dwn - (ShowPosX - NewShowPosX)
			ShowPosX := NewShowPosX
		}
		;--------------- マウスジェスチャー・グリッドを表示するY座標とグリッドの中心Y座標を求める
		ShowPosY := mpY_dwn - MG_GridImgSize // 2
		MG_GridCenterY := mpY_dwn
		If (ShowPosY < MonTop) {
			;--------------- モニターの上端からはみ出るときは下側に寄せる
			NewShowPosY := MonTop
			MG_GridCenterY := mpY_dwn + (NewShowPosY - ShowPosY)
			ShowPosY := NewShowPosY
		}
		If (MonBottom < ShowPosY + MG_GridImgSize) {
			;--------------- モニターの下端からはみ出るときは上側に寄せる
			NewShowPosY := MonBottom - MG_GridImgSize
			MG_GridCenterY := mpY_dwn - (ShowPosY - NewShowPosY)
			ShowPosY := NewShowPosY
		}
		;--------------- マウスジェスチャー・グリッドの選択位置を求める
		MG_x := nx - MG_GridCenterX + MG_CelOffset
		MG_y := ny - MG_GridCenterY + MG_CelOffset
		If (MG_x < 0 || MG_x > MG_GridImgSize || MG_y < 0 || MG_y > MG_GridImgSize) {
			;--------------- マウスがグリッドの外に出たとき
			MG_No := 0
		}Else{
			MG_xCelNo := MG_x // MG_CelSize
			MG_yCelNo := MG_y // MG_CelSize
			MG_No := MG_xCelNo + 1 + MG_yCelNo * 5
		}
		;--------------- 通常の右クリックのときはマウスジェスチャー・グリッドを表示しないようにする
		If (MG_No_Bf == 0) {
			;--------------- マウスジェスチャー・グリッドが非表示のときは、マウスの移動距離を求める
			MouseMoveDistX := Abs(nx - mpX_dwn)
			MouseMoveDistY := Abs(ny - mpY_dwn)
			;--------------- マウス移動距離がセル1個分の幅未満のときは、通常の右クリックとみなす
			IF (MouseMoveDistX < MG_CelHafgSize && MouseMoveDistY < MG_CelHafgSize) {
				MG_No := 0
			}
		}
		;--------------- マウスジェスチャー・グリッドの何処を選択したか判定する
		If (26 > MG_No && MG_No > 0) {
			;--------------- マウスジェスチャー・グリッド内を選択した時の処理
			MG_Disp := 1
			;--------------- 選択したグリッド位置の座標を求める
			MG_Selected_Grid_x := MG_xCelNo * MG_CelSize
			MG_Selected_Grid_y := MG_yCelNo * MG_CelSize
			;--------------- マウスジェスチャーが起動中か確認してマウスジェスチャーが起動されたアプリに応じたグリッドを構築する
			If (MG_No_Bf == 0) {
				;---------------  マウスジェスチャーが起動されたアプリの情報を取得する
				;Gosub GetMGappInfo
				;右クリックの時点で取得済みなので不要
				;--------------- マウスジェスチャー・グリッドを編集する
				Loop %MG_CelCount% {
					strWrk := MG_String[MG_Name,A_Index]
					GuiControl, MG_Grid: Text, MG_CellName%A_Index%, %strWrk%				
				}
				;--------------- マウスジェスチャー・グリッドを表示する
				Gui, MG_Grid: Show, W%MG_GridImgSize% H%MG_GridImgSize% X%ShowPosX% Y%ShowPosY%, %MG_GridWinName%
			}Else{
				;--------------- すでにマウスジェスチャーが起動している（グリッドが表示されている）ときは選択されているセルのみ更新する
				If (MG_No == MG_No_Bf) {
					;--------------- 別のグリッドを選択した時は選択グリッド画像を移動する
					GuiControl, MG_Grid: Move, MG_SelectedCel, X%MG_Selected_Grid_x% Y%MG_Selected_Grid_y%
					;--------------- 画像を移動するとテキストの内容も変化するのでテキストを上からかぶせる
					strWrk := MG_String[MG_Name,MG_No]
					GuiControl, MG_Grid: Text, MG_CellName%MG_No%, %strWrk%	
				}
			}
			;--------------- マウスジェスチャーの起動元画面をアクティブにする
			WinActivate ahk_id %mpWinId_dwn%
		}Else{
			;--------------- マウスジェスチャー・グリッド外を選択した時の処理
			Gui,MG_Grid: Hide
		}
	}
Return
;=========================================== マウスジェスチャー軌道画像を表示する
ShowMsTrace:
	If (enable_mouse_ges == 1) {
		;--------------- マウスジェスチャー1ストローク目の処理
		If (MG_ActCnt == 0) {
			;--------------- マウスの移動距離を求める
			MouseMoveDistX := Abs(nx - mpX_dwn)
			MouseMoveDistY := Abs(ny - mpY_dwn)
			;--------------- マウスの移動方向を判定する
			If (MouseMoveDistX > MG_CelHafgSize && MouseMoveDistY <= MG_CelHafgSize) {
				;--------------- マウスを横に動かしたとき
				If (nx > mpX_dwn) {
					;--------------- マウスを右に動かしたとき
					MG_No := 14
				}Else{
					;--------------- マウスを左に動かしたとき
					MG_No := 12
				}
				MG_ActCnt := 1
			}
			IF (MouseMoveDistX <= MG_CelHafgSize && MouseMoveDistY > MG_CelHafgSize) {
				;--------------- マウスを縦に動かしたとき
				If (ny > mpy_dwn) {
					;--------------- マウスを下に動かしたとき
					MG_No := 18
				}Else{
					;--------------- マウスを上に動かしたとき
					MG_No := 8
				}
				MG_ActCnt := 1
			}
			IF (MouseMoveDistX > MG_CelHafgSize / 2 && MouseMoveDistY > MG_CelHafgSize / 2) {
				;--------------- マウスを斜めに動かしたとき
				If (ny > mpy_dwn) {
					;--------------- マウスを下に動かしたとき
					If (nx > mpX_dwn) {
						;--------------- マウスを右下に動かしたとき
						MG_No := 19
					}Else{
						;--------------- マウスを左下に動かしたとき
						MG_No := 17
					}
				}Else{
					;--------------- マウスを上に動かしたとき
					If (nx > mpX_dwn) {
						;--------------- マウスを右上に動かしたとき
						MG_No := 9
					}Else{
						;--------------- マウスを左上に動かしたとき
						MG_No := 7
					}
				}
				MG_ActCnt := 1
			}
			IF (MG_ActCnt = 1) {
				Gosub ShowMGtrace
			}
		}
		;--------------- マウスジェスチャー2ストローク目の処理
		If (MG_ActCnt == 1) {
			;--------------- マウスの移動距離を求める
			MouseMoveDistX := Abs(nx - lx)
			MouseMoveDistY := Abs(ny - ly)
			;--------------- マウスの移動方向を判定する
			If (MouseMoveDistX > MG_CelHafgSize / 2 && MouseMoveDistY <= MG_CelHafgSize / 2) {
				;--------------- マウスを横に動かしたとき
				If (nx > lx) {
					;--------------- マウスを右に動かしたとき
					If (MG_No == 8) {
						;--------------- マウスを上右に動かしたとき
						MG_No := 4
						MG_ActCnt := 2
					}
					If (MG_No == 18) {
						;--------------- マウスを下右に動かしたとき
						MG_No := 24
						MG_ActCnt := 2
					}
					If (MG_No == 12) {
						;--------------- マウスを左右に動かしたとき
						MG_No := 11
						MG_ActCnt := 2
					}
				}Else{
					;--------------- マウスを左に動かしたとき
					If (MG_No == 8) {
						;--------------- マウスを上左に動かしたとき
						MG_No := 2
						MG_ActCnt := 2
					}
					If (MG_No == 18) {
						;--------------- マウスを下左に動かしたとき
						MG_No := 22
						MG_ActCnt := 2
					}
					If (MG_No == 14) {
						;--------------- マウスを右左に動かしたとき
						MG_No := 15
						MG_ActCnt := 2
					}
				}
			}
			IF (MouseMoveDistX <= MG_CelHafgSize / 2 && MouseMoveDistY > MG_CelHafgSize / 2) {
				;--------------- マウスを縦に動かしたとき
				If (ny > ly) {
					;--------------- マウスを下に動かしたとき
					If (MG_No == 8) {
						;--------------- マウスを上下に動かしたとき
						MG_No := 3
						MG_ActCnt := 2
					}
					If (MG_No == 12) {
						;--------------- マウスを左下に動かしたとき
						MG_No := 16
						MG_ActCnt := 2
					}
					If (MG_No == 14) {
						;--------------- マウスを右下に動かしたとき
						MG_No := 20
						MG_ActCnt := 2
					}
				}Else{
					;--------------- マウスを上に動かしたとき
					If (MG_No == 12) {
						;--------------- マウスを左上に動かしたとき
						MG_No := 6
						MG_ActCnt := 2
					}
					If (MG_No == 14) {
						;--------------- マウスを右上に動かしたとき
						MG_No := 10
						MG_ActCnt := 2
					}
					If (MG_No == 18) {
						;--------------- マウスを下上に動かしたとき
						MG_No := 23
						MG_ActCnt := 2
					}
				}
			}
			IF (MouseMoveDistX > MG_CelHafgSize / 4 && MouseMoveDistY > MG_CelHafgSize / 4) {
				;--------------- マウスを斜めに動かしたとき
				If (ny > ly) {
					;--------------- マウスを下に動かしたとき
					If (nx > lx) {
						;--------------- マウスを右下に動かしたとき
						If (MG_No == 7) {
							;--------------- マウスを左上・右下に動かしたとき
							MG_No := 1
							MG_ActCnt := 2
						}
						;--------------- マウスを右下に動かしたとき
						If (MG_No == 12) {
							;--------------- マウスを左・右下に動かしたとき
							MG_No := 13
							MG_ActCnt := 2
						}
					}Else{
						;--------------- マウスを左下に動かしたとき
						If (MG_No == 9) {
							;--------------- マウスを右上・左下に動かしたとき
							MG_No := 5
							MG_ActCnt := 2
						}
					}
				}Else{
					;--------------- マウスを上に動かしたとき
					If (nx > lx) {
						;--------------- マウスを右上に動かしたとき
						If (MG_No == 17) {
							;--------------- マウスを左下・右上に動かしたとき
							MG_No := 21
							MG_ActCnt := 2
						}
					}Else{
						;--------------- マウスを左上に動かしたとき
						If (MG_No == 19) {
							;--------------- マウスを右下・左上に動かしたとき
							MG_No := 25
							MG_ActCnt := 2
						}
					}
				}
			}
			;--------------- マウスジェスチャー軌道画像を表示する
			IF (MG_ActCnt = 2) {
				Gosub UpdateMGtrace
			}
		}
		;--------------- マウスジェスチャー軌道画像を表示する
		IF (MG_ActCnt = 1) {
			Gosub UpdateMGtrace
		}
		If (MG_ActCnt > 0) {
			;--------------- マウスの移動距離を求める
			MouseMoveDistX := Abs(nx - mpX_dwn)
			MouseMoveDistY := Abs(ny - mpY_dwn)
			;--------------- マウスの移動方向を判定する
			;If (MouseMoveDistX <= MG_CelHafgSize / 4 && MouseMoveDistY <= MG_CelHafgSize / 4) {
			If (MouseMoveDistX <= MG_CelHafgSize / 2 && MouseMoveDistY <= MG_CelHafgSize / 2) {
				;-------------- マウスが元の位置に戻ってきた時はジェスチャーのやり直し
				MG_ActCnt := 0
				MG_No := 0
				Gosub UpdateMGtrace
				;Gui,MG_TrCmd: Hide
			}Else{
				;---------------  マウスジェスチャーが起動されたアプリの情報を取得する
				;Gosub GetMGappInfo
				;右クリックの時点で取得済みなので不要
			}
		}
	}
Return
;=========================================== マウスジェスチャー軌道画像を表示する
ShowMGtrace:
	posX := mpX_dwn - MG_TraceImgSize / 2
	posY := mpY_dwn - MG_TraceImgSize / 2
	GuiControl, MG_Trace:, MG_TraceImage, %MG_TraceImageName%%MG_No%.png
	Gui, MG_Trace: Show, W%MG_TraceImgSize% H%MG_TraceImgSize% X%posX% Y%posY%, %MG_TraceWinName%
	;--------------- マウスジェスチャー機能名を表示する
	posX := mpX_dwn - MG_TraceCmdWidth / 2
	posY += MG_TraceImgSize
	strWrk := MG_String[MG_Name,MG_No]
	GuiControl, MG_TrCmd: Text, MG_TrCmd, %strWrk%	
	Gui, MG_TrCmd: Show, X%posX% Y%posY%
	MG_Disp := 2
Return
;=========================================== マウスジェスチャー軌道画像を更新する
UpdateMGtrace:
	GuiControl, MG_Trace:, MG_TraceImage, %MG_TraceImageName%%MG_No%.png
	If (MG_No == 0) {
		strWrk := "ジェスチャーリセット"
	}Else{
		strWrk := MG_String[MG_Name,MG_No]
	}
	GuiControl, MG_TrCmd: Text, MG_TrCmd, %strWrk%	
Return
;=========================================== マウスジェスチャーが起動されたアプリの情報を取得する
GetMGappInfo:
	;--------------- マウスジェスチャーが起動されたアプリの実行ファイル名を取得する
	WinGet, MG_WinExe, ProcessName, ahk_id %nwin_id%
	;--------------- マウスジェスチャーが起動されたアプリ用のジェスチャーが存在するか確認する
	If (StrLen(MG_AppNeedTitle[MG_WinExe]) > 0) {
		;--------------- アプリタイトルも指定されているか確認する
		If (MG_AppNeedTitle[MG_WinExe] == 1) {
			;-------------------- アプリタイトルが指定されている場合は実行ファイル名+アプリタイトルでマウスジェスチャー設定を取得する
			;--------------- アクティブウィンドウのタイトルを取得する
			WinGetTitle, MG_WinTitle, ahk_id %nwin_id%
			;--------------- アプリタイトルを取得する
			SplitTitle := StrSplit(MG_WinTitle, "-")
			ix := SplitTitle.MaxIndex()
			MG_AppTitle := LTrim(SplitTitle[ix], " ")
			;--------------- 割当ジェスチャー名を取得する
			ix = %MG_WinExe%%MG_AppTitle%
			MG_Name := MG_AppName[ix]
		}Else{
			;--------------- アプリタイトルが指定されてない場合は実行ファイル名でマウスジェスチャー設定を取得する
			MG_Name := MG_AppName[MG_WinExe]
		}
		;--------------- 該当のマウスジェスチャーが使用不可に設定されていた場合はデフォルト設定を使用する
		If (MG_EnableTbl[mg_name] == "0")  {
			MG_Name := "標準"
		}
	}Else{
		;--------------- マウスジェスチャーが起動されたアプリ用のジェスチャーが存在しない場合はデフォルト設定を使用する
		MG_Name := "標準"
	}
Return
;=========================================== マウスジェスチャーを有効にする
EnableMouseGesture:
	;--------------- マウスジェスチャー実行可能状態をオンにする
	enable_mouse_ges := 1
	MouseGetPos,mpX_dwn,mpY_dwn,mpWinId_dwn,mpWinCtrlId_dwn,3
	MG_No := 0
	MG_Disp := 0
Return
;=========================================== マウスジェスチャーを実行する
ExecMouseGesture:
	;--------------- マウスジェスチャー軌道画像を隠して少し待つ（非表示になってからジェスチャーを実行するため）
	Gui,MG_Trace: Hide
	Gui,MG_TrCmd: Hide
	Sleep 200
	;--------------- マウスジェスチャー実行可能状態をオフにする
	enable_mouse_ges := 0
	;--------------- マウスジェスチャー番号退避変数をクリアする
	MG_No_Bf := 0
	;--------------- マウスジェスチャー・グリッド表示した後にマウスを外に出したときは何もしない
	If ((MG_No < 0 || MG_No > 25 || MG_No == 0) && MG_Disp == 1) {
		Return
	}
	;--------------- マウスジェスチャー・グリッド内で右ボタンを離したときは登録されたコマンドを実行する
	If (MG_No > 0) {
		;--------------- マウスジェスチャーの起動元画面をアクティブにする
		WinActivate ahk_id %mpWinId_dwn%
		;--------------- マウスジェスチャー・グリッドを隠す
		Gui,MG_Grid: Hide
		;--------------- マウスカーソルをマウスジェスチャー起動時の位置に戻す
		MouseMove,mpX_dwn,mpY_dwn
		;--------------- エクスプローラーのように分割ペインウィンドウのとき非アクティブペイン上でジェスチャーしてもアクティブペイン上でしか動作しないので、右クリックを送ってアクティブ化する
		If WinActive("ahk_group MG_RClickApp") {
			If (SwapMouseButtons == 0) {
				Send {RButton}
			}Else{
				;--------------- マウスボタンを反転しているときは左クリックを送る
				Send {LButton}
			}
			Sleep 100
			Send {Esc}
		}
		;--------------- SendModeを一時的に変更する
		SendMode, Event
		;--------------- ジェスチャーに登録されたコマンドを実行する
		key := MG_Command[MG_Name,MG_No]
		Gosub SendKeyOrSearch
		;--------------- SendModeを元に戻す
		SendMode, Input
		;--------------- ジェスチャーを実行したことを示すフラグを立てる
		MG_Done := 1
		;--------------- ジェスチャーカウンターをゼロリセットする
		MG_ActCnt := 0
	}
Return
;=========================================== マウスジェスチャーを起動する
SubMouseGesture:
	If (enable_mouse_ges == 0) {
		Gosub EnableMouseGesture
	}Else{
		Gosub ExecMouseGesture
	}
Return
;=========================================== マウス操作関連関数
;------------------------------------------------ マウス操作モードの切り替え
ChangeMouseMode() {
	global MouseMode
	If (MouseMode == 1) {
		;----------------------------- マウス操作モード On→Off
		MouseMode = 0
		Menu TRAY,Icon,%A_ScriptDir%\icon\%IMEicon%
		SoundBeep 800,100
	}Else{
		;----------------------------- マウス操作モード Off→On
		MouseMode = 1
		Menu TRAY,Icon,%A_ScriptDir%\icon\m.ico
		SoundBeep 700,70
	}
Return
}
;------------------------------------------------ マウス左クリック
SubMouseLClk:
	If (GetKeyState("LButton")) {
		Send {LButton Up}
	}
	If (GetKeyState("RButton")) {
		Send {RButton Up}
	}
	If (GetKeyState("LCtrl","p")) {
		Send +{LButton}
	}Else{
		If (GetKeyState("RCtrl","p")) {
			Send ^{LButton}
		}Else{
			Send {LButton}
		}
	}
Return
;------------------------------------------------ マウス中クリック
SubMouseCClk:
	If (GetKeyState("LButton")) {
		Send {LButton Up}
	}
	If (GetKeyState("RButton")) {
		Send {RButton Up}
	}
	Send {Blind}{MButton}
Return
;------------------------------------------------ マウス右クリック
SubMouseRClk:
	If (GetKeyState("LButton")) {
		Send {LButton Up}
	}
	If (GetKeyState("RButton")) {
		Send {RButton Up}
	}
	Send {Blind}{RButton}
Return
;------------------------------------------------ マウス左ボタンダウンとアップのトグル
SubMouseLDwn:
	If (GetKeyState("LButton")) {
		If (GetKeyState("Ctrl","p")) {
			Send {Ctrl Down}{LButton Up}{Ctrl Up}
		}Else{
			If (GetKeyState("Alt","p")) {
				If (GetKeyState("Shift","p")) {
					Send {Shift Down}{Alt Down}{LButton Up}{Alt Up}{Shift Up}
				}Else{
					Send {Alt Down}{LButton Up}{Alt Up}
				}
			}Else{
				If (GetKeyState("Shift","p")) {
					Send {Shift Down}{LButton Up}{Shift Up}
				}Else{
					Send {LButton Up}
				}
			}
		}
	}Else{
		Send {LButton Down}
	}
Return
;------------------------------------------------ マウス右ボタンダウンとアップのトグル
SubMouseRDwn:
	If (GetKeyState("RButton")) {
		Send {RButton Up}
	}Else{
		Send {RButton Down}
	}
Return
;------------------------------------------------ ホイール上スクロール
SubMouseWhUp:
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- 指定されたスクロール量でスクロールする
	Send {WheelUp %MouseWhCnt%}
Return
;------------------------------------------------ ホイール下スクロール
SubMouseWhDn:
	;--------------- マウスホイール回転でウィンドウをアクティブにする
	If (ActvOnWheel == 1) {
		ActivateUnderMouseWindow()
	}
	;--------------- 指定されたスクロール量でスクロールする
	Send {WheelDown %MouseWhCnt%}
Return
;------------------------------------------------ カーソル移動
SubMouseLeft:
	Gosub SubMouseMoveCount
	mx := -20 * acc
	my := 0
	MouseMove,%mx%,%my%,0,R
Return
SubMouseRight:
	Gosub SubMouseMoveCount
	mx := 20 * acc
	my := 0
	MouseMove,%mx%,%my%,0,R
Return
SubMouseUp:
	Gosub SubMouseMoveCount
	mx := 0
	my := -20 * acc
	MouseMove,%mx%,%my%,0,R
Return
SubMouseDown:
	Gosub SubMouseMoveCount
	mx := 0
	my := 20 * acc
	MouseMove,%mx%,%my%,0,R
Return
SubMouseMoveCount:
	If (GetKeyState("LCtrl","p")) {
		;----------------------- LCtrlキーを押すと減速
		acc = 0.5
	}Else{
		If (GetKeyState("RCtrl","p")) {
			;----------------------- RCtrlキーを押すと加速
			acc = 3
		}Else{
			acc = 1
		}
	}
Return
;------------------------------------------------マウスカーソルをモニターXに転送（DestMonNoに転送先モニター番号をセットして呼び出す）
SubMoveMouseToMonitor:
	;------------------------------ マウスカーソルを転送する
	MoveMouseToMonitor(DestMonNo)
Return
;------------------------------------------------マウスカーソルを指定されたモニターに転送する
MoveMouseToMonitor(DestMonNo) {
	;------------------------------ 転送先のモニターサイズ、境界座標を取得する
	GetMonitorSize(DestMonNo, MonWidth, MonHeight, MonLeft, MonRight, MonTop, MonBottom)
	;------------------------------ マウスカーソルを転送する
	MouseMove MonLeft + MonWidth / 2, MonTop + MonHeight / 2
}
;------------------------------------------------マウスカーソルを他のモニターに転送する
SubSendMouseToMonitor:
	;------------------------------ マウスカーソルが存在するモニターの番号を取得する
	WhereIsCursorOnMonitor(MonNo, MousePosX, MousePosY, MonCount)
	;------------------------------ 転送先のモニター番号を設定する
	DestMonNo := MonNo + 1
	If (DestMonNo > MonCount) {
		DestMonNo := 1
	}
	;------------------------------ マウスカーソルを転送する
	MoveMouseToMonitor(DestMonNo)
Return
;------------------------------------------------ マウスカーソルの瞬間移動
SubMoveMouseToCnrLT:
	TeleportMouse(1)
Return
SubMoveMouseToCnrLB:
	TeleportMouse(2)
Return
SubMoveMouseToCnrRT:
	TeleportMouse(3)
Return
SubMoveMouseToCnrRB:
	TeleportMouse(4)
Return
TeleportMouse(position) {
	CoordMode Mouse,Screen
	;------------------------------ マウスカーソルが存在するモニターの番号を取得する
	WhereIsCursorOnMonitor(MonNo, MousePosX, MousePosY, MonCount)
	;------------------------------ モニターサイズを取得する
	SysGet m,MonitorWorkArea,%MonNo%
	mWidth := mRight - mLeft
	mHeight := mBottom - mTop
	posoffset = 32
	If (position == 1)
		MouseMove (mLeft + posoffset),(mTop - posoffset)
	If (position == 2)
		MouseMove (mLeft + posoffset),(mBottom - posoffset)
	If (position == 3)
		MouseMove (mRight - posoffset),(mTop - posoffset)
	If (position == 4)
		MouseMove (mRight - posoffset),(mBottom - posoffset)
Return
}
;------------------------------------------------ マウスカーソル下のウィンドウをアクティブにする
ActivateUnderMouseWindow() {
	;-------------------------------------- マウスカーソル下ウィンドウのIDとコントロールクラスを取得する
	MouseGetPos,,,win_id,WinCtrlClass
	;-------------------------------------- マウスカーソル下ウィンドウの実行ファイル名を取得する
	WinGet, win_exe, ProcessName, ahk_id %win_id%
	;-------------------------------------- マウスカーソル下ウィンドウのウィンドウタイトル実行ファイル名を取得する
	WinGetTitle, win_title, ahk_id %win_id%
	If (WinCtrlClass == "Start1") {
		;--------------- スタートボタン上でホイールを回転したときは何もしない
	}Else{
		;--------------- マウスカーソル下のウィンドウがアクティブでないときだけアクティブにする
		;                同じアプリケーションが複数起動していた時にそれぞれを見分けるためウィンドウタイトルも指定する
		IfWinNotActive,%win_title% ahk_exe %win_exe%
		{
			Winactivate,%win_title% ahk_exe %win_exe%
		}
	}
Return
}
;------------------------------------------------ 通知領域（タスクトレイ）上のホイール回転で音量変更
ChangeVolumeOnTray(WheelType,WinCtrlClass) {
	;MouseGetPos,,,win_id,WinCtrlClass
	;If (WinCtrlClass == "ToolbarWindow325" || WinCtrlClass == "ToolbarWindow326") {
	;--------------- 通知領域で操作されたか判定する
	Res := IsTasktrayControlUnderMouse(win_id,WinCtrlClass)
	If (Res == 1) {
		If (WheelType == "WheelUp") {
			Send,{Volume_Up 1}
		}Else{
			Send,{Volume_Down 1}
		}
	}
}
;------------------------------------------------  スタートボタン上のホイール回転ですべてのウィンドウを最小化/元に戻す
MinAllByWheelOnStBtn(WheelType,WinCtrlClass) {
	;MouseGetPos,,,win_id,WinCtrlClass
	If (WinCtrlClass == "Start1" || WinCtrlClass == "Windows.UI.Composition.DesktopWindowContentBridge1") {
		;--------------- 現在アクティブなウィンドウのクラスを取得する
		WinGet, active_win_id, ID, A
		WinGetClass, active_win_class, ahk_id %active_win_id%
		If (WheelType == "WheelUp") {
			;--------------- 元に戻す
			WinMinimizeAllUndo
			;--------------- 最小化する前にアクティブだったウィンドウをアクティブにする
			;               (最小化するときに最大化したウィンドウが存在した場合、元に戻したときにウィンドウのアクティブ状態が復元できないため)
			WinActivate, ahk_id %active_win_id_mem%
			;--------------- 現在開いている全てのウィンドウ情報を取得する
			WinGet TaskList,List,,,5eZg~G+X9)JAIofIJBgcIe\ZTZ`e-'DpmO
			;--------------- ウィンドウが常に前面表示に変更されていた場合は通常表示に戻す
			;               (WinMinimizeAllUndoで元に戻すとウィンドウが常に前面表示に強制変更されてしまうため)
			Loop %TaskList% {
				;--------------- ウィンドウIDを取得する
				StringTrimRight WinID,TaskList%A_Index%,0
				;--------------- 最小化以前に常に前面表示に設定されていたか判定する
				isAOT := -1
				Loop %BeforMinAllWinCt% {
					If (WinID == BeforMinAllWinId[A_index]) {
						If (BeforMinAllWinAt[A_index] == 1) {
							;--------------- 最小化以前に常に前面表示に設定されていた
							isAOT := 1
						}Else{
							;--------------- 最小化以前に常に前面表示に設定されていなかった
							;               (最小化以降に開かれたウィンドウのisAOTは-1になる)
							isAOT := 0
						}
						Break
					}
				}
				If (isAOT == 0) {
					;--------------- 元に戻したことで常に前面表示に強制変更された場合は解除する
					WinSet, AlwaysOnTop, Off, ahk_id %WinID%
				}
			}
		}Else{
			;--------------- 現在開いている全てのウィンドウ情報を取得する
			WinGet TaskList,List,,,5eZg~G+X9)JAIofIJBgcIe\ZTZ`e-'DpmO
			;--------------- 現在開いている全てのウィンドウの状態を取得する
			min_all := 1
			Loop %TaskList% {
				;--------------- ウィンドウIDを取得する
				StringTrimRight WinID,TaskList%A_Index%,0
				;--------------- ウィンドウの状態を取得する
				WinGet, win_max, MinMax, ahk_id %WinID%
				;--------------- ウィンドウタイトルを取得する
				WinGetTitle, WinTitle, ahk_id %WinID%
				;--------------- ウィンドウスタイルを取得する
				WinGet, WinStyle, Style, ahk_id %WinID%
				;--------------- ウィンドウポジションを取得する
				WinGetPos, WinX, WinY, WinW, WinH, ahk_id %WinID%
				;--------------- ウィンドウが最大化または通常の状態か確認する
				If (win_max > -1) {
					;--------------- 「ウィンドウタイトルがある ＆ィンドウサイズが０より大きい ＆（タイトルバーがある OR リサイズ可能なウィンドウ枠がある）」ウィンドウのみ対象とする
					If (StrLen(WinTitle) > 0 && WinW > 0 && WinH > 0 && ((WinStyle & 0x00C00000) || (WinStyle & 0x00040000) || (WinStyle & 0x000A0000))) {
						;--------------- 一つでも最大化または通常の状態のウィンドウがあれば判定変数をクリアして終了
						min_all := 0
						Break
					}
				}
			}
			If (min_all == 0) {
				;--------------- 一つでも最大化または通常の状態のウィンドウがあれば最小化する
				;--------------- 現在開いている全てのウィンドウ情報を取得する
				WinGet TaskList,List,,,5eZg~G+X9)JAIofIJBgcIe\ZTZ`e-'DpmO
				;--------------- 常に前面表示に設定されているウィンドウのIDを配列に保存する
				BeforMinAllWinCt := 0
				Loop %TaskList% {
					;--------------- ウィンドウIDを取得する
					StringTrimRight WinID,TaskList%A_Index%,0
					;--------------- 現在開いているウィンドウのIDを配列に保存する
					BeforMinAllWinCt += 1
					BeforMinAllWinId[BeforMinAllWinCt] := WinID
					;--------------- 拡張ウィンドウスタイルを取得する
					WinGet, WinExStyle, ExStyle, ahk_id %WinID%
					;--------------- 現在開いているウィンドウの「常に前面表示」状態を配列に保存する
					If (WinExStyle & 0x00000008) {
						;--------------- 常に前面表示になっている
						BeforMinAllWinAt[BeforMinAllWinCt] := 1
					}Else{
						;--------------- 常に前面表示になっていない
						BeforMinAllWinAt[BeforMinAllWinCt] := 0
					}
				}
				;--------------- すべてのウィンドウを最小化する
				WinMinimizeAll
				;--------------- 最小化する直前にアクティブだったウィンドウのIDを保管する
				active_win_id_mem := active_win_id
			}
		}
		Sleep 300
	}
}
;------------------------------------------------ タスクバーアイコン上のホイール回転で起動/最小化/元に戻す
MinimizeByWheelOnTaskIcon(WheelType,win_id,WinCtrlClass,SwapMouseButtons) {
	;--------------- マウスカーソルがタスクバーアイコンかタスクサムネイル上にあるか確認する
	If (WinCtrlClass == "MSTaskListWClass1" || WinCtrlClass == "TaskListThumbnailWnd" || WinCtrlClass == "MSTaskSwWClass1") {
		;--------------- 処理前のアクティブウィンドウの情報を取得する
		WinGet, before_active_win_id, ID, A
		;--------------- 左クリックしてウィンドウをアクティブ状態を変更する
		If (SwapMouseButtons == 0) {
			Send {LButton}
		}Else{
			;--------------- マウスボタンを反転しているときは左クリックを送る
			Send {RButton}
		}
		Sleep 300
		;--------------- 処理前のアクティブウィンドウの状態を取得する
		WinGet, before_active_win_max, MinMax, ahk_id %before_active_win_id%
		;--------------- 左クリック後のアクティブウィンドウのウィンドウクラスを取得する
		WinGet, active_win_id, ID, A
		WinGetClass, active_win_class, ahk_id %active_win_id%
		If (active_win_class == "TaskListThumbnailWnd" || StrLen(active_win_class) == 0) {
			;--------------- 複数のタスクが結合されているときは何もしない
			Send {Esc}
		}Else{
			;--------------- ホイールの回転方向に応じて処理する
			If (WheelType == "WheelUp") {
				If (before_active_win_max == -1) {
					;--------------- 処理前のアクティブウィンドウが最小化されたときは元に戻す
					WinRestore, ahk_id %before_active_win_id%
				}
			}Else{
				If (before_active_win_max == -1) {
					;--------------- 処理前のアクティブウィンドウが最小化されたときは何もしない
				}Else{
					;--------------- 処理前のアクティブウィンドウが変化しなかったときは、左クリックによりアクティブ化されたウィンドウを最小化する
					WinMinimize, ahk_id %active_win_id%
				}
			}
		}
	}
}
;------------------------------------------------ マウスカーソルがタスクバー領域に位置しているか確認
IsTaskbarControlUnderMouse(ByRef win_id,ByRef WinCtrlClass) {
	MouseGetPos,,,win_id,WinCtrlClass
	If (StrLen(WinCtrlClass) == 0) {
		WinGetClass, win_class, ahk_id %win_id%
		WinCtrlClass := win_class
	}
	If (WinCtrlClass == "Start1" || WinCtrlClass == "MSTaskListWClass1" || WinCtrlClass == "TaskListThumbnailWnd" || WinCtrlClass == "ToolbarWindow324" || WinCtrlClass == "ToolbarWindow325" || WinCtrlClass == "ToolbarWindow326" || WinCtrlClass == "Windows.UI.Composition.DesktopWindowContentBridge1" || WinCtrlClass == "TrayNotifyWnd1" || WinCtrlClass == "MSTaskSwWClass1") {
		Return 1
	}Else{
		Return 0
	}
}
;------------------------------------------------ マウスカーソル下が通知領域か確認
IsTasktrayControlUnderMouse(ByRef win_id,ByRef WinCtrlClass) {
	MouseGetPos,,,win_id,WinCtrlClass
	If (StrLen(WinCtrlClass) == 0) {
		WinGetClass, win_class, ahk_id %win_id%
		WinCtrlClass := win_class
	}
	If (WinCtrlClass == "ToolbarWindow324" || WinCtrlClass == "ToolbarWindow325" || WinCtrlClass == "ToolbarWindow326" || WinCtrlClass == "TrayNotifyWnd1") {
		Return 1
	}Else{
		Return 0
	}
}
;------------------------------------------------ マウスカーソルがアクティブウィンドウのタイトルバーの上にあるか判定する
IsMouseOnActiveWinTitleBar() {
	;--------------- マウスカーソル座標の取得モードをアクティブウィンドウの相対位置にする
	CoordMode,Mouse,Relative
	;--------------- マウスカーソル座標を取得する
	MouseGetPos, MouseX, MouseY, WinID
	;--------------- マウスカーソル下のウィンドウがアクティブか判定する
	IfWinActive ahk_id %WinID%
	{
		;--------------- タイトルバーの高さを取得
		TitleBarHeight := DllCall("GetSystemMetrics", UInt, 4)
		;--------------- マウスカーソルがタイトルバーの上にあるか判定する
		If (MouseY < TitleBarHeight) {
			Return True
		}Else{
			Return False
		}	
	}Else{
		Return False
	}
}
;------------------------------------------------ マウスカーソルが存在するモニターの番号、マウスの座標位置、モニターの数を取得する
WhereIsCursorOnMonitor(ByRef MonNo, ByRef MousePosX, ByRef MousePosY, ByRef mCount) {
	;------------------------------ モニター数を取得する
	SysGet, mCount, MonitorCount

	;------------------------------ マウスカーソルの座標を取得する（スクリーン座標）
	CoordMode, Mouse, Screen
	MouseGetPos, MousePosX, MousePosY

	;------------------------------ マウスカーソルが存在するモニターの番号を特定する（XかつYで判定）
	MonNo := 0
	Loop, %mCount% {
		; SysGetの第2引数に与えたプレフィックス名 + Left/Top/Right/Bottom が自動でセットされる
		SysGet, mon, Monitor, %A_Index%  ; monLeft, monTop, monRight, monBottom が入る
		if (MousePosX >= monLeft && MousePosX <= monRight
		 && MousePosY >= monTop  && MousePosY <= monBottom) {
			MonNo := A_Index
			break
		}
	}

	;------------------------------ 念のためのフォールバック（境界上などで未判定になった時）
	if (!MonNo) {
		minDist := 0x7FFFFFFF
		Loop, %mCount% {
			SysGet, mon, Monitor, %A_Index%
			cx := (monLeft + monRight) // 2
			cy := (monTop  + monBottom) // 2
			dx := MousePosX - cx
			dy := MousePosY - cy
			dist := dx*dx + dy*dy
			if (dist < minDist) {
				minDist := dist
				MonNo := A_Index
			}
		}
	}
}
;------------------------------------------------ 指定されたモニターのサイズ、境界座標を取得する
GetMonitorSize(MonNo, ByRef MonWidth, ByRef MonHeight, ByRef mAreaLeft, ByRef mAreaRight, ByRef mAreaTop, ByRef mAreaBottom) {
	;------------------------------ モニターサイズを取得する
	SysGet mArea,MonitorWorkArea,%MonNo%
	MonWidth := mAreaRight - mAreaLeft
	MonHeight := mAreaBottom - mAreaTop
}
;------------------------------------------------ 左水平スクロール
SubMouseWhLeft:
	If (EnableHorScroll == 1) {
		HorScroll(-3)
	}Else{
		Send {WheelLeft 3}
	}
Return
;------------------------------------------------ 右水平スクロール
SubMouseWhRight:
	If (EnableHorScroll == 1) {
		HorScroll(3)
	}Else{
		Send {WheelRight 3}
	}
Return
;------------------------------------------------ 水平スクロール関数
HorScroll(ScrollCount)
{
	;------------------------------ マウスカーソル下のウィンドウの情報を取得する
	CoordMode,Mouse,Screen
	MouseGetPos, HSC_MsPosX, HSC_MsPosY, HSC_UdrMsWinID, HSC_UdrMsWinCrtlID, 3
	;------------------------------ アクティブなMDIウィンドウのハンドルを取得する
	hWnd_MDI := MdiGetActive()
	If (hWnd_MDI > 0) {
		;------------------------------ MDIウィンドウが見つかった場合はスクロールハンドルを取得する
		hWnd := hWnd_MDI
		GetScrollBarHwnd(shwnd, HSC_MsPosX,HSC_MsPosY,hWnd_MDI,1)
		lParam := shwnd
	}Else{
		hWnd := HSC_UdrMsWinCrtlID
		lParam := ""
	}
	;------------------------------ 水平スクロールを送る
	uMsg := 0x114
	wParam := (ScrollCount>=0) ? 1 : 0
	Loop, % Abs(ScrollCount)
	{
		If (StrLen(hWnd) > 0) {
			PostMessage, %uMsg%, %wParam%, %lParam%,, ahk_id %hWnd%
		}else{
			;------------------------------ コントロールのハンドルが取得できない場合はSendで対応する
			If (ScrollCount > 0) {
				Send {WheelRight 3}
			}Else{
				Send {WheelLeft 3}
			}
		}
	}
}
;---------------------------------------------------------------------
; eamatの日記に公開されたスクリプトを使用
; http://d.hatena.ne.jp/eamat/20051121/p3
MdiGetActive(WinTitle="", MdiClientName="")
;----------------------------------------------------------------------
;   MDIにおいて現在アクティブなウィンドウのハンドルを取得する
;       対象： AHK v1.0.34以降       作成 : 2005.11.21
;   in  WinTitle        対象親ウィンドウ (省略時:アクティブウィンドウ)
;       MdiClientName   MDIクライアント名(省略時:MdiClient1)
;   戻り値：MDI子ウィンドウハンドル
;----------------------------------------------------------------------
{
	ifEqual,WinTitle,,  SetEnv,WinTitle,A
	if (MdiClientName = "")
	{
		MdiClientName := "MdiClient1"
		WinGetClass,cls,%WinTitle%
		ifEqual cls,XLMAIN,     SetEnv,MdiClientName,XLDESK1
	}

	SendMessage, 0x229 , 0, 0, %MdiClientName%, %WinTitle%  ;WM_MDIGETACTIVE
	ifEqual ErrorLevel,FAIL,    return 0
	else                        return %ErrorLevel%
}
;----------------------------------------------------------------------------
; GitHubの公開されたWheelAccel.ahkの一部を使用
; https://github.com/b4b4r07/autohotkey/blob/master/Data/usr/WheelAccel.ahk
;
GetScrollBarHwnd(byref shwnd, mx,my,ScrollCountlhwnd,mode=0)
;----------------------------------------------------------------------------
;	該当コントロールのスクロールハンドルを返す
;	戻り値 指定方向のスクロールオブジェクト数
;	out	shwnd	   スクロールハンドル格納先
;	in mx,my	   マウス位置
;	ScrollCountlhwnd	対象コントロールのハンドル
;	mode		0:VSCROLL(縦) 1:HSCROLL(横)
;----------------------------------------------------------------------------
{
	global BrotherScroolBarList

	shwnd = 0
	WinGet,lst,ControlList,ahk_id %ScrollCountlhwnd%
	WinGetClass,pcls, ahk_id %ScrollCountlhwnd%

	;配下にスクロールバーなし
	ifNotInString, lst, ScrollBar
	{   ;兄弟指定がある場合は、自分と同列のスクロールバーを探す
		if pcls in %BrotherScroolBarList%
		{
			ScrollCountlhwnd := DllCall("GetParent",UInt,ScrollCountlhwnd, UInt)
			WinGet,lst,ControlList,ahk_id %ScrollCountlhwnd%
			WinGetClass,pcls, ahk_id %ScrollCountlhwnd%
		}
		else return 0
	}

	;スクロールバーコントロールの抽出
	vScrollCount = 0
	hScrollCount = 0
	Loop,Parse,lst,`n
	{
		ifNotInstring A_LoopField , ScrollBar
			Continue
		ControlGet,hwnd, Hwnd,,%A_LoopField%,ahk_id %ScrollCountlhwnd%
		WinGetpos, sx,sy,sw,sh, ahk_id %hwnd%

		if (sw < sh)	{   ;縦スクロール
			vScrollCount++
			WinGetpos, vx%vScrollCount%,vy%vScrollCount%,vw%vScrollCount%,vh%vScrollCount%, ahk_id %hwnd%
			if (vi = "")
			|| ((vy%vi%!=sy)&&((sy<my)&&(vy%vi%<sy))||((vy%vi%>my)&&(vy%vi%>sy))) ;上下分割
			|| ((vx%vi%!=sx)&&((sx>mx)&&(vx%vi%>sx))||((vx%vi%<mx)&&(vx%vi%<sx))) ;左右分割
			{
				vi := vScrollCount
				if (mode = 0)   {
					ret   := vScrollCount
					shwnd := hwnd
				}
			}
		}
		if (sw > sh)	{   ;横スクロール
			hScrollCount++
			WinGetpos, hx%hScrollCount%,hy%hScrollCount%,hw%hScrollCount%,hh%hScrollCount%, ahk_id %hwnd%
			if (hi = "")
			|| ((hx%hi%!=sx)&&((sx<mx)&&(hx%hi%<sx))||((hx%hi%>mx)&&(hx%hi%>sx)))		   ;左右(Excel型)
			|| ((hy%hi%!=sy)&&((sy+sh>my)&&(hy%hi%>sy))||((hy%hi%+hh%hi%<my)&&(hy%hi%<sy))) ;上下(Word型)
			{
				hi := hScrollCount
				if (mode = 1)   {
					ret   := hScrollCount
					shwnd := hwnd
				}
			}
		}
	}

	;---アクティブペインにしかバーがないアプリ、可能ならペインを切り替える---
	;[秀丸]用 カスタム：分割ウィンドウ切り替え
	if (pcls = "HM32CLIENT") && !((vy1 <= my) && (vy1+vh1 >= my))
		PostMessage, 0x111, 142,  0, ,ahk_id %ScrollCountlhwnd%   ;WM_COMMAND
	;------------------------------------------------------------------------

	return ret
}