﻿;=========================================== 単独打鍵
SendSingleKey:
	If (NoKeyDown == 1) {
		;--------------- トラックボールスクロール起動キーの単独押下が無効になっているときは、キーを送らない
		NoKeyDown := 0
		Return
	}
	;--------------- 押されたキーを取得する
	StringReplace this_key,A_ThisHotkey,$,,All
	;--------------- キーが(-)のときは連想配列の添字指定がうまくいかないので(--)に変換する
	StringReplace this_key,this_key,-,--,All
	;--------------- Windowsキーを使ったショートカットキーを有効にする
	If (GetKeyState("LWin","P") || GetKeyState("RWin","P")) {
		If (GetKeyState("Ctrl","P")) {
			KeyWait, Ctrl
			key = #^{%this_key%}
			Gosub SendKeyOrSearch
			Return
		}
		If (GetKeyState("Alt","P")) {
			KeyWait, Alt
			key = #!{%this_key%}
			Gosub SendKeyOrSearch
			Return
		}
		key = #{%this_key%}
		Gosub SendKeyOrSearch
		Return
	}
	;------------------------- 直前にシフトキーまたはスペシャルキーと無変換キーを同時押ししていた場合は、シフトキーまたはスペシャルキー+無変換キーとの3つ同時押しのアクションを実行する（3キー同時押しに対応していないキーボードへの対応）F23導入により廃止
	;If (A_PriorHotkey == "LShift & sc07B" || A_PriorHotkey == "RShift & sc07B" || A_PriorHotkey == "f24 & sc07B") && (A_TimeSincePriorHotkey < 1000) {
	;	;--------------- タスク切替処理の実行判定
	;	key := key_muhenkan_shift[this_key]
	;	If (StrLen(key) = 0) {
	;		;--------------- 指定されたタスクをアクティブにする
	;		task_index := this_key
	;		Gosub ActivateTask
	;	}Else{
	;		;--------------- iniファイルで指定されたショートカットを実行する
	;		Gosub SendKeyOrSearch
	;	}
	;	Return
	;}
	;--------------- 処理対象を判定する
	If WinActive("ahk_group NotAutoIMEonApp") {
		;------------------------- オートIMEオン対象外アプリ時の処理
		If (xInput == 1) {
			;--------------- Spaceキーが押された場合は、Space Upとの二重起動を避ける
			xInput := 0
		}Else{
			;--------------- スペシャルキーが同時に押されていた場合は、同時押し配列を優先する
			If (GetKeyState("f24","p")) {
				;--------------- iniファイルで指定されたキーを取得する
				this_key = %this_key%%DirTypJpnChrMode%
				key := key_special[this_key]
				If (Strlen(key) > 0) {
					;--------------- オートIMEオン対象・対象外アプリに応じてIMEをオン・オフする
					Gosub AutoIMEOnOff
					;--------------- iniファイルで指定されたキーを送る
					Gosub SendKeyOrSearch
				}
			}Else{
				If (IME_IsON(WinExist("A")) == "1") {
					;--------------- 日本語入力時
					this_key = %this_key%1
				}Else{
					;--------------- 英数入力時
					this_key = %this_key%0
				}
				;--------------- iniファイルで指定されたキーを送る
				key := key_single[this_key]
				key = {blind}%key%
				Gosub SendKeyOrSearch
			}
		}
	}Else{
		;------------------------- オートIMEオン対象アプリ時の処理
		;--------------- 同時に押されたキーを判定する（Spaceキーを押しながら入力したときは、一時的にダイレクト日本語モードを逆転する）
		If (GetKeyState("Space","p") && this_key <> "Space") {
			If WinActive("ahk_group AutoIMEoffApp") {
				WinGetClass, ActiveWinClass, A
				If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
					;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
					RevDirTypJpnChrMode := 0
				}Else{
					;------------------------- オートIMEオフアプリは動作を反転する
					RevDirTypJpnChrMode := 1
				}
			}Else{
				RevDirTypJpnChrMode := 0
			}
			;------------------------- 日本語入力中に半角英数字記号入力または半角英数字記号入力中に日本語入力
			If (DirTypJpnChrMode == 1 && RevDirTypJpnChrMode == 0) {
				;--------------- ダイレクト日本語モードONのとき
				;------------------------- 日本語入力中に半角英数字記号入力
				;--------------- iniファイルで指定されたキーを取得する
				this_key = %this_key%0
				key := key_single[this_key]
				key = {blind}%key%
				If (Strlen(key) > 0) {
					;--------------- IMEオフ
					SetIME(4)
					;--------------- iniファイルで指定されたキーを送る
					Gosub SendKeyOrSearch
				}
			}Else{
				;--------------- ダイレクト日本語モードOFFのとき
				;------------------------- 半角英数字記号入力中に日本語入力
				;--------------- iniファイルで指定されたキーを取得する
				this_key = %this_key%1
				key := key_single[this_key]
				key = {blind}%key%
				If (Strlen(key) > 0) {
					;--------------- IMEオン
					SetIME(3)
					;--------------- iniファイルで指定されたキーを送る
					Gosub SendKeyOrSearch
				}
			}
			;--------------- Spaceキーが押された場合は、Space Upとの二重起動を避けるため変数に値をセットする
			xInput := 1
		}Else{
			;--------------- Spaceキーが押された場合は、Space Upとの二重起動を避ける
			If (xInput == 1) {
				xInput := 0
			}Else{
				;--------------- スペシャルキーが同時に押されていた場合は、同時押し配列を優先する
				If (GetKeyState("f24","p")) {
					;--------------- iniファイルで指定されたキーを取得する
					If WinActive("ahk_group AutoIMEoffApp") {
						WinGetClass, ActiveWinClass, A
						If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
							;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
							this_key = %this_key%%DirTypJpnChrMode%
						}Else{
							;------------------------- オートIMEオフアプリは常に半角モードにする
							this_key = %this_key%0
						}
					}Else{
						this_key = %this_key%%DirTypJpnChrMode%
					 }
					key := key_special[this_key]
					If (Strlen(key) > 0) {
						;--------------- オートIMEオン対象・対象外アプリに応じてIMEをオン・オフする
						Gosub AutoIMEOnOff
						;--------------- iniファイルで指定されたキーを送る
						Gosub SendKeyOrSearch
					}
				}Else{
					;------------------------- ダイレクトに日本語入力
					;--------------- iniファイルで指定されたキーを取得する
					If WinActive("ahk_group AutoIMEoffApp") {
						WinGetClass, ActiveWinClass, A
						If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
							;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
							this_key = %this_key%%DirTypJpnChrMode%
						}Else{
							;------------------------- オートIMEオフアプリは常に半角モードにする
							this_key = %this_key%0
						}
					}Else{
						this_key = %this_key%%DirTypJpnChrMode%
					 }
					key := key_single[this_key]
					;--------------- Ctrlキーを押しながらタイプする操作を連続して試みたとき、2回目以降はCtrlが無視されるので、明示的にCtrlキーを定義する
					If (GetKeyState("Ctrl","p")) {
						key = ^%key%
					}
					key = {blind}%key%
					If (Strlen(key) > 0) {
						;--------------- ダイレクト日本語入力モードに応じてIMEをオン・オフする
						SetIME(1)
						;--------------- iniファイルで指定されたキーを送る
						Gosub SendKeyOrSearch
					}
				}
			}
		}
	}
Return
;=========================================== +LShift
SendLShiftKey:
	;--------------- 押されたキーを取得する
	this_key := A_ThisHotkey
	StringReplace this_key,this_key,LShift &,,All
	StringTrimLeft this_key,this_key,1
	;--------------- キーが(-)のときは連想配列の添字指定がうまくいかないので(--)に変換する
	StringReplace this_key,this_key,-,--,All
	;--------------- Windowsキーを使ったショートカットを有効にする
	If (GetKeyState("LWin","P") || GetKeyState("RWin","P")) {
		NoLWin := 1
		NoRWin := 1
		key = {blind}{%this_key%}
		Gosub SendKeyOrSearch
		Return
	}
	;------------------------- 直前に左シフトキーと無変換キーを同時押ししていた場合は、左シフト+無変換キーとの3つ同時押しのアクションを実行する（3キー同時押しに対応していないキーボードへの対応）F23導入により廃止
	;If (A_PriorHotkey == "LShift & sc07B") && (A_TimeSincePriorHotkey < 1000) {
	;	;--------------- タスク切替処理の実行判定
	;	key := key_muhenkan_shift[this_key]
	;	If (StrLen(key) = 0) {
	;		;--------------- 指定されたタスクをアクティブにする
	;		task_index := this_key
	;		Gosub ActivateTask
	;	}Else{
	;		;--------------- iniファイルで指定されたショートカットを実行する
	;		Gosub SendKeyOrSearch
	;	}
	;	Return
	;}
	;--------------- 同時に押されたキーを判定する（Spaceキーを押しながら入力したときは、一時的にダイレクト日本語モードを逆転する）
	If (GetKeyState("Ctrl","p") || GetKeyState("Alt","p")) {
		;--------------- CtrlまたはAltキーが押されていた時はショートカットキーとして動作させる
		;--------------- IMEをオフにする
		SetIME(4)
		this_key = %this_key%0
		key := key_lshift[this_key]
		Gosub SendKeyOrSearch
	}Else{
		;--------------- 処理対象を判定する
		If WinActive("ahk_group NotAutoIMEonApp") {
			;------------------------- オートIMEオン対象外アプリ時の処理
			If (IME_IsON(WinExist("A")) == "1") {
				;--------------- 日本語入力時
				this_key = %this_key%1
			}Else{
				;--------------- 英数入力時
				this_key = %this_key%0
			}
			;--------------- iniファイルで指定されたキーを送る
			key := key_lshift[this_key]
			Gosub SendKeyOrSearch
		}Else{
			;------------------------- オートIMEオン対象アプリ時の処理
			;--------------- 同時に押されたキーを判定する（Spaceキーを押しながら入力したときは、一時的にダイレクト日本語モードを逆転する）
			If (GetKeyState("Space","p") && this_key <> "Space") {
				If WinActive("ahk_group AutoIMEoffApp") {
					WinGetClass, ActiveWinClass, A
					If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
						;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
						RevDirTypJpnChrMode := 0
					}Else{
						;------------------------- オートIMEオフアプリは動作を反転する
						RevDirTypJpnChrMode := 1
					}
				}Else{
					RevDirTypJpnChrMode := 0
				}
				;------------------------- 日本語入力中に半角英数字記号入力または半角英数字記号入力中に日本語入力
				If (DirTypJpnChrMode == 1 && RevDirTypJpnChrMode == 0) {
					;--------------- ダイレクト日本語モードONのとき
					;------------------------- 日本語入力中に半角英数字記号入力
					;--------------- IMEオフ
					SetIME(4)
					;--------------- iniファイルで指定されたキーを送る
					this_key = %this_key%0
					key := key_lshift[this_key]
					Gosub SendKeyOrSearch
				}Else{
					;--------------- ダイレクト日本語モードOFFのとき
					;------------------------- 半角英数字記号入力中に日本語入力
					;--------------- IMEオン
					SetIME(3)
					;--------------- iniファイルで指定されたキーを送る
					this_key = %this_key%1
					key := key_lshift[this_key]
					Gosub SendKeyOrSearch
				}
				;--------------- Spaceキーが押された場合は、Space Upとの二重起動を避けるため変数に値をセットする
				xInput := 1
			}Else{
				;--------------- Spaceキーが押されていた場合は、Space Upとの二重起動を避ける
				If (xInput == 1) {
					xInput := 0
				}Else{
					;------------------------- ダイレクトに日本語入力
					If WinActive("ahk_group AutoIMEoffApp") {
						WinGetClass, ActiveWinClass, A
						;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
						If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
							strWrk := DirTypJpnChrMode
						}Else{
							If (DirTypJpnChrMode == 1) {
								;------------------------- オートIMEオフアプリは動作を反転する
								strWrk := 0
							}Else{
								strWrk := 1
							}
						}
					}Else{
						strWrk := DirTypJpnChrMode
					}
					;--------------- iniファイルで指定されたキーを取得する
					this_key = %this_key%%strWrk%
					key := key_lshift[this_key]
					If (Strlen(key) > 0) {
						;--------------- オートIMEオン対象・対象外アプリに応じてIMEをオン・オフする
						Gosub AutoIMEOnOff
						;--------------- iniファイルで指定されたキーを送る
						Gosub SendKeyOrSearch
					}
				}
			}
		}
	}
Return
;=========================================== +RShift
SendRShiftKey:
	;--------------- 押されたキーを取得する
	this_key := A_ThisHotkey
	StringReplace this_key,this_key,RShift &,,All
	StringTrimLeft this_key,this_key,1
	;--------------- キーが(-)のときは連想配列の添字指定がうまくいかないので(--)に変換する
	StringReplace this_key,this_key,-,--,All
	;--------------- Windowsキーを使ったショートカットを有効にする
	If (GetKeyState("LWin","P") || GetKeyState("RWin","P")) {
		NoLWin := 1
		NoRWin := 1
		key = {blind}{%this_key%}
		Gosub SendKeyOrSearch
		Return
	}
	;------------------------- 直前に右シフトキーと無変換キーを同時押ししていた場合は、右シフト+無変換キーとの3つ同時押しのアクションを実行する（3キー同時押しに対応していないキーボードへの対応）F23導入により廃止
	;If (A_PriorHotkey == "RShift & sc07B") && (A_TimeSincePriorHotkey < 1000) {
	;	;--------------- タスク切替処理の実行判定
	;	key := key_muhenkan_shift[this_key]
	;	If (StrLen(key) = 0) {
	;		;--------------- 指定されたタスクをアクティブにする
	;		task_index := this_key
	;		Gosub ActivateTask
	;	}Else{
	;		;--------------- iniファイルで指定されたショートカットを実行する
	;		Gosub SendKeyOrSearch
	;	}
	;	Return
	;}
	;--------------- 同時に押されたキーを判定する（Spaceキーを押しながら入力したときは、一時的にダイレクト日本語モードを逆転する）
	If (GetKeyState("Ctrl","p") || GetKeyState("Alt","p")) {
		;--------------- CtrlまたはAltキーが押されていた時はショートカットキーとして動作させる
		;--------------- IMEをオフにする
		SetIME(4)
		this_key = %this_key%0
		key := key_lshift[this_key]
		Gosub SendKeyOrSearch
	}Else{
		;--------------- 処理対象を判定する
		If WinActive("ahk_group NotAutoIMEonApp") {
			;------------------------- オートIMEオン対象外アプリ時の処理
			If (IME_IsON(WinExist("A")) == "1") {
				;--------------- 日本語入力時
				this_key = %this_key%1
			}Else{
				;--------------- 英数入力時
				this_key = %this_key%0
			}
			;--------------- iniファイルで指定されたキーを送る
			key := key_rshift[this_key]
			Gosub SendKeyOrSearch
		}Else{
			;------------------------- オートIMEオン対象アプリ時の処理
			;--------------- 同時に押されたキーを判定する（Spaceキーを押しながら入力したときは、一時的にダイレクト日本語モードを逆転する）
			If (GetKeyState("Space","p") && this_key <> "Space") {
				If WinActive("ahk_group AutoIMEoffApp") {
					WinGetClass, ActiveWinClass, A
					If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
						;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
						RevDirTypJpnChrMode := 0
					}Else{
					;------------------------- オートIMEオフアプリは動作を反転する
						RevDirTypJpnChrMode := 1
					}
				}Else{
					RevDirTypJpnChrMode := 0
				}
				;------------------------- 日本語入力中に半角英数字記号入力または半角英数字記号入力中に日本語入力
				If (DirTypJpnChrMode == 1 && RevDirTypJpnChrMode == 0) {
					;--------------- ダイレクト日本語モードONのとき
					;------------------------- 日本語入力中に半角英数字記号入力
					;--------------- IMEオフ
					SetIME(4)
					;--------------- iniファイルで指定されたキーを送る
					this_key = %this_key%0
					key := key_rshift[this_key]
					Gosub SendKeyOrSearch
				}Else{
					;--------------- ダイレクト日本語モードOFFのとき
					;------------------------- 半角英数字記号入力中に日本語入力
					;--------------- IMEオン
					SetIME(3)
					;--------------- iniファイルで指定されたキーを送る
					this_key = %this_key%1
					key := key_rshift[this_key]
					Gosub SendKeyOrSearch
				}
				;--------------- Spaceキーが押された場合は、Space Upとの二重起動を避けるため変数に値をセットする
				xInput := 1
			}Else{
				;--------------- Spaceキーが押されていた場合は、Space Upとの二重起動を避ける
				If (xInput == 1) {
					xInput := 0
				}Else{
					;------------------------- ダイレクトに日本語入力
					If WinActive("ahk_group AutoIMEoffApp") {
						WinGetClass, ActiveWinClass, A
						;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
						If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
							strWrk := DirTypJpnChrMode
						}Else{
							If (DirTypJpnChrMode == 1) {
								;------------------------- オートIMEオフアプリは動作を反転する
								strWrk := 0
							}Else{
								strWrk := 1
							}
						}
					}Else{
						strWrk := DirTypJpnChrMode
					}
					;--------------- iniファイルで指定されたキーを取得する
					this_key = %this_key%%strWrk%
					key := key_rshift[this_key]
					If (Strlen(key) > 0) {
						;--------------- オートIMEオン対象・対象外アプリに応じてIMEをオン・オフする
						Gosub AutoIMEOnOff
						;--------------- iniファイルで指定されたキーを送る
						Gosub SendKeyOrSearch
					}
				}
			}
		}
	}
Return
;=========================================== +スペシャルキー
SendSpecialKey:
	;--------------- 押されたキーを取得する
	this_key := A_ThisHotkey
	StringReplace this_key,this_key,f24 &,,All
	StringTrimLeft this_key,this_key,1
	;--------------- キーが(-)のときは連想配列の添字指定がうまくいかないので(--)に変換する
	StringReplace this_key,this_key,-,--,All
	;------------------------- 直前にスペシャルキーと無変換キーを同時押ししていた場合は、スペシャルキー+無変換キーとの3つ同時押しのアクションを実行する（3キー同時押しに対応していないキーボードへの対応）F23導入により廃止
	;If (A_PriorHotkey == "f24 & sc07B") && (A_TimeSincePriorHotkey < 1000) {
	;	;--------------- タスク切替処理の実行判定
	;	key := key_muhenkan_shift[this_key]
	;	If (StrLen(key) = 0) {
	;		;--------------- 指定されたタスクをアクティブにする
	;		task_index := this_key
	;		Gosub ActivateTask
	;	}Else{
	;		;--------------- iniファイルで指定されたショートカットを実行する
	;		Gosub SendKeyOrSearch
	;	}
	;	Return
	;}
	;--------------- 処理対象を判定する
	If WinActive("ahk_group NotAutoIMEonApp") {
		;------------------------- オートIMEオン対象外アプリ時の処理
		If (IME_IsON(WinExist("A")) == "1") {
			;--------------- 日本語入力時
			this_key = %this_key%1
		}Else{
			;--------------- 英数入力時
			this_key = %this_key%0
		}
		;--------------- iniファイルで指定されたキーを送る
		key := key_special[this_key]
		Gosub SendKeyOrSearch
	}Else{
		;------------------------- オートIMEオン対象アプリ時の処理
		If WinActive("ahk_group AutoIMEoffApp") {
			WinGetClass, ActiveWinClass, A
			;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
			If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
				strWrk := DirTypJpnChrMode
			}Else{
				If (DirTypJpnChrMode == 1) {
					;------------------------- オートIMEオフアプリは動作を反転する
					strWrk := 0
				}Else{
					strWrk := 1
				}
			}
		}Else{
			strWrk := DirTypJpnChrMode
		}
		;--------------- iniファイルで指定されたキーを取得する
		this_key = %this_key%%strWrk%
		key := key_special[this_key]
		If (Strlen(key) > 0) {
			;--------------- オートIMEオン対象・対象外アプリに応じてIMEをオン・オフする
			Gosub AutoIMEOnOff
			;--------------- iniファイルで指定されたキーを送る
			Gosub SendKeyOrSearch
		}
	}
	;--------------- 同時に押されたキーを判定する
	If (GetKeyState("Space","p")) {
		;--------------- Space Upとの二重起動を避けるため変数に値をセットする
		xInput := 1
	}
Return
;=========================================== +タスク切替専用キー
SendChangeTaskKey:
	;--------------- 押されたキーを取得する
	this_key := A_ThisHotkey
	StringReplace this_key,this_key,f23 &,,All
	StringTrimLeft this_key,this_key,1
	;--------------- キーが(-)のときは連想配列の添字指定がうまくいかないので(--)に変換する
	StringReplace this_key,this_key,-,--,All
	;--------------- 指定されたタスクをアクティブにする
	key := key_muhenkan_shift[this_key]
	task_index := this_key
	Gosub ActivateTask
Return
;=========================================== +変換
SendHenkanKey:
	;--------------- 押されたキーを取得する
	this_key := A_ThisHotkey
	StringReplace this_key,this_key,sc079 &,,All
	StringTrimLeft this_key,this_key,1
	;--------------- キーが(-)のときは連想配列の添字指定がうまくいかないので(--)に変換する
	StringReplace this_key,this_key,-,--,All
	;------------------------- 同時にShiftまたはスペシャルキーが押されていた時の処理
	If (GetKeyState("Shift","p") || GetKeyState("f24","p")) {
		;--------------- iniファイルで指定されたショートカットを実行する
		key := key_henkan_shift[this_key]
		Gosub SendKeyOrSearch
	}Else{
		;------------------------- 同時にAltが押されていた時の処理
		If (GetKeyState("Alt")) {
			;--------------- iniファイルで指定されたショートカットを実行する
			key := key_henkan_alt[this_key]
			Gosub SendKeyOrSearch
		}Else{
			;--------------- 同時に押されたキーを判定する（Spaceキーを押しながら入力したときは、一時的にダイレクト日本語モードを逆転する）
			If (GetKeyState("Space","p") && this_key <> "Space") {
				;--------------- 同時に押されたのがSpaceだけのときはiniファイルで指定されたショートカットを実行する
				If (this_key == "Space") {
					;--------------- キー配列の添字を編集する
					this_key = %this_key%%DirTypJpnChrMode%
					key := key_henkan[this_key]
					Gosub SendKeyOrSearch
				}Else{
					If WinActive("ahk_group AutoIMEoffApp") {
						WinGetClass, ActiveWinClass, A
						If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
						;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
							RevDirTypJpnChrMode := 0
						}Else{
							;------------------------- オートIMEオフアプリは動作を反転する
							RevDirTypJpnChrMode := 1
						}
					}Else{
						RevDirTypJpnChrMode := 0
					}
					;------------------------- 日本語入力中に半角英数字記号入力または半角英数字記号入力中に日本語入力
					If (DirTypJpnChrMode == 1 && RevDirTypJpnChrMode == 0) {
						;--------------- ダイレクト日本語モードONのとき
						;------------------------- 日本語入力中に半角英数字記号入力
						;--------------- IMEオフ
						SetIME(4)
						;--------------- iniファイルで指定されたキーを送る
						this_key = %this_key%0
						key := key_rshift[this_key]
						Gosub SendKeyOrSearch
					}Else{
						;--------------- ダイレクト日本語モードOFFのとき
						;------------------------- 半角英数字記号入力中に日本語入力
						;--------------- IMEオン
						SetIME(3)
						;--------------- iniファイルで指定されたキーを送る
						this_key = %this_key%1
						key := key_rshift[this_key]
						Gosub SendKeyOrSearch
					}
				}
				;--------------- Spaceキーが押された場合は、Space Upとの二重起動を避けるため変数に値をセットする
				xInput := 1
			}Else{
				;--------------- Spaceキーが押されていた場合は、Space Upとの二重起動を避ける
				If (xInput == 1) {
					xInput := 0
				}Else{
					;------------------------- 同時押しキーが無い時の処理
					If (task_assign_henkan[this_key] == 1) {
						;------------------------- 変換キーと同時押しに、無変換キー+Shiftを割り当てていた時の処理
						;--------------- タスク切替処理の実行判定
						key := key_muhenkan_shift[this_key]
						If (StrLen(key) = 0) {
							;--------------- 指定されたタスクをアクティブにする
							task_index := this_key
							Gosub ActivateTask
						}Else{
							;--------------- iniファイルで指定されたショートカットを実行する
							Gosub SendKeyOrSearch
						}
					}Else{
						;--------------- iniファイルで指定されたショートカットを実行する
						;--------------- キー配列の添字を編集する
						this_key = %this_key%%DirTypJpnChrMode%
						key := key_henkan[this_key]
						Gosub SendKeyOrSearch
					}
				}
			}
		}
	}
Return
;=========================================== +無変換
SendMuhenkanKey:
	;--------------- 押されたキーを取得する
	this_key := A_ThisHotkey
	StringReplace this_key,this_key,sc07B &,,All
	StringTrimLeft this_key,this_key,1
	;--------------- キーが(-)のときは連想配列の添字指定がうまくいかないので(--)に変換する
	StringReplace this_key,this_key,-,--,All
	;------------------------- 同時にShiftまたはスペシャルキーが押されていたの処理
	If (GetKeyState("Shift","p") || GetKeyState("f24","p")) {
		;--------------- タスク切替処理の実行判定
		key := key_muhenkan_shift[this_key]
		If (StrLen(key) = 0) {
			;--------------- 指定されたタスクをアクティブにする
			task_index := this_key
			Gosub ActivateTask
		}Else{
			;--------------- iniファイルで指定されたショートカットを実行する
			Gosub SendKeyOrSearch
		}
	}Else{
		;------------------------- 同時にAltが押されていた時の処理
		If (GetKeyState("Alt")) {
			;--------------- iniファイルで指定されたショートカットを実行する
			key := key_muhenkan_alt[this_key]
			Gosub SendKeyOrSearch
		}Else{
			;--------------- 同時に押されたキーを判定する（Spaceキーを押しながら入力したときは、一時的にダイレクト日本語モードを逆転する）
			If (GetKeyState("Space","p") && this_key <> "Space") {
				;--------------- 同時に押されたのがSpaceだけのときはiniファイルで指定されたショートカットを実行する
				If (this_key == "Space") {
					;--------------- キー配列の添字を編集する
					this_key = %this_key%%DirTypJpnChrMode%
					key := key_muhenkan[this_key]
					Gosub SendKeyOrSearch
				}Else{
					If WinActive("ahk_group AutoIMEoffApp") {
						WinGetClass, ActiveWinClass, A
						If (ActiveWinClass == "#32770" && AlwaysIMEOnAtDialog == 1) {
							;------------------------- ファイルの保存ダイアログのときはダイレクトに日本語入力を有効にする
							RevDirTypJpnChrMode := 0
						}Else{
							;------------------------- オートIMEオフアプリは動作を反転する
							RevDirTypJpnChrMode := 1
						}
					}Else{
						RevDirTypJpnChrMode := 0
					}
					;------------------------- 日本語入力中に半角英数字記号入力または半角英数字記号入力中に日本語入力
					If (DirTypJpnChrMode == 1 && RevDirTypJpnChrMode == 0) {
						;--------------- ダイレクト日本語モードONのとき
						;------------------------- 日本語入力中に半角英数字記号入力
						;--------------- IMEオフ
						SetIME(4)
						;--------------- iniファイルで指定されたキーを送る
						this_key = %this_key%0
						key := key_lshift[this_key]
						Gosub SendKeyOrSearch
					}Else{
						;--------------- ダイレクト日本語モードOFFのとき
						;------------------------- 半角英数字記号入力中に日本語入力
						;--------------- IMEオン
						SetIME(3)
						;--------------- iniファイルで指定されたキーを送る
						this_key = %this_key%1
						key := key_lshift[this_key]
						Gosub SendKeyOrSearch
					}
				}
				;--------------- Spaceキーが押された場合は、Space Upとの二重起動を避けるため変数に値をセットする
				xInput := 1
			}Else{
				;--------------- Spaceキーが押されていた場合は、Space Upとの二重起動を避ける
				If (xInput == 1) {
					xInput := 0
				}Else{
					;------------------------- 同時押しキーが無い時の処理
					;--------------- iniファイルで指定されたショートカットを実行する
					;--------------- キー配列の添字を編集する
					this_key = %this_key%%DirTypJpnChrMode%
					key := key_muhenkan[this_key]
					Gosub SendKeyOrSearch
				}
			}
		}
	}
Return
;=========================================== +AppsKey
SendAppsKey:
	;--------------- 押されたキーを取得する
	this_key := A_ThisHotkey
	StringReplace this_key,this_key,AppsKey &,,All
	StringTrimLeft this_key,this_key,1
	;--------------- キーが(-)のときは連想配列の添字指定がうまくいかないので(--)に変換する
	StringReplace this_key,this_key,-,--,All
	;------------------------- 同時にShiftまたはスペシャルキーが押されていた時の処理
	If (GetKeyState("Shift","p") || GetKeyState("f24","p")) {
		;--------------- iniファイルで指定されたショートカットを実行する
		key := key_appskey_shift[this_key]
		Gosub SendKeyOrSearch
	}Else{
		;------------------------- 同時にAltが押されていた時の処理
		If (GetKeyState("Alt")) {
			;--------------- iniファイルで指定されたショートカットを実行する
			key := key_appskey_alt[this_key]
			Gosub SendKeyOrSearch
		}Else{
			;------------------------- 同時押しキーが無い時の処理
			;--------------- iniファイルで指定されたショートカットを実行する
			key := key_appskey[this_key]
			Gosub SendKeyOrSearch
		}
	}
Return
;------------------------------------------------ iniファイルの指定内容に応じたキーを送る
SendKeyOrSearch:
	;--------------- キー操作サブルーチンが指定されていた時はサブルーチンを実行する
	IfInString key,Sub
	{
		StringReplace key,key,{Blind},,All
	
	IfInString key,SubMoveMouseToMonitor
		{
			;--------------- マウスカーソルのモニター転送が指定されていた時は、転送先モニターをセットしてサブルーチンを実行する
			StringSplit, keyArray, key, `,
			DestMonNo := keyArray2
			Gosub %keyArray1%
			Return
		}
		IfInString key,SubMouseWh
		{
			;--------------- マウスカーソルのモニター転送が指定されていた時は、転送先モニターをセットしてサブルーチンを実行する
			StringSplit, keyArray, key, `,
			If (strLen(keyArray2) == 0) {
				MouseWhCnt := 6
			}Else{
				MouseWhCnt := keyArray2
			}
			Gosub %keyArray1% 
			Return
		}
		Gosub %key%
		Return
	}
	;--------------- ^{F13}が指定されていた時はIMEをオンにする
	IfInString key,^{F13}
	{
		IME_SET(1)
		StringReplace, key, key, ^{F13}, 
	}
	;--------------- +{F13}が指定されていた時はIMEをオフにする
	IfInString key,+{F13}
	{
		IME_SET(0)
		StringReplace, key, key, +{F13}, 
	}
	;--------------- iniファイルで指定されたキーを送る
	Send %key%
	;--------------- Spaceキーが押された場合は、Space Upとの二重起動を避けるため変数に値をセットする
	IfInString A_ThisHotkey,& Space
	{
		IfInString A_ThisHotkey,Shift
		{
			;--------------- Shift & Spaceキーが押された場合はセット不要
		}Else{
			xInput := 1
		}
	}
Return
