﻿;=========================================== タスク制御関連サブルーチン
ActivateTask:
	;------------------------------------------------ タスク起動時に表示するメッセージを編集する
	tsk_name := task_lancher_name[task_index]
	If (StrLen(tsk_name) == 0) {
		tsk_name := task_name[task_index]
	}
	;------------------------------------------------ タスク切り替えスタイルに応じてタスクを制御する
	If (task_style[task_index] == "1") {
		Gosub ActivateMDITask
	}
	If (task_style[task_index] == "0") {
		Gosub ActivateMultipleTask
	}
Return
;=========================================== MDIタスク制御関連サブルーチン
ActivateMDITask:
	;------------------------------------------------ 指定されたウィンドウをアクティブにする
	window_name := task_class[task_index] . " " . task_name[task_index]
	window_title := task_title[task_index]
	;--------------- 指定されたウィンドウが既にアクティブになっているときは、次のウィンドウ（タブ）をアクティブにする
	IfWinActive %window_name%,%window_title%
	{
		Send ^{Tab}
		Return
	}
	;--------------- 指定されたウィンドウが存在するときは、指定されたウィンドウをアクティブにする
	IfWinExist %window_name%,%window_title%
	{
		WinActivate %window_name%,%window_title%
		Return
	}
	;--------------- 指定されたウィンドウが存在しないときは、指定されたウィンドウを開く
	IfWinNotExist %window_name%,%window_title%
	{
		;--------------- アクティブにするウィンドウの実行ファイル名を取得する
		WinGet, WinProc, ProcessName , %window_name%
		If (WinProc == "ApplicationFrameHost.exe") {
			WinExistIsTrue := 0
			;--------------- ストアアプリのときは、指定されたウィンドウを探してアクティブにする
			WinGet task_list_now,list,%window_name%
			;--------------- 指定されたウィンドウを探す
			Loop %task_list_now% {
				;--------------- ウィンドウIDを取得する
				StringTrimRight win_id,task_list_now%A_Index%,0
				;--------------- ウィンドウタイトルを取得する
				WinGetTitle, WinTitle, ahk_id %win_id%
				IfInString WinTitle, %window_title%
				{
					;--------------- 指定されたウィンドウが見つかったときはアクティブにしてループを抜ける
					WinActivate ahk_id %win_id%
					WinExistIsTrue := 1
					Break
				}
			}
		}Else{
			WinExistIsTrue := 0
		}
		If (WinExistIsTrue == 0) {
			;--------------- 指定されたウィンドウが見つからなかったときは、指定されたウィンドウを開く
			shortcut := task_shortcut[task_index]
			If (StrLen(shortcut) > 0) {
				If (OnChangeModeBeep == 1) {
					SoundBeep,800,100
				}
				If (OnChangeModeToolTip == 1) {
					ShowSplashImage(tsk_name . "を起動します")
					SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
				}
				Send %shortcut%
				WinWait %window_name%,%window_title%,10
				WinActivate %window_name%,%window_title%
				Return
			}Else{
				;--------------- 実行ファイルが登録されている場合は直接起動する
				strWrk := task_class[task_index]
				IF (strWrk == "ahk_exe") {
					If (OnChangeModeBeep == 1) {
						SoundBeep,800,100
					}
					If (OnChangeModeToolTip == 1) {
						ShowSplashImage(tsk_name . "を起動します")
						SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
					}
					strWrk := task_full_path[task_index]
					Run, %strWrk%
				}
			}
		}
	}
Return
;=========================================== マルチタスク制御関連サブルーチン
ActivateMultipleTask:
	WinExistIsTrue := 0
	;------------------------------------------------ 指定されたウィンドウをアクティブにする
	window_name := task_class[task_index] . " " . task_name[task_index]
	window_title := task_title[task_index]
	;--------------- 指定されたウィンドウが存在するときは、指定されたウィンドウをアクティブにする
	IfWinExist %window_name%
	{
		;--------------- 指定されたウィンドウのウィンドウ数とウィンドウidを取得する
		WinGet task_list_now,list,%window_name%
		;--------------- ウィンドウ数が変化しているときは、アクティブにするウィンドウ番号をリセットする
		If (task_list_before[task_index] != task_list_now) {
			;--------------- ウィンドウ数とウィンドウidを保管する
			task_list[task_index] := task_list_now
			;--------------- ウィンドウ数を保管する
			task_list_before[task_index] := task_list_now
			;--------------- ウィンドウIDを保管する
			Loop %task_list_now% {
				;--------------- ウィンドウIDを取得して保管する
				StringTrimRight win_id,task_list_now%A_Index%,0
				task_list_stock[task_index,A_Index] := win_id
			}
			;--------------- アクティブにするウィンドウ番号をリセットする
			If (task_next_activate_ix[task_index] == nul) {
				task_next_activate_ix[task_index] := 1
			}Else{
				;--------------- 前回アクティブにしたウィンドウが閉じられていたとき
				If (task_next_activate_ix[task_index] > task_list_now) {
					task_next_activate_ix[task_index] := task_list_now
				}
			}
		}
		;--------------- 指定されたウィンドウが既にアクティブになっていて、さらに対象ウィンドウが複数あるときは、次にアクティブにするウィンドウ番号をカウントアップする
		IfWinActive %window_name%
		{
			If (task_list[task_index] > 1) {
				If (task_next_activate_ix[task_index] == task_list[task_index]) {
					;--------------- 一巡したときはリセットする
					task_next_activate_ix[task_index] := 1
				}Else{
					task_next_activate_ix[task_index] += 1
				}
			}
		}
		;--------------- ウィンドウをアクティブにする
		Gosub ActivateTargetWindow
		;--------------- ウィンドウがアクティブにならなかったときはウィンドウIDを保管しなおして再度アクティブにする
		IfWinNotActive ahk_id %activate_id%
		{
			;--------------- ウィンドウ数とウィンドウidを保管する
			task_list[task_index] := task_list_now
			;--------------- ウィンドウ数を保管する
			task_list_before[task_index] := task_list_now
			;--------------- ウィンドウIDを保管する
			Loop %task_list_now% {
				;--------------- ウィンドウIDを取得して保管する
				StringTrimRight win_id,task_list_now%A_Index%,0
				task_list_stock[task_index,A_Index] := win_id
			}
			;--------------- アクティブにするウィンドウのIDを取得する
			activate_id := task_list_stock[task_index,task_next_activate_ix[task_index]]
			;--------------- ウィンドウをアクティブにする
			Gosub ActivateTargetWindow
		}
	}
	;--------------- 指定されたウィンドウが存在しないときは、指定されたウィンドウを開く
	If (WinExistIsTrue == 0) {
		shortcut := task_shortcut[task_index]
		If (StrLen(shortcut) > 0) {
			If (OnChangeModeBeep == 1) {
				SoundBeep,800,100
			}
			If (OnChangeModeToolTip == 1) {
				ShowSplashImage(tsk_name . "を起動します")
				SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
			}
			Send %shortcut%
			WinWait %window_name%,%window_title%,10
			WinActivate %window_name%,%window_title%
			task_list_before[task_index] := 0
		}Else{
			;--------------- 実行ファイルが登録されている場合は直接起動する
			strWrk := task_class[task_index]
			IF (strWrk == "ahk_exe") {
				If (OnChangeModeBeep == 1) {
					SoundBeep,800,100
				}
				If (OnChangeModeToolTip == 1) {
					ShowSplashImage(tsk_name . "を起動します")
					SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
				}
				strWrk := task_full_path[task_index]
				Run, %strWrk%
			}
		}
	}
Return
;=========================================== ターゲットウィンドウをアクティブにする
ActivateTargetWindow:
	;--------------- アクティブにするウィンドウのIDを取得する
	activate_id := task_list_stock[task_index,task_next_activate_ix[task_index]]
	;--------------- アクティブにするウィンドウの実行ファイル名を取得する
	WinGet, WinProc, ProcessName , ahk_id %activate_id%
	If (WinProc == "ApplicationFrameHost.exe") {
		;--------------- アクティブにするウィンドウがストアアプリのときは、アクティブにするウィンドウのタイトルと一致するまでウィンドウを探す
		Loop {
			WinGetTitle, WinTitle, ahk_id %activate_id%
			IfInString WinTitle, %window_title%
			{
				;--------------- 一致するウィンドウが見つかったときは、ウィンドウをアクティブにしてループを抜ける
				WinActivate ahk_id %activate_id%
				WinExistIsTrue := 1
				Break
			}Else{
				;--------------- 一致するウィンドウが見つからなかったときは、次のウィンドウをターゲットにする
				If (task_list[task_index] > 1) {
					If (task_next_activate_ix[task_index] == task_list[task_index]) {
						;--------------- 一巡したときは、アクティブにするウィンドウは存在しないのでループを抜ける
						task_next_activate_ix[task_index] := 1
						WinExistIsTrue := 0
						Break
					}Else{
						task_next_activate_ix[task_index] += 1
					}
					activate_id := task_list_stock[task_index,task_next_activate_ix[task_index]]
				}Else{
					;--------------- 候補ウィンドウが一つしかなかったときは、アクティブにするウィンドウは存在しないのでループを抜ける
					WinExistIsTrue := 0
					Break
				}
			}
		}
	}Else{
		;--------------- アクティブにするウィンドウがストアアプリでないときは、そのままウィンドウをアクティブにする
		WinActivate ahk_id %activate_id%
		WinExistIsTrue := 1
	}
Return
;=========================================== アクティブウィンドウを通知領域（タスクトレイ）に収納
SubMinimizeToTaskTray:
	;--------------- アクティブウィンドウのIDを取得する
	WinGet, active_win_id, ID, A
	;--------------- アクティブウィンドウのクラス名を取得する
	WinGetClass, active_win_class, ahk_id %active_win_id%
	;--------------- アクティブウィンドウのタイトルを取得する
	WinGetTitle, active_win_title, ahk_id %active_win_id%
	;--------------- 収納可否を判定する
	If (StrLen(active_win_title) == 0 || active_win_class == "Progman" || active_win_class == "Shell_TrayWnd" || active_win_class == "Windows.UI.Core.CoreWindow" || active_win_class == "NotifyIconOverflowWindow" ) {
		;--------------- ウィンドウタイトルがないもの、デスクトップ、スタートボタン、通知領域（タスクトレイ）などのOSオブジェクトはトレイに収納しない
	}Else{
		IF (task_hidden_ct > 0) {
			Gosub DeleteMinToTaskTrayMenu
		}
		task_hidden_ct += 1
		;--------------- メニューに表示できない文字を置換する
		StringReplace, active_win_title, active_win_title, &, ＆, ReplaceAll
		;--------------- タイトルとIDを配列に格納する
		task_active_id[task_hidden_ct] := active_win_id
		task_active_tl[task_hidden_ct] := active_win_title
		;--------------- 配列からトレイメニューとiniファイルを構築する
		Gosub BuildMinToTaskTrayMenu
		;--------------- アクティブウィンドウを非表示にする
		WinHide, ahk_id %active_win_id%
		;--------------- ツールチップを表示する
		If (OnChangeModeToolTip == 1) {
			ShowSplashImage("通知領域（タスクトレイ）に収納しました")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
		}
		;--------------- 通知音を鳴らす
		If (OnChangeModeBeep == 1) {
			SoundBeep,800,100
		}
	}
Return
;=========================================== 通知領域（タスクトレイ）に収納したウィンドウを元に戻す
RestoreWinFromTaskTray:
	;--------------- 選択されたメニューの選択番号を取得する
	StringReplace, MenuItem, A_ThisMenuItem, &
	StringGetPos, DelimtPos, MenuItem, :
	StartPos := 1
	DelimtLen := DelimtPos + 1 - StartPos
	StringMid, win_id_no, MenuItem, StartPos, DelimtLen
	;--------------- 元に戻すウィンドウのIDをセットする
	activate_win_id := task_active_id[win_id_no]
	;--------------- ウィンドウを再表示する
	WinShow, ahk_id %activate_win_id%
	;--------------- ウィンドウをアクティブにする
	WinActivate, ahk_id %activate_win_id%
	;--------------- トレイメニューを削除する
	Gosub DeleteMinToTaskTrayMenu
	;--------------- 配列を更新する
	rebuild := task_hidden_ct - win_id_no
	ix := win_id_no
	Loop %rebuild% {
		task_active_id[ix] := task_active_id[ix + 1]
		task_active_tl[ix] := task_active_tl[ix + 1]
		ix += 1
	}
	task_hidden_ct -= 1
	;--------------- 配列からトレイメニューとiniファイルを構築する
	Gosub BuildMinToTaskTrayMenu
	;--------------- ツールチップを表示する
	If (OnChangeModeToolTip == 1) {
		ShowSplashImage("通知領域（タスクトレイ）から戻しました")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	}
	;--------------- 通知音を鳴らす
	If (OnChangeModeBeep == 1) {
		SoundBeep,800,100
	}
Return
;=========================================== トレイメニューを削除する
DeleteMinToTaskTrayMenu:
	;--------------- 収納ウィンドウが2つ以上あるときは「すべて戻す」メニューを削除する
	IF (task_hidden_ct > 1) {
		Menu %tray_menu_name%,Delete,%tray_menu_all_restore%
	}
	Loop %task_hidden_ct% {
		menu_title := task_active_tl[A_Index]
		Menu %tray_menu_name%,Delete,%A_Index%:%menu_title%
	}
	Menu Tray,Delete,%tray_menu_name%
Return
;=========================================== 通知領域（タスクトレイ）に収納したウィンドウをすべて元に戻す
RestoreAllWinFromTaskTray:
	If (task_hidden_ct > 0) {
		Loop %task_hidden_ct% {
			;--------------- 元に戻すウィンドウのIDをセットする
			activate_win_id := task_active_id[A_Index]
			;--------------- ウィンドウを再表示する
			WinShow, ahk_id %activate_win_id%
			;--------------- ウィンドウをアクティブにする
			WinActivate, ahk_id %activate_win_id%
		}
		;--------------- トレイメニューを削除する
		Gosub DeleteMinToTaskTrayMenu
		;--------------- iniファイルを削除する
		IniDelete,%ini_file_name%,HIDDEN_APP
		;--------------- カウンターをクリアする
		task_hidden_ct := 0
		;--------------- ツールチップを表示する
		If (OnChangeModeToolTip == 1) {
			ShowSplashImage("通知領域（タスクトレイ）から戻しました")
			SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
		}
		;--------------- 通知音を鳴らす
		If (OnChangeModeBeep == 1) {
			SoundBeep,800,100
		}	
	}
Return
;=========================================== 配列からトレイメニューとiniファイルを構築する
BuildMinToTaskTrayMenu:
	;--------------- iniファイルを一旦削除する
	IniDelete,%ini_file_name%,HIDDEN_APP
	;--------------- 収納ウィンドウが2つ以上あるときは「すべて戻す」メニューを先頭に追加する
	If (task_hidden_ct > 1) {
		Menu %tray_menu_name%,Add,%tray_menu_all_restore%,RestoreAllWinFromTaskTray
	}
	;--------------- トレイメニューとiniファイル再構築する
	Loop %task_hidden_ct% {
		id := task_active_id[A_Index]
		tl := task_active_tl[A_Index]
		Menu %tray_menu_name%,Add,%A_Index%:%tl%,RestoreWinFromTaskTray
		IniWrite,%id%,%ini_file_name%,HIDDEN_APP,Id%A_Index%
		IniWrite,%tl%,%ini_file_name%,HIDDEN_APP,Title%A_Index%
	}
	If (task_hidden_ct > 0) {
		Menu Tray,Add,%tray_menu_name%,:%tray_menu_name%
	}
Return
;=========================================== アクティブウィンドウを最大化またはリサイズ
SubMaximizeActvWin:
	;--------------- アクティブウィンドウのIDを取得する
	WinGet, activate_win_id, ID, A
	;--------------- アクティブウィンドウの状態を取得する
	WinGet, active_win_max, MinMax, ahk_id %activate_win_id%
	If (active_win_max == 1) {
		;--------------- 最大化していたらリサイズ
		WinRestore, ahk_id %activate_win_id%
	}Else{
		;--------------- 最大化でなければ最大化する
		WinMaximize, ahk_id %activate_win_id%
	}
Return
;=========================================== アクティブウィンドウを最小化
SubMinimizeActvWin:
	;--------------- アクティブウィンドウのIDを取得する
	WinGet, activate_win_id, ID, A
	;--------------- 最小化する
	WinMinimize, ahk_id %activate_win_id%
Return