﻿;=========================================== リスト形式のタスクスイッチャー
SubTaskSwitcherM:
	RunByMouse := 1
	Gosub SubTaskSwitcher
	RunByMouse := 0
Return
;=========================================== リスト形式のタスクスイッチャー
SubTaskSwitcher:
	If (ExistTaskSwitcher == 1) {
		;------------------------------ すでにタスクスイッチャー画面が表示されているときは画面を閉じる
		ExistTaskSwitcher := 0
		WinClose, %GuiTitle%
		Gui, Destroy
		;--------------- リロードフラグをクリアする
		ReloadTaskSwitcher := 0
		Return
	}
	;If (OnChangeModeBeep == 1) {
	;	SoundBeep,800,100
	;}
	;If (OnChangeModeToolTip == 1) {
	;	ShowSplashImage("タスクスイッチャーを起動します")
	;	SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	;}
	;------------------------------ GUI画面の新規作成
	ExistTaskSwitcher := 1
	GuiTitle := "タスクスイッチャー"
	Gui, New,, %GuiTitle%
	;------------------------------ GUI画面の初期設定
	Gui,Margin,0,0
	Gui,-0x00800000 +ToolWindow +AlwaysOnTop -0x00400000
	Gui, Font, s11
	;------------------------------ アイコン格納用のイメージリストを作成する
	himl := DllCall("ImageList_Create",Int,32,Int,32,UInt,0x21,Int,w,Int,w,UInt)
	;------------------------------ ウィンドウ情報を保管する変数を定義する
	Global TaskIcon := Object()
	Global TaskId := Object()
	Global TaskTitle := Object()
	;****************************************************************************** タスクランチャーを構築する
	;------------------------------ キー配列設定からタスク情報を抽出する
	CtrL := 0
	window_title := ""
	For, task_index, tsk_l_name in task_lancher_name {
		;------------------------------ アプリ名称が登録されている場合はイメージリストにアイコンを格納する
		If (StrLen(tsk_l_name) > 0) {
			;------------------------------ キー配列に登録されているアプリ（実行ファイル）が起動しているか確認する
			window_name := task_class[task_index] . " " . task_name[task_index]
			IfWinExist %window_name%
			{
				;------------------------------ アプリが起動している場合は開いているウィンドウからタスク情報を取得する
				WinGet TaskList, List, %window_name%
				;------------------------------ タスク情報を配列に格納する
				ix := 1
				Ctr := CtrL
				window_title := task_title[task_index]
				Gosub StockWindowInfo
				;------------------------------ タスク情報が配列に格納されたか確認する
				If (CtrL == Ctr) {
					;------------------------------ カウンターが増えてない場合は、タスク情報が配列に格納されていない
					;（アプリは起動しているが、ウィンドウタイトルが一致しなかった）
					;------------------------------ アプリが起動していない場合はキー配列登録情報からタスク情報する
					Gosub StockWindowInfoFromKeyTable
				}Else{
					;------------------------------ タスク情報が配列に格納された場合は、カウンターを復元する
					CtrL := Ctr
				}
			}Else{
				;------------------------------ アプリが起動していない場合はキー配列登録情報からタスク情報する
				Gosub StockWindowInfoFromKeyTable
			}
		}
	}
	;****************************************************************************** タスクスイッチャーを構築する
	;------------------------------ 現在開いている全てのウィンドウ情報を取得する
	WinGet TaskList,List,,,5eZg~G+X9)JAIofIJBgcIe\ZTZ`e-'DpmO
	;------------------------------ 開いているウィンドウの情報を配列に格納する
	ix := 2
	Ctr := 0
	Gosub StockWindowInfo
	CtrT := Ctr
	;****************************************************************************** GUI画面の表示方法等を決定する
	If (RunByMouse == 1) {
		;----------------------------------------------------- マウス起動の場合
		;------------------------------ マウスカーソルが存在するモニターの番号、マウスの座標位置、モニターの数を取得する
		If (ReloadTaskSwitcher == 1) {
			;
		}Else{
			WhereIsCursorOnMonitor(MonNo, MousePosX, MousePosY, MonCount)
		}
	}Else{
		;------------------------------ キーボード起動の場合
		MonNo := 1
	}
	;------------------------------ モニターサイズ、境界座標を取得する
	GetMonitorSize(MonNo, MonWidth, MonHeight, MonLeft, MonRight, MonTop, MonBottom)
	;------------------------------リストビューのサイズを決定する
	IconHeight := 33
	If (SplitTaskSwitcher == 1 && CtrL > 0) {
		If (CtrL > CtrT) {
			LvHeight := CtrL * IconHeight
		}Else{
			LvHeight := CtrT * IconHeight
		}
		LvWidth := 400
	}Else{
		LvHeight := (CtrL + CtrT) * IconHeight
		LvWidth := 800
	}
	If (LvHeight > MonHeight / 2) {
		LvHeight := (MonHeight / 2 // IconHeight) * IconHeight
	}
	;****************************************************************************** リストビューにタスク情報を格納する
	;------------------------------ ランチャー・リストビューにタスク情報を格納する
	Gui, Add, ListView, x0 y0 w%LvWidth% h%LvHeight% -E0x00000200 -Multi AltSubmit -Hdr Border vTaskLancherLV gOnActionTaskLancherLV,WindowTitle
	LV_SetImageList(himl,1)
	Loop %CtrL% {
		LV_Add("Icon" . TaskIcon[1,A_Index], TaskTitle[1,A_Index])
	}
	If (SplitTaskSwitcher == 1 && CtrL > 0) {
		LV_Modify(1, "Select")
		LV_Modify(1, "Focus")
	}
	;------------------------------ スイッチャー・リストビューにタスク情報を格納する
	If (SplitTaskSwitcher == 1 && CtrL > 0) {
		Gui, Add, ListView, x%LvWidth% y0 w%LvWidth% h%LvHeight% -E0x00000200 -Multi AltSubmit -Hdr Border vTaskSwitcherLV gOnActionTaskSwitcherLV,WindowTitle
	}
	LV_SetImageList(himl,1)
	Loop %CtrT% {
		LV_Add("Icon" . TaskIcon[2,A_Index], TaskTitle[2,A_Index])
	}
	LV_Modify(1, "Select")
	LV_Modify(1, "Focus")
	;****************************************************************************** GUI画面を表示する
	If (RunByMouse == 1) {
		;------------------------------ GUI画面を表示するX座標を求める
		If (SplitTaskSwitcher == 1 && CtrL > 0) {
			LvWidth := LvWidth * 2
		}
		TargetPosX := MousePosX - LvWidth // 2
		If (TargetPosX < MonLeft) {
			TargetPosX := MonLeft
		}
		If (MonRight < TargetPosX + LvWidth) {
			TargetPosX := MonRight - LvWidth
		}
		;------------------------------ GUI画面を表示するY座標を求める
		TargetPosY := MousePosY - LvHeight // 2
		If (TargetPosY < MonTop) {
			TargetPosY := MonTop
		}
		If (MonBottom < TargetPosY + LvHeight) {
			TargetPosY := MonBottom - LvHeight
		}
		;------------------------------ GUI画面を表示する（マウス起動の場合）
		;Gui, Show, x%TargetPosX% y%TargetPosY% AutoSize, %GuiTitle%
		Gui, Show, x%TargetPosX% y%TargetPosY%, %GuiTitle%
	}Else{
		;------------------------------ GUI画面を表示する（キーボード起動の場合）
		;Gui, Show, AutoSize, %GuiTitle%
		Gui, Show, , %GuiTitle%
	}
Return
;================================================================== ランチャーリストビューの項目がクリックされたときの処理
OnActionTaskLancherLV:
	If (SplitTaskSwitcher == 1 && CtrL > 0) {
		ix := 1
	}
	Gosub OnActionLV
Return
;================================================================== スイッチャーリストビューの項目がクリックされたときの処理
OnActionTaskSwitcherLV:
	If (SplitTaskSwitcher == 1 && CtrL > 0) {
		ix := 2
	}
	Gosub OnActionLV
Return
;================================================================== リストビューの項目がクリックされたときの処理
OnActionLV:
	;------------------------------ リストビューの選択状態が変化した時は、その時点で選択されている行の番号を保管する
	If (A_GuiEvent == "I" || A_GuiEvent == "Normal" || A_GuiEvent == "RightClick") {
		SelectedRow := A_EventInfo
		If (SplitTaskSwitcher == 1 && CtrL > 0) {
			SelectedTask := A_EventInfo
		}Else{
			If (A_EventInfo > CtrL) {
				ix := 2
				SelectedTask := A_EventInfo - CtrL
			}Else{
				ix := 1
				SelectedTask := A_EventInfo
			}
		}
	}
	;------------------------------ 先頭行が選択されている状態でUpキーが押されたときは末尾行に移動する
	If (A_GuiEvent == "K" && A_EventInfo == "38") {
		If (SelectedRow == 1) {
			If (SplitTaskSwitcher == 1 && CtrL > 0) {
				If (ix == 1) {
					;-------------------------------------- ランチャーリストビューを処理対象に変更する
					Gui,ListView,TaskLancherLV
					SelectedRow := CtrL
				}Else{
					;-------------------------------------- スイッチャーリストビューを処理対象に変更する
					Gui,ListView,TaskSwitcherLV
					SelectedRow := CtrT
				}
			}Else{
				SelectedRow := CtrL + CtrT
			}
			LV_Modify(SelectedRow, "Select")
			LV_Modify(SelectedRow, "Focus")
		}
	}
	;------------------------------ 末尾行が選択されている状態でDownキーが押されたときは先頭行に移動する
	If (A_GuiEvent == "K" && A_EventInfo == "40") {
		If (SplitTaskSwitcher == 1 && CtrL > 0) {
			If (ix == 1 && SelectedRow == CtrL) {
				;-------------------------------------- ランチャーリストビューを処理対象に変更する
				Gui,ListView,TaskLancherLV
				SelectedRow := 1
				LV_Modify(SelectedRow, "Select")
				LV_Modify(SelectedRow, "Focus")
			}
			If (ix == 2 && SelectedRow == CtrT) {
				;-------------------------------------- スイッチャーリストビューを処理対象に変更する
				Gui,ListView,TaskSwitcherLV
				SelectedRow := 1
				LV_Modify(SelectedRow, "Select")
				LV_Modify(SelectedRow, "Focus")
			}
		}Else{
			If (SelectedRow == CtrL + CtrT) {
				SelectedRow := 1
			LV_Modify(SelectedRow, "Select")
			LV_Modify(SelectedRow, "Focus")
			}
		}
	}
	;------------------------------ リストビューの項目をクリックまたはLeftキーを押したときは、選択したタスクをアクティブにする
	If (A_GuiEvent == "Normal" || (A_GuiEvent == "K" && A_EventInfo == "37")) {
		ActivateID := TaskID[ix,SelectedTask]
		IfWinExist ahk_id %ActivateID%
		{
			;------------------------------ 選択したタスクが起動している場合はアクティブにする
			WinActivate ahk_id %ActivateID%
		}Else{
			;------------------------------ 選択したタスクが起動していない場合は起動する
			task_index := ActivateID
			Gosub ActivateTask
		}
		;--------------- タスクスイッチャーを閉じる
		ExistTaskSwitcher := 0
		Gui, Destroy
		;--------------- リロードフラグをクリアする
		ReloadTaskSwitcher := 0
	}
	;------------------------------ リストビューの項目を右クリックまたはRightキーを押したときは、選択したタスクを閉じる
	If (A_GuiEvent == "RightClick" || (A_GuiEvent == "K" && A_EventInfo == "39")) {
		CloseID := TaskID[ix,SelectedTask]
		WinClose ahk_id %CloseID%
		;--------------- タスクスイッチャーを閉じる
		ExistTaskSwitcher := 0
		Gui, Destroy
		;--------------- タスクスイッチャーを再度表示する
		If (GetKeyState("Ctrl","p") || GetKeyState("Alt","p")) {
			If (A_GuiEvent == "RightClick") {
				;--------------- 前回の表示位置に再表示するようにリロードフラグを立てる
				ReloadTaskSwitcher := 1
				Gosub SubTaskSwitcherM
			}Else{
				Gosub SubTaskSwitcher
			}
		}
		;--------------- マウスジェスチャーを無効にするため判定変数をセットする
		RBtnDnAtTaskSwitcher := 1
	}
	;------------------------------ リストビューの項目でBackSpaceキーを押したときは、選択したタスクを閉じでタスクスイッチャーを再表示する
	If (A_GuiEvent == "K" && A_EventInfo == "8") {
		CloseID := TaskID[ix,SelectedTask]
		WinClose ahk_id %CloseID%
		;--------------- タスクスイッチャーを閉じる
		ExistTaskSwitcher := 0
		Gui, Destroy
		;--------------- タスクスイッチャーを再度表示する
		Gosub SubTaskSwitcher
	}
	;------------------------------ リストビューの項目でPgDnキーを押したときは、選択したタスクを最小化する
	If (A_GuiEvent == "K" && A_EventInfo == "34") {
		MinimizeID := TaskID[ix,SelectedTask]
		WinMinimize, ahk_id %MinimizeID%
		;--------------- タスクスイッチャーを閉じる
		ExistTaskSwitcher := 0
		Gui, Destroy
		;--------------- タスクスイッチャーを再度表示する
		If (GetKeyState("Ctrl","p")) {
			Gosub SubTaskSwitcher
		}
	}
Return
;================================================================== 開いているウィンドウの情報を配列に格納する
StockWindowInfo:
	;------------------------------ 開いているウィンドウの情報を配列に格納する
	WinProcPre := ""
	WinStylePre := ""
	Loop %TaskList% {
		;------------------------------ ウィンドウIDを取得する
		StringTrimRight WinID,TaskList%A_Index%,0
		;------------------------------ タスクスイッチャー処理のときはタスクランチャー側に格納されていないか確認する
		DoStockWindowInfo := 1
		If (ix == 2) {
			Loop %CtrL% {
				If (TaskID[1,A_Index] == WinID) {
					DoStockWindowInfo := 0
					Break
				}
			}
		}
		;------------------------------ タスクスイッチャー処理のときは、タスクランチャー側に登録されていないときだけ処理する
		If (DoStockWindowInfo == 1) {
			;------------------------------ ウィンドウタイトルを取得する
			WinGetTitle, WinTitle, ahk_id %WinID%
			;------------------------------ アプリが起動している場合は、ウィンドウタイトルがキー配列に登録されているものと一致するか確認する
			IfInString WinTitle, %window_title%
			{
				;------------------------------ ウィンドウスタイルを取得する
				WinGet, WinStyle, Style, ahk_id %WinID%
				;------------------------------ ウィンドウ拡張スタイルを取得する
				WinGet, WinExStyle, ExStyle, ahk_id %WinID%
				;------------------------------ ウィンドウポジションを取得する
				DetectHiddenWindows, off
				WinGetPos, WinX, WinY, WinW, WinH, ahk_id %WinID%
				;------------------------------ 実行ファイル名を取得する
				WinGet, WinProc, ProcessName , ahk_id %WinID%
				;------------------------------ 「ウィンドウタイトルがある　＆　ウィンドウサイズが０より大きい　＆　（タイトルバーがある　OR　リサイズ可能なウィンドウ枠がある）」　＆　タイトルバーやボーダーがないポップアップウィンドウでないウィンドウのみ対象とする
				;If (WinProc <> "KMCustomizer.exe" && WinProc <> "AutoHotkey.exe" && StrLen(WinTitle) > 0 && WinW > 0 && WinH > 0 && ((WinStyle & 0x00C00000) || (WinStyle & 0x00040000) || (WinStyle & 0x000A0000))) {
				;If (WinProc <> "ShowShutdownTimer.exe" && StrLen(WinTitle) > 0 && WinW > 0 && WinH > 0 && ((WinStyle & 0x00C00000) || (WinStyle & 0x00040000) || (WinStyle & 0x000A0000)) && (WinStyle != 0x94CE0000) && (WinStyle != 0x94CC0000) && (WinStyle != 0x94CD0000)) {
				If (WinProc <> "ShowShutdownTimer.exe" && StrLen(WinTitle) > 0 && WinW > 0 && WinH > 0 && ((WinStyle & 0x00C00000) || (WinStyle & 0x00040000) || (WinStyle & 0x000A0000))) {
					If (WinExStyle & 0x00000080) {
						;------------------------------ ウィンドウ拡張スタイルがツールウィンドウのときは表示しない
					}Else{
						;------------------------------ アイコンハンドルを取得する
						IconHandle := GetIconHandle(WinID)
						;------------------------------ イメージリストにアイコンを格納する
						WinIcon := DllCall("ImageList_AddIcon",Int,himl,Int,IconHandle,Int) + 1
						;------------------------------ ウィンドウ情報を配列に格納する
						If ((WinProc == WinProcPre) && (RegExMatch(WinStylePre, "0x94C.0000"))) {
							;------------------------------ ポップアップまたは子ウィンドウは上書きして表示させない
						}Else{
							Ctr += 1
						}
						TaskIcon[ix,Ctr] := WinIcon
						TaskID[ix,Ctr] := WinID
						;TaskTitle[ix,Ctr] := WinTitle . "," . WinStyle . "," . WinX . "," . WinY . "," . WinExStyle . "," . WinProc
						TaskTitle[ix,Ctr] := WinTitle
						WinProcPre := WinProc
						WinStylePre := WinStyle
					}
				}
			}
		}
	}
Return
;================================================================== キー配列登録情報を配列に格納する
StockWindowInfoFromKeyTable:
	FullPathName := task_full_path[task_index]
	IconHandle := GetIconHandleFromFullPath(FullPathName)
	WinIcon := DllCall("ImageList_AddIcon",Int,himl,Int,IconHandle,Int) + 1
	;------------------------------ タスク情報を配列に格納する
	CtrL += 1
	TaskIcon[1,CtrL] := WinIcon
	TaskId[1,CtrL] := task_index
	TaskTitle[1,CtrL] := "=> " . tsk_l_name
Return
;================================================================== アイコンハンドルを取得する
GetIconHandle(WinID) {
	;------------------------------ 指定されたウィンドウIDの実行ファイルからアイコンハンドルを取得する
	VarSetCapacity(FullPathName,256)
	WinGet, FullPathName, ProcessPath, ahk_id %WinID%
	;------------------------------ 実行ファイルのフルパス名からアイコンハンドルを取得する
	IconHandle := GetIconHandleFromFullPath(FullPathName)
	Return, IconHandle
}
;================================================================== 実行ファイルのフルパス名からアイコンハンドルを取得する
GetIconHandleFromFullPath(FullPathName) {
	;------------------------------ アイコンハンドルを取得するためのインスタンスを取得する
	hinst := DllCall("GetModuleHandle",UInt,0, UInt)
	;------------------------------ ウィンドウのアイコンハンドルを取得する
	IconHandle := DllCall("Shell32.dll\ExtractAssociatedIcon", UInt,hinst, Str,FullPathName, UShortP,0, UInt)
	Return, IconHandle
}