﻿;=========================================== ツール関連関数
;------------------------------------------------ 指定したウィンドウを常に前面表示する
SubAlwaysOnTop:
	;-------------------------------------- 常に前面表示に変更するウィンドウのタイトルに付与するテキストを設定
	AddTextAlwaysOnTop := "▲常に前面表示▲"
	;------------------------------ ウィンドウタイトルを取得する
	WinGetTitle, WinTitle, A
	;------------------------------ ウィンドウの拡張スタイルを取得する
	WinGet, WinExStyle, ExStyle, A
	If (WinExStyle & 0x00000008) {
		;------------------------------ 常に前面表示の場合はウィンドウタイトルを元に戻す
		StringReplace WinTitle,WinTitle,%AddTextAlwaysOnTop%,,All
	}Else{
		;------------------------------ 常に前面表示でない場合はウィンドウタイトルを変更する
		WinTitle := AddTextAlwaysOnTop . WinTitle
	}
	;------------------------------ ウィンドウタイトルを変更する
	WinSetTitle, A, , %WinTitle%
	;------------------------------ 常に前面表示を切替える
	WinSet, AlwaysOnTop, TOGGLE, A
	;------------------------------ 通知音をならす
	If (OnChangeModeBeep == 1) {
		SoundBeep,800,100
	}
	;------------------------------ 通知メッセージを表示する
	If (OnChangeModeToolTip == 1) {
		ShowSplashImage("常に前面表示の状態を変更しました")
		SetTimer RemoveSplashImage,%OnChangeModeToolTipDspTime%
	}
Return
;------------------------------------------------ このスクリプトをリロードする
SubReload:
	Reload
Return
;------------------------------------------------ 一定時間経過したらツールチップを閉じる
RemoveToolTip:
	SetTimer RemoveToolTip,off
	ToolTip
Return
;------------------------------------------------ ツールチップ（スプラッシュイメージ）を表示する
ShowSplashImage(text) {
	SplashImage,,B1 FM12 CWFFFFA2,,%text%
}
;------------------------------------------------ ツールチップ（スプラッシュイメージ）を閉じる
HideSplashImage() {
	SplashImage,off
}
;------------------------------------------------ 一定時間経過したらツールチップ（スプラッシュイメージ）を閉じる
RemoveSplashImage:
	SetTimer RemoveSplashImage,off
	SplashImage,off
Return
;------------------------------------------------ カラーピッカー
; カーソル位置の色を取得するAutoHotkeyスクリプトに公開されたスクリプトを使用
; https://hail2u.net/blog/coding/get-cursor-pos-color-ahk.html
;
SubColorPicker:
	global piccolor_flg
	CoordMode,Mouse,Screen
	MouseGetPos, MouseX, MouseY

	PixelGetColor, color, %MouseX%, %MouseY%, Slow

	StringMid, red, color, 7, 2
	StringMid, green, color, 5, 2
	StringMid, blue, color, 3, 2

	red_dec := "0x" . red
	green_dec := "0x" . green
	blue_dec	:= "0x" . blue

	SetFormat, IntegerFast, Decimal
	red_dec += 0
	green_dec += 0
	blue_dec	+= 0

	If (piccolor_flg == nul || piccolor_flg == 0) {		
		;ToolTip, rgb(%red%`, %green%`, %blue%) rgb(%red_dec%`, %green_dec%`, %blue_dec%) pos(%MouseX%`, %MouseY%)
		cp_text = rgb(%red%, %green%, %blue%) rgb(%red_dec%, %green_dec%, %blue_dec%) pos(%MouseX%, %MouseY%)
		ShowSplashImage(cp_text)
		Clipboard = rgb(%red%, %green%, %blue%) rgb(%red_dec%`, %green_dec%`, %blue_dec%) pos(%MouseX%, %MouseY%)
		piccolor_flg = 1
	}Else{
		;ToolTip,
		HideSplashImage()
		piccolor_flg = 0
	}
Return
;-------------------------------------- AutoHotkey以外のウィンドウがアクティブになるまで待つ
WaitExptAutohotkeyWin(LimitSec) {
	brk_cnt := 0
	loop {
		WinGet, WinExeName, ProcessName, A
		Sleep 500
		brk_cnt += 0.5
	} until WinExeName != "AutoHotkey.exe" && WinExeName != "KMCustomizer_f.exe" && WinExeName != "KMCustomizer_k.exe" && WinExeName != "KMCustomizer_m.exe" || brk_cnt == LimitSec
	If (brk_cnt == LimitSec) {
		Return -1
	}Else{
		Return 0
	}
}
;-------------------------------------- タスクバーの表示・非表示を切り替える
SubShowHideTaskBar:
	If WinExist("ahk_class Shell_TrayWnd") {
		ShowTaskBarForce := 0
		WinHide, ahk_class Shell_TrayWnd
		WinHide, ahk_class Shell_SecondaryTrayWnd
	}Else{
		ShowTaskBarForce := 1
		WinShow, ahk_class Shell_TrayWnd
		WinShow, ahk_class Shell_SecondaryTrayWnd
		WinActivate, ahk_class Shell_TrayWnd
		WinActivate, ahk_class Shell_SecondaryTrayWnd
	}
Return
;-------------------------------------- タスクバーを表示する
ShowTaskBar() {
	WinShow, ahk_class Shell_TrayWnd
	WinShow, ahk_class Shell_SecondaryTrayWnd
	WinActivate, ahk_class Shell_TrayWnd
	WinActivate, ahk_class Shell_SecondaryTrayWnd
}
;-------------------------------------- タスクバーを隠する
HideTaskBar() {
	WinHide, ahk_class Shell_TrayWnd
	WinHide, ahk_class Shell_SecondaryTrayWnd
}